/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.service.AttItemSpecServiceImpl;
import kd.wtc.wtes.business.service.IAttItemSpecService;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerAttItemSpec
implements TieParamInitializer {
    protected IAttItemSpecService attItemSpecService;

    public TieInitializerAttItemSpec(IAttItemSpecService attItemSpecService) {
        this.attItemSpecService = attItemSpecService;
    }

    public TieInitializerAttItemSpec() {
        this.attItemSpecService = new AttItemSpecServiceImpl();
    }

    @Override
    public InitParamResult init(InitParam initRequest) {
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        Map<Long, List<AttItemSpec>> bo2His = this.getAttItemSpecMap(initRequest);
        List<TimeSeqBo<AttItemSpec>> attItemSpecsBo = this.listTimeSeqBo(bo2His, warnInfoList);
        AttItemSpecData attItemSpecData = AttItemSpecData.of(attItemSpecsBo);
        if (CollectionUtils.isNotEmpty(warnInfoList)) {
            String warnInfo = this.getWarnInfo(warnInfoList);
            return InitParamResult.partial(attItemSpecData, new TieMessageStd(TieMsgLevel.WARNING, warnInfo));
        }
        return InitParamResult.success(attItemSpecData);
    }

    @Override
    public String category() {
        return "ATT_ITEM_SPEC";
    }

    public void setAttItemSpecService(IAttItemSpecService attItemSpecService) {
        this.attItemSpecService = attItemSpecService;
    }

    private Map<Long, List<AttItemSpec>> getAttItemSpecMap(InitParam initRequest) {
        Optional<PerAttPeriod> optionalMax;
        LocalDate periodEndDate;
        AttPeriodTable attPeriodTable = (AttPeriodTable)initRequest.getInitParams().get("ATT_PERIOD");
        Optional<PerAttPeriod> optionalMin = attPeriodTable.getAccountMinAttPeriodBeginDate();
        LocalDate periodStartDate = optionalMin.isPresent() ? WTCDateUtils.toLocalDate((Date)optionalMin.get().getPerAttBeginDate()) : initRequest.getStartDate();
        List<AttItemSpec> attItemSpecs = this.attItemSpecService.listValidHisVersionsInRangeDate(periodStartDate, periodEndDate = (optionalMax = attPeriodTable.getAccountMaxAttPeriodEndDate()).isPresent() ? WTCDateUtils.toLocalDate((Date)optionalMax.get().getPerAttEndDate()) : initRequest.getEndDate());
        if (attItemSpecs.isEmpty()) {
            return Collections.emptyMap();
        }
        return attItemSpecs.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
    }

    private List<TimeSeqBo<AttItemSpec>> listTimeSeqBo(Map<Long, List<AttItemSpec>> bo2His, List<Long> warnInfoList) {
        ArrayList<TimeSeqBo<AttItemSpec>> attItemSpecsBo = new ArrayList<TimeSeqBo<AttItemSpec>>(bo2His.size());
        bo2His.forEach((bid, attItemSpecs) -> {
            try {
                AttItemSpec attItemSpec = (AttItemSpec)((Object)((Object)attItemSpecs.get(0)));
                TimeSeqBo timeSeqBo = attItemSpec.hasTimeSeqInfo() ? TimeSeqBo.ofMultiTimeSeq((Collection)attItemSpecs) : TimeSeqBo.ofNonTimeSeq((TimeSeqVersion)attItemSpec);
                attItemSpecsBo.add(timeSeqBo);
            }
            catch (Exception e) {
                warnInfoList.add((Long)bid);
            }
        });
        return attItemSpecsBo;
    }

    private String getWarnInfo(List<Long> warnInfoList) {
        return "attItemSpec happen exception, key:[" + StringUtils.join(warnInfoList, (String)",") + "]";
    }
}

