/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtes.business.tie.init.perattperiod.OnQueryInitParamOfPerAttPeriodEvent;
import kd.sdk.wtc.wtes.business.tie.init.perattperiod.PerAttPeriodQueryParamExt;
import kd.sdk.wtc.wtes.business.tie.init.perattperiod.TieInitAttPeriodExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.executor.timeaffiliation.util.AscriptionUtils;
import kd.wtc.wtes.business.ext.model.perattperiod.PerAttPeriodQueryParamExtImpl;
import kd.wtc.wtes.business.model.AttPeriodTable;

public class TieInitializerAttPeriod
implements TieParamInitializer {
    private static final Log LOG = LogFactory.getLog(TieInitializerAttPeriod.class);

    @Override
    public InitParamResult init(InitParam initRequest) {
        List<Long> attPersonIds = initRequest.getAttPersonIds();
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttPersonIdSet(new HashSet<Long>(attPersonIds));
        queryParam.setStartDate(WTCDateUtils.toDate((LocalDate)initRequest.getStartDate()));
        queryParam.setEndDate(WTCDateUtils.toDate((LocalDate)initRequest.getEndDate()));
        this.invokePerAttPeriodInitExtPlugin(queryParam);
        List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        Map<Long, List<PerAttPeriod>> map = perAttPeriodList.stream().collect(Collectors.groupingBy(PerAttPeriod::getPersonId));
        Set<Long> timeAscriptionIdSet = perAttPeriodList.stream().map(PerAttPeriod::getMhsa).collect(Collectors.toSet());
        Map<Long, TimeSeqBo<TimeAscriptionRule>> timeAscriptionBoMap = AscriptionUtils.getTimeAscriptionRuleBoMap(timeAscriptionIdSet, initRequest.getStartDate(), initRequest.getEndDate());
        return InitParamResult.success(new AttPeriodTable(map, timeAscriptionBoMap));
    }

    @Override
    public String category() {
        return "ATT_PERIOD";
    }

    private void invokePerAttPeriodInitExtPlugin(PerAttPeriodQueryParam queryParam) {
        String select = PerAttPeriodQueryParam.COMMON_QUERYFIELDS;
        queryParam.setProperties(select);
        WTCPluginProxy tieInitParamExtPluginProxy = WTCPluginProxyFactory.create(TieInitAttPeriodExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.perattperiod.TieInitAttPeriodExtPlugin");
        tieInitParamExtPluginProxy.invokeReplace(plugin -> {
            OnQueryInitParamOfPerAttPeriodEvent event = new OnQueryInitParamOfPerAttPeriodEvent((PerAttPeriodQueryParamExt)new PerAttPeriodQueryParamExtImpl(queryParam));
            plugin.onQueryAttPeriod(event);
            if (WTCCollections.isNotEmpty((Collection)event.getExtKeys())) {
                Set propertiesSet = Arrays.stream(WTCStringUtils.split((String)select, (String)",")).map(WTCStringUtils::trim).collect(Collectors.toSet());
                propertiesSet.addAll(event.getExtKeys());
                queryParam.setProperties(WTCStringUtils.join(new ArrayList(propertiesSet), (String)","));
                queryParam.setExtKeys(event.getExtKeys());
            }
        });
    }
}

