/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonHisResult;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.service.IAttPersonInfoService;
import kd.wtc.wtes.business.service.impl.AttPersonInfoServiceImpl;

public class TieInitializerAttPersonInfo
implements TieParamInitializer {
    public static final String ctrl_skipGenEmployeeDate = "skipGenEmployeeDate";

    @Override
    public InitParamResult init(InitParam initRequest) {
        return this.doInit(initRequest, Collections.emptyMap());
    }

    public InitParamResult doInit(InitParam initRequest, Map<String, Object> ctrlArgs) {
        IAttPersonInfoService attPersonInfoService = (IAttPersonInfoService)WTCAppContextHelper.getBean(AttPersonInfoServiceImpl.class);
        LocalDate endDay = initRequest.getEndDate().plusDays(1L);
        AttendPersonHisResult attendPersonHisResult = attPersonInfoService.getAttendPersonModelResult(initRequest.getAttPersonIds(), initRequest.getStartDate(), endDay);
        AttendPersonData attendPersonData = AttendPersonData.of(attendPersonHisResult);
        if (attendPersonHisResult != null && !ctrlArgs.containsKey(ctrl_skipGenEmployeeDate)) {
            List attendPersonList = attendPersonHisResult.getAttendPeople();
            Set empIdSet = attendPersonList.stream().map(ele -> ele.getEmployeeMap()).filter(Objects::nonNull).flatMap(ele -> ele.values().stream()).filter(Objects::nonNull).map(TimeSeqBo::getBid).collect(Collectors.toSet());
            attendPersonData.setExtAttribute("AllEmployeeIDS", empIdSet);
        }
        return InitParamResult.success((Object)attendPersonData);
    }

    @Override
    public String category() {
        return "ATT_PERINFO";
    }
}

