/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamRequest;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailSingle;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;

public class TieInitializerAttRecordDetail
implements TieParamInitializer {
    private static final Log LOG = LogFactory.getLog(TieInitializerAttRecordDetail.class);
    private static final String[] INCR_SELECTS = new String[]{"attitemid.id", "owndate", "attitemvid.id", "value", "valuesecond", "valuelong", "attitemvid.unit", "attitemvid.datatype", "personid.id"};

    @Override
    public InitParamResult init(InitParam initRequest) {
        LOG.debug("TieInitializerAttRecordDetail initRequest,startDate{},endDate{}", (Object)initRequest.getStartDate(), (Object)initRequest.getEndDate());
        if (!(initRequest instanceof InitParamRequest)) {
            return InitParamResult.success(new AttRecordDetailTable(Collections.emptyMap()));
        }
        InitParamRequest initParamRequest = (InitParamRequest)initRequest;
        List<AttSubject> attSubjects = initParamRequest.getAttSubjects();
        Map<Date, Set<Long>> dateAttFileMap = this.getDateAttFileMap(attSubjects);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Date, Set<Long>> entry : dateAttFileMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtdtd_attincrdecr");
            QFilter[] qFilters = new QFilter[]{new QFilter("attfileid", "in", entry.getValue()).and(new QFilter("owndate", "=", (Object)entry.getKey()))};
            DynamicObject[] details = this.queryAttIncrDecr(baseHelper, qFilters);
            if (null == details || details.length <= 0) continue;
            resultList.addAll(Arrays.asList(details));
        }
        if (WTCCollections.isEmpty((Collection)resultList)) {
            return InitParamResult.success(new AttRecordDetailTable(Collections.emptyMap()));
        }
        Map<Long, Map<LocalDate, Map<Long, AttRecordDetailSingle>>> attRecordDetailTableMap = this.getAttIncrDecrDetail(resultList);
        return InitParamResult.success(new AttRecordDetailTable(attRecordDetailTableMap));
    }

    private Map<Date, Set<Long>> getDateAttFileMap(List<AttSubject> attSubjects) {
        HashMap<Date, Set<Long>> dateAttFileMap = new HashMap<Date, Set<Long>>(attSubjects.size());
        for (AttSubject attSubject : attSubjects) {
            Date preDate = Date.from(attSubject.getStartDate().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            HashSet<Long> set = (HashSet<Long>)dateAttFileMap.get(preDate);
            if (CollectionUtils.isEmpty((Collection)set)) {
                set = new HashSet<Long>(attSubjects.size());
            }
            List attFileBos = attSubject.getAttFileBos();
            for (AttSubject.AttFileBo attFileBo : attFileBos) {
                if (attFileBo.getStartDate().isEqual(attSubject.getStartDate())) {
                    set.add(attFileBo.getAttFileBoid());
                    continue;
                }
                Date otherPreDate = Date.from(attFileBo.getStartDate().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                HashSet otherSet = (HashSet)dateAttFileMap.get(otherPreDate);
                if (CollectionUtils.isEmpty((Collection)otherSet)) {
                    otherSet = new HashSet(attFileBos.size());
                }
                dateAttFileMap.put(otherPreDate, otherSet);
            }
            dateAttFileMap.put(preDate, set);
        }
        return dateAttFileMap;
    }

    private Map<Long, Map<LocalDate, Map<Long, AttRecordDetailSingle>>> getAttIncrDecrDetail(List<DynamicObject> attIncrDecrList) {
        HashMap attIncrDecrMap = Maps.newHashMapWithExpectedSize((int)attIncrDecrList.size());
        for (DynamicObject dyn : attIncrDecrList) {
            this.coverData(dyn, attIncrDecrMap);
        }
        return attIncrDecrMap;
    }

    private AttRecordDetailSingle coverData(DynamicObject row, Map<Long, Map<LocalDate, Map<Long, AttRecordDetailSingle>>> attIncrDecrMap) {
        Date ownDate;
        LocalDate ownDateLocal;
        Map itemDataMap;
        Long attPersonId = row.getLong("personid.id");
        HashMap personDataMap = attIncrDecrMap.get(attPersonId);
        if (WTCCollections.isEmpty(personDataMap)) {
            personDataMap = Maps.newHashMapWithExpectedSize((int)16);
            attIncrDecrMap.put(attPersonId, personDataMap);
        }
        if (WTCCollections.isEmpty((Map)(itemDataMap = (Map)personDataMap.get(ownDateLocal = WTCDateUtils.toLocalDate((Date)(ownDate = row.getDate("owndate"))))))) {
            itemDataMap = Maps.newHashMapWithExpectedSize((int)16);
            personDataMap.put(ownDateLocal, itemDataMap);
        }
        long attItemId = row.getLong("attitemid.id");
        AttRecordDetailSingle single = new AttRecordDetailSingle();
        single.setAttItemId(attItemId);
        single.setOwnDate(ownDate);
        single.setAttItemFid(row.getLong("attitemvid.id"));
        single.setValue(row.getBigDecimal("value"));
        single.setValueSecond(row.getBigDecimal("valuesecond"));
        single.setValueLong(row.getBigDecimal("valuelong"));
        single.setDateType(row.getString("attitemvid.datatype"));
        itemDataMap.put(attItemId, single);
        return single;
    }

    @Override
    public String category() {
        return "ATT_RECORD_DETAIL";
    }

    private DynamicObject[] queryAttIncrDecr(HRBaseServiceHelper baseHelper, QFilter ... qFilters) {
        return baseHelper.query(String.join((CharSequence)",", INCR_SELECTS), qFilters);
    }
}

