/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.init;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.core.init.InitParamResult;
import kd.wtc.wtes.business.core.init.TieParamInitException;
import kd.wtc.wtes.business.core.init.TieParamInitializer;
import kd.wtc.wtes.business.model.DasoConfData;
import kd.wtc.wtes.business.service.ConfigMixServiceImpl;
import kd.wtc.wtes.business.service.IConfigMixService;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitializerDasoConf
implements TieParamInitializer {
    @Override
    public InitParamResult init(InitParam initRequest) throws TieParamInitException {
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper("wtbd_dasoconf").loadDynamicObjectArray(TieInitializerDasoConf.getQueryCondition());
        IConfigMixService configMixService = (IConfigMixService)WTCAppContextHelper.getBean(ConfigMixServiceImpl.class);
        LinkedList<Long> warnInfoList = new LinkedList<Long>();
        DasoConfData dasoConfData = configMixService.dasoConfData(Arrays.asList(dynamicObjects), warnInfoList);
        if (CollectionUtils.isNotEmpty(warnInfoList)) {
            String warnInfo = this.getWarnInfo(warnInfoList);
            return InitParamResult.partial(dasoConfData, new TieMessageStd(TieMsgLevel.WARNING, warnInfo));
        }
        return InitParamResult.success(dasoConfData);
    }

    public static QFilter[] getQueryCondition() {
        List<String> usableDataStatusList = Collections.unmodifiableList(Arrays.asList(HisDataStatus.EXPIRATION.code, HisDataStatus.EFFECTIVE.code, HisDataStatus.SCHEDULE_EFFECTIVE.code));
        QFilter currentVersion = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", usableDataStatusList);
        return new QFilter[]{statusFilter, dataStatusFilter, currentVersion};
    }

    @Override
    public String category() {
        return "DASO_CONF";
    }

    private String getWarnInfo(List<Long> warnInfoList) {
        return "DasoConf happen exception, key:[" + StringUtils.join(warnInfoList, (String)",") + "]";
    }
}

