/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStageType;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AccountPlanData {
    private List<TimeSeqBo<TieScheme>> btbId2List;
    private List<TimeSeqBo<TieScheme>> detail2List;
    private List<TimeSeqBo<TieScheme>> total2List;

    private AccountPlanData() {
    }

    public static AccountPlanData of(List<TieScheme> tieSchemeList) {
        AccountPlanData btbData = new AccountPlanData();
        if (CollectionUtils.isEmpty(tieSchemeList)) {
            return btbData;
        }
        Map<Long, List<TieScheme>> bo2His = tieSchemeList.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
        ArrayList<TimeSeqBo<TieScheme>> tieSchemeBoList = new ArrayList<TimeSeqBo<TieScheme>>(bo2His.size());
        ArrayList<TimeSeqBo<TieScheme>> tieSchemeDetialBoList = new ArrayList<TimeSeqBo<TieScheme>>(bo2His.size());
        ArrayList<TimeSeqBo<TieScheme>> tieSchemeTatolBoList = new ArrayList<TimeSeqBo<TieScheme>>(bo2His.size());
        AccountPlanData.listTimeSeqBo(bo2His, tieSchemeBoList, tieSchemeDetialBoList, tieSchemeTatolBoList);
        btbData.btbId2List = tieSchemeBoList;
        btbData.total2List = tieSchemeTatolBoList;
        btbData.detail2List = tieSchemeDetialBoList;
        return btbData;
    }

    private static void listTimeSeqBo(Map<Long, List<TieScheme>> bo2His, List<TimeSeqBo<TieScheme>> tieSchemeBoList, List<TimeSeqBo<TieScheme>> tieSchemeDetialBoList, List<TimeSeqBo<TieScheme>> tieSchemeTatolBoList) {
        bo2His.forEach((bid, tieSchemes) -> {
            TimeSeqBo timeSeqBo = TimeSeqBo.ofMultiTimeSeq((Collection)tieSchemes);
            tieSchemeBoList.add(timeSeqBo);
            ArrayList<TieScheme> tieSchemeTotalBoList = new ArrayList<TieScheme>(16);
            ArrayList<TieScheme> tieSchemeDetailBoList = new ArrayList<TieScheme>(16);
            AccountPlanData.builtTieScheme(tieSchemes, tieSchemeTotalBoList, tieSchemeDetailBoList);
            if (!CollectionUtils.isEmpty(tieSchemeTotalBoList)) {
                tieSchemeTatolBoList.add(TimeSeqBo.ofMultiTimeSeq(tieSchemeTotalBoList));
            }
            if (!CollectionUtils.isEmpty(tieSchemeDetailBoList)) {
                tieSchemeDetialBoList.add(TimeSeqBo.ofMultiTimeSeq(tieSchemeDetailBoList));
            }
        });
    }

    private static void builtTieScheme(List<TieScheme> tieSchemeList, List<TieScheme> tieSchemeTotalBoList, List<TieScheme> tieSchemeDetailBoList) {
        for (TieScheme tieScheme : tieSchemeList) {
            ArrayList<TiePhaseConfig> tieTiePhaseConfigTotalBoList = new ArrayList<TiePhaseConfig>(16);
            ArrayList<TiePhaseConfig> tieTiePhaseConfigDetailBoList = new ArrayList<TiePhaseConfig>(16);
            ArrayList<DecisionConfig> decisionTotalConfig = new ArrayList<DecisionConfig>(16);
            ArrayList<DecisionConfig> decisionDetailConfig = new ArrayList<DecisionConfig>(16);
            List<TiePhaseConfig> tiePhaseConfigList = tieScheme.getPhaseProperties();
            List<DecisionConfig> phaseDecisions = tieScheme.getPhaseDecisions();
            if (CollectionUtils.isEmpty(tiePhaseConfigList)) continue;
            if ("C".equals(tieScheme.getAccountType())) {
                for (TiePhaseConfig tiePhaseConfig : tiePhaseConfigList) {
                    int phaseIndex = tiePhaseConfig.getIndex();
                    tieTiePhaseConfigDetailBoList.add(tiePhaseConfig);
                    decisionDetailConfig.add(phaseDecisions.get(phaseIndex));
                }
                if (CollectionUtils.isEmpty(tieTiePhaseConfigDetailBoList)) continue;
                tieSchemeDetailBoList.add(AccountPlanData.getTieScheme(tieScheme, tieTiePhaseConfigDetailBoList, decisionDetailConfig));
                continue;
            }
            Integer Index = tiePhaseConfigList.stream().filter(ob -> ob.getPhaseTypeId() == PreDataAccountStageType.PD_1100_S.longValue() && !ob.getDelete()).map(TiePhaseConfig::getIndex).findFirst().orElse(null);
            if (Index == null) continue;
            for (TiePhaseConfig tiePhaseConfig : tiePhaseConfigList) {
                int phaseIndex = tiePhaseConfig.getIndex();
                if (null != Index && phaseIndex >= Index) {
                    tieTiePhaseConfigTotalBoList.add(tiePhaseConfig);
                    decisionTotalConfig.add(phaseDecisions.get(phaseIndex));
                    continue;
                }
                tieTiePhaseConfigDetailBoList.add(tiePhaseConfig);
                decisionDetailConfig.add(phaseDecisions.get(phaseIndex));
            }
            if (!CollectionUtils.isEmpty(tieTiePhaseConfigTotalBoList)) {
                tieSchemeTotalBoList.add(AccountPlanData.getTieScheme(tieScheme, tieTiePhaseConfigTotalBoList, decisionTotalConfig));
            }
            if (CollectionUtils.isEmpty(tieTiePhaseConfigDetailBoList)) continue;
            tieSchemeDetailBoList.add(AccountPlanData.getTieScheme(tieScheme, tieTiePhaseConfigDetailBoList, decisionDetailConfig));
        }
    }

    private static TieScheme getTieScheme(TieScheme tieScheme, List<TiePhaseConfig> tiePhaseConfigList, List<DecisionConfig> phaseDecisions) {
        return (TieScheme)((TieScheme.Builder)((Object)TieScheme.withTimeSeq(tieScheme.getTimeSeqInfo()).phaseDecisions(phaseDecisions))).phaseProperties(tiePhaseConfigList).build();
    }

    private TimeSeqBo<TieScheme> getTimeSeqBoByinDate(LocalDate inDate, List<TimeSeqBo<TieScheme>> spliteTimeSeqBo) {
        if (spliteTimeSeqBo == null) {
            return TimeSeqBo.empty();
        }
        for (TimeSeqBo<TieScheme> timeSeqBo : spliteTimeSeqBo) {
            TieScheme tieScheme = (TieScheme)timeSeqBo.getVersionByDate(inDate);
            if (tieScheme == null) continue;
            return timeSeqBo;
        }
        return TimeSeqBo.empty();
    }

    @Deprecated
    @NotNull
    public TieScheme getTieSchemeByPersonAndDate(LocalDate inDate) {
        TimeSeqBo<TieScheme> timeSeqBo = this.getTimeSeqBoByinDate(inDate, this.btbId2List);
        return (TieScheme)timeSeqBo.getVersionByDate(inDate);
    }

    @NotNull
    public TieScheme getTieSchemeByTotalAndDate(LocalDate inDate) {
        TimeSeqBo<TieScheme> timeSeqBo = this.getTimeSeqBoByinDate(inDate, this.total2List);
        return (TieScheme)timeSeqBo.getVersionByDate(inDate);
    }

    @NotNull
    public TieScheme getTieSchemeByDetailAndDate(LocalDate inDate) {
        TimeSeqBo<TieScheme> timeSeqBo = this.getTimeSeqBoByinDate(inDate, this.detail2List);
        return (TieScheme)timeSeqBo.getVersionByDate(inDate);
    }

    @Deprecated
    @NotNull
    public TieScheme getTieSchemeByPersonAndDate(Long personId, LocalDate inDate) {
        if (personId == null) {
            return null;
        }
        return this.getTieSchemeByPersonAndDate(inDate);
    }

    public List<TimeSeqBo<TieScheme>> getBtbId2List() {
        return this.btbId2List;
    }
}

