/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.common.lang.NotNull;

public class AttBillTimeBucketData {
    private Map<Long, AttBillTimeBucket> btbId2Btb;
    private Map<Long, Map<LocalDate, List<AttBillTimeBucket>>> attPersonId2DailyBtb;

    private AttBillTimeBucketData() {
    }

    public static AttBillTimeBucketData of(List<AttBillTimeBucket> btbs) {
        AttBillTimeBucketData btbData = new AttBillTimeBucketData();
        HashMap<Long, AttBillTimeBucket> btbId2Btb = new HashMap<Long, AttBillTimeBucket>(btbs.size());
        HashMap<Long, Map<LocalDate, List<AttBillTimeBucket>>> attPersonId2DailyBtb = new HashMap<Long, Map<LocalDate, List<AttBillTimeBucket>>>(16);
        for (AttBillTimeBucket btb : btbs) {
            btbId2Btb.put(btb.getId(), btb);
            Map date2Btbs = attPersonId2DailyBtb.computeIfAbsent(btb.getAttPersonId(), key -> new HashMap(16));
            List btbList = date2Btbs.computeIfAbsent(btb.getRosterDate(), key -> new LinkedList());
            btbList.add(btb);
        }
        btbData.btbId2Btb = btbId2Btb;
        btbData.attPersonId2DailyBtb = attPersonId2DailyBtb;
        return btbData;
    }

    @NotNull
    public List<AttBillTimeBucket> getBillTimeBuckets(long attPersonId, LocalDate inDate) {
        Map<LocalDate, List<AttBillTimeBucket>> date2Btbs = this.attPersonId2DailyBtb.get(attPersonId);
        if (date2Btbs == null) {
            return Collections.emptyList();
        }
        return date2Btbs.getOrDefault(inDate, Collections.emptyList());
    }

    @NotNull
    public List<AttBillTimeBucket> getBillTimeBuckets(long attPersonId) {
        Map<LocalDate, List<AttBillTimeBucket>> date2Btbs = this.attPersonId2DailyBtb.get(attPersonId);
        if (date2Btbs == null) {
            return Collections.emptyList();
        }
        LinkedList<AttBillTimeBucket> btbs = new LinkedList<AttBillTimeBucket>();
        for (List<AttBillTimeBucket> btbList : date2Btbs.values()) {
            btbs.addAll(btbList);
        }
        return btbs;
    }

    public AttBillTimeBucket getBillTimeBucketById(long id) {
        return this.btbId2Btb.get(id);
    }

    public long getBillTypeById(long id) {
        AttBillTimeBucket btb = this.getBillTimeBucketById(id);
        if (btb == null) {
            return 0L;
        }
        return btb.getBillType();
    }

    public Map<Long, AttBillTimeBucket> getBtbId2Btb() {
        return this.btbId2Btb;
    }

    public Map<Long, Map<LocalDate, List<AttBillTimeBucket>>> getAttPersonId2DailyBtb() {
        return this.attPersonId2DailyBtb;
    }
}

