/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.KDDateUtils;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.ExAttPackage;
import kd.wtc.wtes.business.model.OtAttPackage;
import kd.wtc.wtes.business.model.TbAttPackage;
import kd.wtc.wtes.business.model.TimeZone;
import kd.wtc.wtes.business.model.VaAttPackage;
import kd.wtc.wtes.business.model.attconfig.AttPlan;
import kd.wtc.wtes.business.model.rlad.AdPlanPackage;
import kd.wtc.wtes.business.model.rlfm.FormulaPlanPackage;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.common.enums.AttFileEpRelStatusEnum;
import kd.wtc.wtes.common.lang.WtesBizException;

public class AttFileModel
extends AbstractTimeSeqVersion {
    private long attPersonId;
    private LocalDate startDate;
    private LocalDate endDate;
    private String dependency;
    private boolean isManaged;
    private Long attTagId;
    private Long dependencyId;
    private Long orgId;
    private Long adminOrgId;
    private Long companyId;
    private Long cmpempId;
    private Long empposorgrelId;
    private AttFileEpRelStatusEnum epRelStatusEnum;
    private Long jobId;
    private Long positionId;
    private Long affiliateAdminOrgBid;
    private List<Map<String, Object>> affiliateAdminOrgVid;
    private Long empGroup;
    private Long dependencyType;
    private Long workplace;
    private Long timeResolveId;
    private String orgNumber;
    private String dependencyNumber;
    private String affiliateAdminOrgNumber;
    private String dependencyTypeNumber;
    private String workplaceNumber;
    private String attTagNumber;
    private String empGroupNumber;
    private Long employeeId;
    private Long depempBoid;
    private Long personBoid;
    private List<AttFileScheduleEntity<AttModeEnum>> attModesList;
    private List<AttFileScheduleEntity<String>> attCardList;
    private List<AttFileScheduleEntity<TimeZone>> timeZoneList;
    private List<AttFileScheduleEntity<TimeSeqBo<VaAttPackage>>> attVaPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<TbAttPackage>>> attTbPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<OtAttPackage>>> attOtPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<ExAttPackage>>> attExPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<IncrDecrPlan>>> attIdPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<AttPlan>>> attAttPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<QTScheme>>> attQtPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<AdPlanPackage>>> attAdPackageList;
    private List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFormulaPlanPackageList;
    private Map<String, Object> extAttribute;

    public Long getEmployeeId() {
        return this.employeeId;
    }

    public Long getDepempBoid() {
        return this.depempBoid;
    }

    public Long getPersonBoid() {
        return this.personBoid;
    }

    public long getAttPersonId() {
        return this.attPersonId;
    }

    public String getDependency() {
        return this.dependency;
    }

    public List<AttFileScheduleEntity<AttModeEnum>> getAttModesList() {
        return this.attModesList;
    }

    public List<AttFileScheduleEntity<String>> getAttCardList() {
        return this.attCardList;
    }

    public List<AttFileScheduleEntity<TimeZone>> getTimeZoneList() {
        return this.timeZoneList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<VaAttPackage>>> getAttVaPackageList() {
        return this.attVaPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<TbAttPackage>>> getAttTbPackageList() {
        return this.attTbPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<OtAttPackage>>> getAttOtPackageList() {
        return this.attOtPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<ExAttPackage>>> getAttExPackageList() {
        return this.attExPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<IncrDecrPlan>>> getAttIdPackageList() {
        return this.attIdPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<AttPlan>>> getAttAttPackageList() {
        return this.attAttPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<QTScheme>>> getAttQtPackageList() {
        return this.attQtPackageList;
    }

    public List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> getAttFormulaPlanPackageList() {
        return this.attFormulaPlanPackageList;
    }

    public boolean epRelStatusDiscard() {
        return this.epRelStatusEnum != null && AttFileEpRelStatusEnum.DISCARD == this.epRelStatusEnum;
    }

    protected AttFileModel() {
    }

    protected AttFileModel(TimeSeqInfo timeSeqEntity) {
        super(timeSeqEntity);
    }

    public static Builder withTimeSeq(TimeSeqInfoImpl timeSeqEntity) {
        return new Builder(new AttFileModel((TimeSeqInfo)timeSeqEntity));
    }

    public Long getAffiliateAdminOrgBid() {
        return this.affiliateAdminOrgBid;
    }

    public Long getEmpGroup() {
        return this.empGroup;
    }

    public Long getDependencyType() {
        return this.dependencyType;
    }

    public List<Map<String, Object>> getAffiliateAdminOrgVid() {
        return this.affiliateAdminOrgVid;
    }

    public Long getDependencyId() {
        return this.dependencyId;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Date getEndDateTime() {
        return Date.from(this.endDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public Long getAttTagId() {
        return this.attTagId;
    }

    public AttModeEnum getAttMode(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attModesList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(AttFileScheduleEntity::getEntity).orElse(null);
    }

    public AttModeEnum getAttModeMust(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attModesList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(AttFileScheduleEntity::getEntity).orElseThrow(() -> new WtesBizException("Could not get att mode in " + inDate));
    }

    public String getAttCard(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attCardList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(AttFileScheduleEntity::getEntity).orElse(null);
    }

    public TimeZone getTimeZone(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.timeZoneList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(AttFileScheduleEntity::getEntity).orElse(null);
    }

    public VaAttPackage getAttVaPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attVaPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (VaAttPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public TbAttPackage getAttTbPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attTbPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (TbAttPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public OtAttPackage getAttOtPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attOtPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (OtAttPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public QTScheme getAttQtPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attQtPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (QTScheme)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public ExAttPackage getAttExPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attExPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (ExAttPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public IncrDecrPlan getIncrDecrPlan(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attIdPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (IncrDecrPlan)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public AttPlan getAttPlan(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        if (this.attAttPackageList == null) {
            return null;
        }
        Optional<AttFileScheduleEntity> any = this.attAttPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (AttPlan)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public Long getAffiliateAdminOrgVid(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Date date = WTCDateUtils.toDate((LocalDate)inDate);
        if (this.affiliateAdminOrgVid == null || this.affiliateAdminOrgVid.size() == 0) {
            return 0L;
        }
        Map dy = this.affiliateAdminOrgVid.stream().filter(affiliateAdminOrg -> date.compareTo((Date)affiliateAdminOrg.get("bsed")) >= 0 && date.compareTo((Date)affiliateAdminOrg.get("bsled")) <= 0).findAny().orElse(null);
        return dy == null ? 0L : Long.parseLong(dy.get("id").toString());
    }

    public List<AttFileScheduleEntity<TimeSeqBo<AdPlanPackage>>> getAttAdPackageList() {
        return this.attAdPackageList;
    }

    public AdPlanPackage getAdPlanPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attAdPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (AdPlanPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public FormulaPlanPackage getAttFormulaPlanPackage(LocalDate inDate) {
        Objects.requireNonNull(inDate);
        Optional<AttFileScheduleEntity> any = this.attFormulaPlanPackageList.stream().filter(data -> data.getStartDate().compareTo(inDate) <= 0 && data.getEndDate().compareTo(inDate) >= 0).findAny();
        return any.map(timeSeqBoAttFileScheduleEntity -> timeSeqBoAttFileScheduleEntity.getEntity() != null ? (FormulaPlanPackage)((TimeSeqBo)timeSeqBoAttFileScheduleEntity.getEntity()).getVersionByDate(inDate) : null).orElse(null);
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getAdminOrgId() {
        return this.adminOrgId;
    }

    public Long getCompanyId() {
        return this.companyId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getPositionId() {
        return this.positionId;
    }

    public Long getTimeResolveId() {
        return this.timeResolveId;
    }

    public Long getCmpempId() {
        return this.cmpempId;
    }

    public Long getEmpposorgrelId() {
        return this.empposorgrelId;
    }

    public Long getWorkplace() {
        return this.workplace;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public Date getStartDateTime() {
        return Date.from(this.startDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public String getDependencyNumber() {
        return this.dependencyNumber;
    }

    public String getAffiliateAdminOrgNumber() {
        return this.affiliateAdminOrgNumber;
    }

    public String getDependencyTypeNumber() {
        return this.dependencyTypeNumber;
    }

    public String getWorkplaceNumber() {
        return this.workplaceNumber;
    }

    public String getAttTagNumber() {
        return this.attTagNumber;
    }

    public String getEmpGroupNumber() {
        return this.empGroupNumber;
    }

    public Map<String, Object> getExtAttribute() {
        return this.extAttribute;
    }

    public static class Builder {
        private AttFileModel attFileModel;

        public static Builder withNonTimeSeq() {
            return new Builder(new AttFileModel());
        }

        protected Builder(AttFileModel attFileModel) {
            this.attFileModel = attFileModel;
        }

        public Builder orgId(Long orgId) {
            this.attFileModel.orgId = orgId;
            return this;
        }

        public Builder adminOrgId(Long adminOrgId) {
            this.attFileModel.adminOrgId = adminOrgId;
            return this;
        }

        public Builder id(long id) {
            this.attFileModel.id = id;
            return this;
        }

        public Builder number(String number) {
            this.attFileModel.number = number;
            return this;
        }

        public Builder companyId(Long companyId) {
            this.attFileModel.companyId = companyId;
            return this;
        }

        public Builder cmpempId(Long cmpempId) {
            this.attFileModel.cmpempId = cmpempId;
            return this;
        }

        public Builder attTagId(Long attTagId) {
            this.attFileModel.attTagId = attTagId;
            return this;
        }

        public Builder empposorgrelId(Long empposorgrelId) {
            this.attFileModel.empposorgrelId = empposorgrelId;
            return this;
        }

        public Builder jobId(Long jobId) {
            this.attFileModel.jobId = jobId;
            return this;
        }

        public Builder positionId(Long positionId) {
            this.attFileModel.positionId = positionId;
            return this;
        }

        public Builder dependency(String dependency) {
            this.attFileModel.dependency = dependency;
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.attFileModel.isManaged = isManaged;
            return this;
        }

        public Builder workplace(Long workplace) {
            this.attFileModel.workplace = workplace;
            return this;
        }

        public Builder attPersonId(Long attPersonId) {
            this.attFileModel.attPersonId = attPersonId;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.attFileModel.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.attFileModel.endDate = endDate;
            return this;
        }

        public Builder affiliateAdminOrgBid(Long affiliateAdminOrgBid) {
            this.attFileModel.affiliateAdminOrgBid = affiliateAdminOrgBid;
            return this;
        }

        public Builder epRelStatusEnum(String empPosOrgRelDataStatus) {
            this.attFileModel.epRelStatusEnum = AttFileEpRelStatusEnum.from((String)empPosOrgRelDataStatus);
            return this;
        }

        public Builder affiliateAdminOrgVid(List<DynamicObject> affiliateAdminOrgVidList) {
            if (null != affiliateAdminOrgVidList) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)affiliateAdminOrgVidList.size());
                for (DynamicObject affiliateAdminOrgVid : affiliateAdminOrgVidList) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)3);
                    map.put("id", affiliateAdminOrgVid.getLong("id"));
                    map.put("bsed", affiliateAdminOrgVid.getDate("bsed"));
                    map.put("bsled", affiliateAdminOrgVid.getDate("bsled"));
                    list.add(map);
                }
                this.attFileModel.affiliateAdminOrgVid = list;
            }
            return this;
        }

        public Builder empGroup(Long empGroup) {
            this.attFileModel.empGroup = empGroup;
            return this;
        }

        public Builder dependencyType(Long dependencyType) {
            this.attFileModel.dependencyType = dependencyType;
            return this;
        }

        public Builder dependencyId(Long dependencyId) {
            this.attFileModel.dependencyId = dependencyId;
            return this;
        }

        public Builder timeResolveId(Long timeResolveId) {
            this.attFileModel.timeResolveId = timeResolveId;
            return this;
        }

        public Builder attModesList(List<AttFileScheduleEntity<AttModeEnum>> attModesList) {
            this.attFileModel.attModesList = attModesList;
            return this;
        }

        public Builder timeZoneList(List<AttFileScheduleEntity<TimeZone>> timeZoneList) {
            this.attFileModel.timeZoneList = timeZoneList;
            return this;
        }

        public Builder attCardList(List<AttFileScheduleEntity<String>> attCardList) {
            this.attFileModel.attCardList = attCardList;
            return this;
        }

        public Builder attVaPackageList(List<AttFileScheduleEntity<TimeSeqBo<VaAttPackage>>> attVaPackageList) {
            this.attFileModel.attVaPackageList = attVaPackageList;
            return this;
        }

        public Builder attTbPackageList(List<AttFileScheduleEntity<TimeSeqBo<TbAttPackage>>> attTbPackageList) {
            this.attFileModel.attTbPackageList = attTbPackageList;
            return this;
        }

        public Builder attOtPackageList(List<AttFileScheduleEntity<TimeSeqBo<OtAttPackage>>> attOtPackageList) {
            this.attFileModel.attOtPackageList = attOtPackageList;
            return this;
        }

        public Builder attExPackageList(List<AttFileScheduleEntity<TimeSeqBo<ExAttPackage>>> attExPackageList) {
            this.attFileModel.attExPackageList = attExPackageList;
            return this;
        }

        public Builder attIdPackageList(List<AttFileScheduleEntity<TimeSeqBo<IncrDecrPlan>>> attIdPackageList) {
            this.attFileModel.attIdPackageList = attIdPackageList;
            return this;
        }

        public Builder attAttPackageList(List<AttFileScheduleEntity<TimeSeqBo<AttPlan>>> attIdPackageList) {
            this.attFileModel.attAttPackageList = attIdPackageList;
            return this;
        }

        public Builder attAdPackageList(List<AttFileScheduleEntity<TimeSeqBo<AdPlanPackage>>> attAdPackageList) {
            this.attFileModel.attAdPackageList = attAdPackageList;
            return this;
        }

        public Builder attQtPackageList(List<AttFileScheduleEntity<TimeSeqBo<QTScheme>>> attQtPackageList) {
            this.attFileModel.attQtPackageList = attQtPackageList;
            return this;
        }

        public Builder attFormulaPlanPackageList(List<AttFileScheduleEntity<TimeSeqBo<FormulaPlanPackage>>> attFormulaPlanPackageList) {
            this.attFileModel.attFormulaPlanPackageList = attFormulaPlanPackageList;
            return this;
        }

        public Builder extAttribute(Map<String, Object> extAttribute) {
            this.attFileModel.extAttribute = extAttribute;
            return this;
        }

        public AttFileModel build() {
            AttFileModel tmp = this.attFileModel;
            this.attFileModel = null;
            return tmp;
        }

        public Builder orgNumber(String orgNumber) {
            this.attFileModel.orgNumber = orgNumber;
            return this;
        }

        public Builder dependencyNumber(String dependencyNumber) {
            this.attFileModel.dependencyNumber = dependencyNumber;
            return this;
        }

        public Builder affiliateAdminOrgNumber(String affiliateAdminOrgNumber) {
            this.attFileModel.affiliateAdminOrgNumber = affiliateAdminOrgNumber;
            return this;
        }

        public Builder dependencyTypeNumber(String dependencyTypeNumber) {
            this.attFileModel.dependencyTypeNumber = dependencyTypeNumber;
            return this;
        }

        public Builder workplaceNumber(String workplaceNumber) {
            this.attFileModel.workplaceNumber = workplaceNumber;
            return this;
        }

        public Builder attTagNumber(String attTagNumber) {
            this.attFileModel.attTagNumber = attTagNumber;
            return this;
        }

        public Builder empGroupNumber(String empGroupNumber) {
            this.attFileModel.empGroupNumber = empGroupNumber;
            return this;
        }

        public Builder employeeId(Long employeeId) {
            this.attFileModel.employeeId = employeeId;
            return this;
        }

        public Builder depempBoid(Long depempBoid) {
            this.attFileModel.depempBoid = depempBoid;
            return this;
        }

        public Builder personBoid(Long personBoid) {
            this.attFileModel.personBoid = personBoid;
            return this;
        }
    }
}

