/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtes.business.builder.DetectableAndCleanableBuilder;
import kd.wtc.wtes.business.model.ShiftSession;
import kd.wtc.wtes.business.model.shift.OutWorkType;
import kd.wtc.wtes.common.enums.RefDateType;
import kd.wtc.wtes.common.enums.ShiftType;
import kd.wtc.wtes.common.lang.TypeCloneable;
import kd.wtc.wtes.common.lang.WtesException;

public class ShiftSpec
extends AbstractTimeSeqVersion
implements TypeCloneable<ShiftSpec> {
    private ShiftType shiftType;
    private List<ShiftSession> shiftSessions;
    private List<ShiftSession> breakSessions;
    private String name;
    private OrmLocaleValue ormLocaleName;
    private String chineseName;
    private boolean off;
    private long clockruleId;
    private boolean offNonPlan;
    private RefDateType firstRefDateType;
    private RefDateType lastRefDateType;
    private LocalTime earliestShiftTime;
    private LocalTime lastShiftTime;
    private List<ShiftSession> workSession;
    private int workTime;
    private int breakTime;
    private int otTime;
    private RefDateType inOtStartRefDateType;
    private LocalTime inOtStartTime;
    private RefDateType inOtEndRefDateType;
    private LocalTime inOtEndTime;
    private int shiftTime;
    private int effectTimeOfAllDayFlex;
    private BigDecimal alldayhour;
    private Integer standardTime;
    private ShiftMiddleRule shiftMiddleRule;

    public OrmLocaleValue getOrmLocaleName() {
        return this.ormLocaleName;
    }

    protected ShiftSpec(TimeSeqInfo timeSeqInfo) {
        super(timeSeqInfo);
    }

    protected ShiftSpec(long id, String number) {
        super(id, number);
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(new ShiftSpec(timeSeqInfo));
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(new ShiftSpec(id, number));
    }

    public Builder<?, ?> withCopy() {
        return new BuilderImpl(this.clone());
    }

    public BigDecimal secondsToDays(int seconds) {
        if (this.alldayhour == null || this.alldayhour.compareTo(BigDecimal.ZERO) == 0 || seconds == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal second = BigDecimal.valueOf(seconds);
        BigDecimal allDaySecond = this.alldayhour.multiply(BigDecimal.valueOf(3600L));
        return second.divide(allDaySecond, 10, 4);
    }

    public BigDecimal secondsToDays(BigDecimal seconds) {
        if (this.alldayhour == null || this.alldayhour.compareTo(BigDecimal.ZERO) == 0 || seconds.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal second = seconds;
        BigDecimal allDaySecond = this.alldayhour.multiply(BigDecimal.valueOf(3600L));
        return second.divide(allDaySecond, 10, 4);
    }

    public int daysToSeconds(BigDecimal days) {
        return this.daysToSecondDecimal(days).intValue();
    }

    public BigDecimal daysToSecondDecimal(BigDecimal days) {
        if (days == null || this.alldayhour.compareTo(BigDecimal.ZERO) == 0 || days.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal allDaySecond = this.alldayhour.multiply(BigDecimal.valueOf(3600L));
        if (days.compareTo(BigDecimal.ONE) == 0) {
            return allDaySecond;
        }
        return days.multiply(allDaySecond);
    }

    public int getStandardTimeSeconds() {
        if (this.isOff()) {
            return 0;
        }
        return this.shiftSessions.stream().filter(duration -> OutWorkType.BREAK != duration.getOutWorkType()).map(ShiftSpec::durationBetweenRefTimePoints).reduce(Integer::sum).orElse(0);
    }

    private static int durationBetweenRefTimePoints(ShiftSession shiftSession) {
        LocalTime startTime = shiftSession.getStartTime();
        LocalTime endTime = shiftSession.getEndTime();
        int gap = (endTime.getHour() - startTime.getHour()) * 3600 + (endTime.getMinute() - startTime.getMinute()) * 60;
        if (shiftSession.getStartRefDateType() == shiftSession.getEndRefDateType()) {
            return gap;
        }
        return gap + 86400 * (shiftSession.getEndRefDateType().refIndex - shiftSession.getStartRefDateType().refIndex);
    }

    public LocalDateTime generateShiftStartTime(LocalDate shiftDate) {
        if (this.getOffNonPlan()) {
            return null;
        }
        return this.shiftSessions.get(0).getAbsoluteShiftStartDate(shiftDate);
    }

    public LocalDateTime generateShiftEndTime(LocalDate shiftDate) {
        if (this.getOffNonPlan()) {
            return null;
        }
        return this.shiftSessions.get(this.shiftSessions.size() - 1).getAbsoluteShiftEndDate(shiftDate);
    }

    public String getName() {
        return this.name;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public boolean isOff() {
        return this.off;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public List<ShiftSession> getShiftSessions() {
        return this.shiftSessions;
    }

    public LocalDateTime getRealEarliestShiftTime(LocalDate localDate) {
        assert (this.firstRefDateType != null);
        return this.getLocalDateTime(localDate, this.firstRefDateType, this.earliestShiftTime);
    }

    public LocalDateTime getRealLastShiftTime(LocalDate localDate) {
        assert (this.lastRefDateType != null);
        return this.getLocalDateTime(localDate, this.lastRefDateType, this.lastShiftTime);
    }

    private LocalDateTime getLocalDateTime(LocalDate localDate, RefDateType lastRefDateType, LocalTime shiftTime) {
        switch (lastRefDateType) {
            case LASTDAY: {
                return LocalDateTime.of(localDate.plusDays(-1L), shiftTime);
            }
            case NEXTDAY: {
                return LocalDateTime.of(localDate.plusDays(1L), shiftTime);
            }
        }
        return LocalDateTime.of(localDate, shiftTime);
    }

    public RefDateType getFlexTimeRefDateTypeBegin() {
        return Objects.isNull(this.workSession) || this.workSession.isEmpty() ? null : this.workSession.get(0).getStartRefDateType();
    }

    public RefDateType getFlexTimeRefDateTypeEnd() {
        return Objects.isNull(this.workSession) || this.workSession.isEmpty() ? null : this.workSession.get(0).getEndRefDateType();
    }

    public LocalTime getFlexTimeBegin() {
        return Objects.isNull(this.workSession) || this.workSession.isEmpty() ? null : this.workSession.get(0).getStartTime();
    }

    public LocalTime getFlexTimeEnd() {
        return Objects.isNull(this.workSession) || this.workSession.isEmpty() ? null : this.workSession.get(0).getEndTime();
    }

    public ShiftMiddleRule getShiftMiddleRule() {
        return this.shiftMiddleRule;
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public int getBreakTime() {
        return this.breakTime;
    }

    public int getOtTime() {
        return this.otTime;
    }

    public int getShiftTime() {
        return this.shiftTime;
    }

    public int getEffectTimeOfAllDayFlex() {
        return this.effectTimeOfAllDayFlex;
    }

    public BigDecimal getAlldayhour() {
        return this.alldayhour;
    }

    public Integer getStandardTime() {
        return this.standardTime;
    }

    public List<ShiftSession> getWorkSession() {
        return this.workSession;
    }

    public List<ShiftSession> getBreakSessions() {
        return this.breakSessions;
    }

    public RefDateType getInOtStartRefDateType() {
        return this.inOtStartRefDateType;
    }

    public LocalTime getInOtStartTime() {
        return this.inOtStartTime;
    }

    public RefDateType getInOtEndRefDateType() {
        return this.inOtEndRefDateType;
    }

    public LocalTime getInOtEndTime() {
        return this.inOtEndTime;
    }

    public boolean getOffNonPlan() {
        return this.offNonPlan;
    }

    public long getClockruleId() {
        return this.clockruleId;
    }

    public boolean isOffNonPlan() {
        return this.offNonPlan;
    }

    public RefDateType getFirstRefDateType() {
        return this.firstRefDateType;
    }

    public RefDateType getLastRefDateType() {
        return this.lastRefDateType;
    }

    public LocalTime getEarliestShiftTime() {
        return this.earliestShiftTime;
    }

    public LocalTime getLastShiftTime() {
        return this.lastShiftTime;
    }

    public ShiftSpec clone() {
        try {
            return (ShiftSpec)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new WtesException((Throwable)e);
        }
    }

    public String toString() {
        return "ShiftSpec{shiftType=" + this.shiftType + ", shiftSessions=" + this.shiftSessions + ", off=" + this.off + ", firstRefDateType=" + this.firstRefDateType + ", lastRefDateType=" + this.lastRefDateType + ", earliestShiftTime=" + this.earliestShiftTime + ", lastShiftTime=" + this.lastShiftTime + ", workSession=" + this.workSession + ", workTime=" + this.workTime + ", breakTime=" + this.breakTime + ", otTime=" + this.otTime + ", shiftTime=" + this.shiftTime + ", effectTimeOfAllDayFlex=" + this.effectTimeOfAllDayFlex + ", alldayhour=" + this.alldayhour + ", timeSeqInfo=" + this.getTimeSeqInfo() + '}';
    }

    private static class BuilderImpl
    extends Builder<ShiftSpec, BuilderImpl> {
        private BuilderImpl(ShiftSpec shiftSpec) {
            super(shiftSpec);
        }

        @Override
        protected void clear() {
            this.shiftSpec = null;
        }

        @Override
        protected ShiftSpec building() {
            return this.shiftSpec;
        }

        @Override
        protected BuilderImpl self() {
            return this;
        }
    }

    public static abstract class Builder<E extends ShiftSpec, B extends Builder<E, B>>
    extends DetectableAndCleanableBuilder<E, B> {
        protected ShiftSpec shiftSpec;

        protected Builder(ShiftSpec shiftSpec) {
            this.shiftSpec = shiftSpec;
        }

        public B shiftType(ShiftType shiftType) {
            this.shiftSpec.shiftType = shiftType;
            return (B)((Builder)this.self());
        }

        public B ormLocaleName(OrmLocaleValue ormLocaleName) {
            this.shiftSpec.ormLocaleName = ormLocaleName;
            return (B)((Builder)this.self());
        }

        public B shiftSessions(List<ShiftSession> shiftSessions) {
            this.shiftSpec.shiftSessions = shiftSessions;
            return (B)((Builder)this.self());
        }

        public B breakSessions(List<ShiftSession> breakSessions) {
            this.shiftSpec.breakSessions = breakSessions;
            return (B)((Builder)this.self());
        }

        public B inOtStartRefDateType(RefDateType inOtStartRefDateType) {
            this.shiftSpec.inOtStartRefDateType = inOtStartRefDateType;
            return (B)((Builder)this.self());
        }

        public B inOtEndRefDateType(RefDateType inOtEndRefDateType) {
            this.shiftSpec.inOtEndRefDateType = inOtEndRefDateType;
            return (B)((Builder)this.self());
        }

        public B inOtStartTime(LocalTime inOtStartTime) {
            this.shiftSpec.inOtStartTime = inOtStartTime;
            return (B)((Builder)this.self());
        }

        public B inOtEndTime(LocalTime inOtEndTime) {
            this.shiftSpec.inOtEndTime = inOtEndTime;
            return (B)((Builder)this.self());
        }

        public B firstRefDateType(RefDateType firstRefDateType) {
            this.shiftSpec.firstRefDateType = firstRefDateType;
            return (B)((Builder)this.self());
        }

        public B clockruleId(Long clockruleId) {
            this.shiftSpec.clockruleId = clockruleId;
            return (B)((Builder)this.self());
        }

        public B lastRefDateType(RefDateType lastRefDateType) {
            this.shiftSpec.lastRefDateType = lastRefDateType;
            return (B)((Builder)this.self());
        }

        public B earliestShiftTime(LocalTime earliestShiftTime) {
            this.shiftSpec.earliestShiftTime = earliestShiftTime;
            return (B)((Builder)this.self());
        }

        public B lastShiftTime(LocalTime lastShiftTime) {
            this.shiftSpec.lastShiftTime = lastShiftTime;
            return (B)((Builder)this.self());
        }

        public B workTime(int workTime) {
            this.shiftSpec.workTime = workTime;
            return (B)((Builder)this.self());
        }

        public B breakTime(int breakTime) {
            this.shiftSpec.breakTime = breakTime;
            return (B)((Builder)this.self());
        }

        public B otTime(int otTime) {
            this.shiftSpec.otTime = otTime;
            return (B)((Builder)this.self());
        }

        public B shiftTime(int shiftTime) {
            this.shiftSpec.shiftTime = shiftTime;
            return (B)((Builder)this.self());
        }

        public B alldayhour(BigDecimal alldayhour) {
            this.shiftSpec.alldayhour = alldayhour;
            return (B)((Builder)this.self());
        }

        public B standardTime(Integer standardTime) {
            this.shiftSpec.standardTime = standardTime;
            return (B)((Builder)this.self());
        }

        public B name(String name) {
            this.shiftSpec.name = name;
            return (B)((Builder)this.self());
        }

        public B chineseName(String chineseName) {
            this.shiftSpec.chineseName = chineseName;
            return (B)((Builder)this.self());
        }

        public B off(boolean off) {
            this.shiftSpec.off = off;
            return (B)((Builder)this.self());
        }

        public B offNonPlan(boolean offNonPlan) {
            this.shiftSpec.offNonPlan = offNonPlan;
            return (B)((Builder)this.self());
        }

        public B setShiftMiddleRule(ShiftMiddleRule shiftMiddleRule) {
            this.shiftSpec.shiftMiddleRule = shiftMiddleRule;
            return (B)((Builder)this.self());
        }

        public B setWorkSession(List<ShiftSession> workSession) {
            this.shiftSpec.workSession = workSession;
            return (B)((Builder)this.self());
        }
    }
}

