/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attconfig;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.attconfig.AttCustomDuration;
import kd.wtc.wtes.common.lang.WtesException;

public class AttRuleCal
extends AbstractTimeSeqVersion {
    private static final Log LOG = LogFactory.getLog(AttRuleCal.class);
    private String conditionJson;
    private String limitConditionJson;
    private List<TimeSeqBo<AttCustomDuration>> attCustomDurations;
    private transient AccessDto dateConditionAccessDto;
    private transient AccessDto limitConditionAccessDto;

    private AttRuleCal() {
    }

    public static Builder create() {
        return new Builder(new AttRuleCal());
    }

    public String getConditionJson() {
        return this.conditionJson;
    }

    public String getLimitConditionJson() {
        return this.limitConditionJson;
    }

    public List<TimeSeqBo<AttCustomDuration>> getAttCustomDurations() {
        return this.attCustomDurations;
    }

    public AccessDto getDateConditionAccessDto() {
        return this.dateConditionAccessDto;
    }

    public AccessDto getLimitConditionAccessDto() {
        return this.limitConditionAccessDto;
    }

    public static class Builder {
        private AttRuleCal attRuleCal;

        public Builder(AttRuleCal attRuleCal) {
            this.attRuleCal = attRuleCal;
        }

        public AttRuleCal build() {
            AttRuleCal temp = this.attRuleCal;
            this.attRuleCal = null;
            return temp;
        }

        public Builder setConditionJson(String conditionJson) {
            this.attRuleCal.conditionJson = conditionJson;
            if (HRStringUtils.isNotEmpty((String)conditionJson)) {
                try {
                    this.attRuleCal.dateConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public Builder setLimitConditionJson(String limitConditionJson) {
            this.attRuleCal.limitConditionJson = limitConditionJson;
            if (HRStringUtils.isNotEmpty((String)limitConditionJson)) {
                try {
                    this.attRuleCal.limitConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)limitConditionJson, AccessDto.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public Builder setAttCustomDurations(List<TimeSeqBo<AttCustomDuration>> attCustomDurations) {
            this.attRuleCal.attCustomDurations = attCustomDurations;
            return this;
        }
    }
}

