/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attconfig;

import java.math.BigDecimal;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.common.lang.WtesException;

public class AttendConfig
extends AbstractTimeSeqVersion {
    private static final Log logger = LogFactory.getLog(AttendConfig.class);
    private TimeSeqInfo timeSeqInfo;
    private String attendDays;
    private BigDecimal fixDays;
    private String attendDaysSE;
    private BigDecimal fixDaysSE;
    private String customPlugin;
    private String shiftConditionJsonTag;
    private transient AccessDto accessDto;

    private AttendConfig() {
    }

    public TimeSeqInfo getTimeSeqInfo() {
        return this.timeSeqInfo;
    }

    public String getAttendDays() {
        return this.attendDays;
    }

    public BigDecimal getFixDays() {
        return this.fixDays;
    }

    public String getAttendDaysSE() {
        return this.attendDaysSE;
    }

    public BigDecimal getFixDaysSE() {
        return this.fixDaysSE;
    }

    public String getCustomPlugin() {
        return this.customPlugin;
    }

    public String getShiftConditionJsonTag() {
        return this.shiftConditionJsonTag;
    }

    public AccessDto getAccessDto() {
        return this.accessDto;
    }

    public static Builder create() {
        return new Builder(new AttendConfig());
    }

    public static class Builder {
        private AttendConfig attendConfig;

        protected Builder(AttendConfig attendConfig) {
            this.attendConfig = attendConfig;
        }

        public Builder setTimeSeqInfo(TimeSeqInfo timeSeqInfo) {
            this.attendConfig.timeSeqInfo = timeSeqInfo;
            return this;
        }

        public Builder setAttendDays(String attendDays) {
            this.attendConfig.attendDays = attendDays;
            return this;
        }

        public Builder setFixDays(BigDecimal fixDays) {
            this.attendConfig.fixDays = fixDays;
            return this;
        }

        public Builder setAttendDaysSE(String attendDaysSE) {
            this.attendConfig.attendDaysSE = attendDaysSE;
            return this;
        }

        public Builder setFixDaysSE(BigDecimal fixDaysSE) {
            this.attendConfig.fixDaysSE = fixDaysSE;
            return this;
        }

        public Builder setCustomPlugin(String customPlugin) {
            this.attendConfig.customPlugin = customPlugin;
            return this;
        }

        public Builder setShiftConditionJsonTag(String shiftConditionJsonTag) {
            this.attendConfig.shiftConditionJsonTag = shiftConditionJsonTag;
            if (HRStringUtils.isNotEmpty((String)shiftConditionJsonTag)) {
                try {
                    this.attendConfig.accessDto = (AccessDto)SerializationUtils.fromJsonString((String)shiftConditionJsonTag, AccessDto.class);
                }
                catch (Exception e) {
                    logger.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public AttendConfig build() {
            AttendConfig tmp = this.attendConfig;
            this.attendConfig = null;
            return tmp;
        }
    }
}

