/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.attrecordadjust;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrim;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttRecordTrimData {
    private Map<LocalDate, Map<Long, List<AttRecordAdjust>>> dayResetRecord;
    private Map<LocalDate, Map<Long, List<AttRecordAdjust>>> dayTrimRecord;
    private Map<LocalDate, Map<Long, List<AttRecordAdjust>>> dayMoveRecord;
    private Map<Long, List<AttRecordAdjust>> periodResetRecord;
    private Map<Long, List<AttRecordAdjust>> periodTrimRecord;
    private Map<Long, List<AttRecordAdjust>> periodMoveRecord;
    Map<String, List<AttRecordAdjust>> adjustTrimMap;
    Map<String, List<AttRecordAdjust>> adjustMoveMap;
    Map<String, List<AttRecordAdjust>> adjustResetMap;

    private AttRecordTrimData() {
    }

    public static AttRecordTrimData of(AttRecordTrim attRecordTrim, AttPeriodTable attPeriodTable, List<AttSubject> attSubjectList) {
        List<AttRecordAdjust> attDayRecordAdjustList = attRecordTrim.getAttDayRecordAdjustList();
        List orderDayBtbs = attDayRecordAdjustList.stream().sorted(Comparator.comparing(AttRecordAdjust::getCreateTime)).collect(Collectors.toList());
        AttRecordTrimData attRecordAdjustData = new AttRecordTrimData();
        HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> dayTrimRecord = new HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>>(16);
        HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> dayResetRecord = new HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>>(16);
        HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> dayMoveRecord = new HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>>(16);
        for (AttRecordAdjust btb : orderDayBtbs) {
            String trimType = btb.getTrimType();
            HashMap<LocalDate, Map<Long, List<AttRecordAdjust>>> dayAdjustRecord = dayTrimRecord;
            if (HRStringUtils.equals((String)trimType, (String)"reset")) {
                dayAdjustRecord = dayResetRecord;
            }
            if (HRStringUtils.equals((String)trimType, (String)"move")) {
                dayAdjustRecord = dayMoveRecord;
            }
            Map date2Btbs = dayAdjustRecord.computeIfAbsent(btb.getCalculateDate(), key -> new HashMap(16));
            List btbList = date2Btbs.computeIfAbsent(btb.getAttPersonId(), key -> new LinkedList());
            btbList.add(btb);
        }
        List<AttRecordAdjust> attPeriodRecordAdjustList = attRecordTrim.getAttPeriodRecordAdjustList();
        List<AttRecordAdjust> orderPeriodBtbs = attPeriodRecordAdjustList.stream().sorted(Comparator.comparing(AttRecordAdjust::getCreateTime)).collect(Collectors.toList());
        HashMap<Long, List<AttRecordAdjust>> periodTrimRecord = new HashMap<Long, List<AttRecordAdjust>>(16);
        HashMap<Long, List<AttRecordAdjust>> periodResetRecord = new HashMap<Long, List<AttRecordAdjust>>(16);
        HashMap<Long, List<AttRecordAdjust>> periodMoveRecord = new HashMap<Long, List<AttRecordAdjust>>(16);
        for (AttRecordAdjust btb : orderPeriodBtbs) {
            String trimType = btb.getTrimType();
            HashMap<Long, List<AttRecordAdjust>> periodAdjustRecord = periodTrimRecord;
            if (HRStringUtils.equals((String)trimType, (String)"reset")) {
                periodAdjustRecord = periodResetRecord;
            }
            if (HRStringUtils.equals((String)trimType, (String)"move")) {
                periodAdjustRecord = periodMoveRecord;
            }
            List btbList = periodAdjustRecord.computeIfAbsent(btb.getAttPersonId(), key -> new LinkedList());
            btbList.add(btb);
        }
        attRecordAdjustData.dayTrimRecord = dayTrimRecord;
        attRecordAdjustData.dayResetRecord = dayResetRecord;
        attRecordAdjustData.dayMoveRecord = dayMoveRecord;
        attRecordAdjustData.periodTrimRecord = periodTrimRecord;
        attRecordAdjustData.periodResetRecord = periodResetRecord;
        attRecordAdjustData.periodMoveRecord = periodMoveRecord;
        HashMap adjustTrimMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap adjustMoveMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap adjustResetMap = Maps.newHashMapWithExpectedSize((int)16);
        AttRecordTrimData.geneAdjustmap(orderPeriodBtbs, attPeriodTable, adjustTrimMap, adjustMoveMap, adjustResetMap, attSubjectList);
        attRecordAdjustData.adjustTrimMap = adjustTrimMap;
        attRecordAdjustData.adjustMoveMap = adjustMoveMap;
        attRecordAdjustData.adjustResetMap = adjustResetMap;
        return attRecordAdjustData;
    }

    private static void geneAdjustmap(List<AttRecordAdjust> orderPeriodBtbs, AttPeriodTable attPeriodTable, Map<String, List<AttRecordAdjust>> adjustTrimMap, Map<String, List<AttRecordAdjust>> adjustMoveMap, Map<String, List<AttRecordAdjust>> adjustResetMap, List<AttSubject> attSubjectList) {
        for (AttRecordAdjust attRecordAdjust : orderPeriodBtbs) {
            String trimType = attRecordAdjust.getTrimType();
            List<PerAttPeriod> perAttPeriodList = attPeriodTable.getPerAttPeriod(attRecordAdjust.getAttPersonId(), attRecordAdjust.getStartDate(), attRecordAdjust.getEndDate());
            Optional<AttSubject> attSubjectOptional = attSubjectList.stream().filter(ob -> ob.getAttPersonId() == attRecordAdjust.getAttPersonId()).findFirst();
            if (!attSubjectOptional.isPresent()) continue;
            AttSubject attSubject = attSubjectOptional.get();
            for (PerAttPeriod perAttPeriod : perAttPeriodList) {
                if (HRStringUtils.equals((String)trimType, (String)"trim")) {
                    AttRecordTrimData.addAdjustMap(adjustTrimMap, perAttPeriod, attRecordAdjust, attSubject);
                    continue;
                }
                if (HRStringUtils.equals((String)trimType, (String)"reset")) {
                    AttRecordTrimData.addAdjustMap(adjustResetMap, perAttPeriod, attRecordAdjust, attSubject);
                    continue;
                }
                AttRecordTrimData.addAdjustMap(adjustMoveMap, perAttPeriod, attRecordAdjust, attSubject);
            }
        }
    }

    private static void addAdjustMap(Map<String, List<AttRecordAdjust>> adjustmap, PerAttPeriod perAttPeriod, AttRecordAdjust attRecordAdjust, AttSubject attSubject) {
        List adjusts = adjustmap.computeIfAbsent(perAttPeriod.getId(), key -> new ArrayList());
        if (!adjusts.stream().filter(ob -> ob.getItemId() == attRecordAdjust.getItemId()).findAny().isPresent() && attRecordAdjust.getStartDate().compareTo(attSubject.getEndDate()) <= 0 && attRecordAdjust.getEndDate().compareTo(attSubject.getStartDate()) >= 0) {
            adjusts.add(attRecordAdjust);
        }
    }

    @NotNull
    public List<AttRecordAdjust> getDayAdjustRecords(long personId, LocalDate inDate, String trimType) {
        Map<LocalDate, Map<Long, List<AttRecordAdjust>>> dayAdjustRecord = HRStringUtils.equals((String)trimType, (String)"trim") ? this.dayTrimRecord : (HRStringUtils.equals((String)trimType, (String)"reset") ? this.dayResetRecord : this.dayMoveRecord);
        Map<Long, List<AttRecordAdjust>> date2Btbs = dayAdjustRecord.get(inDate);
        if (CollectionUtils.isEmpty(date2Btbs)) {
            return Collections.emptyList();
        }
        return date2Btbs.getOrDefault(personId, Collections.emptyList());
    }

    @NotNull
    public Map<String, List<AttRecordAdjust>> getPeriodAdjustRecordMap(String trimType) {
        if (HRStringUtils.equals((String)trimType, (String)"trim")) {
            return this.adjustTrimMap;
        }
        if (HRStringUtils.equals((String)trimType, (String)"reset")) {
            return this.adjustResetMap;
        }
        return this.adjustMoveMap;
    }

    @NotNull
    public List<AttRecordAdjust> getPeriodAdjustRecords(long personId, String trimType) {
        Map<Long, List<AttRecordAdjust>> periodAdjustRecord = HRStringUtils.equals((String)trimType, (String)"trim") ? this.periodTrimRecord : (HRStringUtils.equals((String)trimType, (String)"reset") ? this.periodResetRecord : this.periodMoveRecord);
        if (CollectionUtils.isEmpty(periodAdjustRecord)) {
            return Collections.emptyList();
        }
        return periodAdjustRecord.getOrDefault(personId, Collections.emptyList());
    }

    public Map<LocalDate, Map<Long, List<AttRecordAdjust>>> getDayResetRecord() {
        return this.dayResetRecord;
    }

    public Map<LocalDate, Map<Long, List<AttRecordAdjust>>> getDayTrimRecord() {
        return this.dayTrimRecord;
    }

    public Map<LocalDate, Map<Long, List<AttRecordAdjust>>> getDayMoveRecord() {
        return this.dayMoveRecord;
    }

    public Map<Long, List<AttRecordAdjust>> getPeriodResetRecord() {
        return this.periodResetRecord;
    }

    public Map<Long, List<AttRecordAdjust>> getPeriodTrimRecord() {
        return this.periodTrimRecord;
    }

    public Map<Long, List<AttRecordAdjust>> getPeriodMoveRecord() {
        return this.periodMoveRecord;
    }

    public Map<String, List<AttRecordAdjust>> getAdjustTrimMap() {
        return this.adjustTrimMap;
    }

    public Map<String, List<AttRecordAdjust>> getAdjustMoveMap() {
        return this.adjustMoveMap;
    }

    public Map<String, List<AttRecordAdjust>> getAdjustResetMap() {
        return this.adjustResetMap;
    }
}

