/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.quotacal.retrieval;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.quotacal.retrieval.QuotaRetrievalDimensionResult;

public class QuotaRetrievalResult {
    private Map<Long, Map<LocalDate, List<QuotaRetrievalDimensionResult>>> qtRretrievalResultDateMap;
    Set<Long> qtRuleIds = Sets.newHashSetWithExpectedSize((int)16);

    public QuotaRetrievalResult(Map<String, Set<QuotaRetrievalDimensionResult>> retrievalResultMap) {
        Set<QuotaRetrievalDimensionResult> byBillCate;
        if (WTCCollections.isNotEmpty(retrievalResultMap) && WTCCollections.isNotEmpty(byBillCate = retrievalResultMap.get("wtp_qtgenconfig"))) {
            this.qtRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)byBillCate.size());
            this.initRetrievalResultMap(byBillCate, this.qtRretrievalResultDateMap);
        }
    }

    private void initRetrievalResultMap(Set<QuotaRetrievalDimensionResult> dimensionResults, Map<Long, Map<LocalDate, List<QuotaRetrievalDimensionResult>>> resultMap) {
        for (QuotaRetrievalDimensionResult dimensionResult : dimensionResults) {
            long attPersonId = dimensionResult.getAttPersonId();
            LocalDate rosterDate = dimensionResult.getRosterDate();
            Map localDateListMap = resultMap.computeIfAbsent(attPersonId, item -> new HashMap(16));
            List qtRetrievalDimensionResults = localDateListMap.computeIfAbsent(rosterDate, item -> new ArrayList(16));
            qtRetrievalDimensionResults.add(dimensionResult);
        }
    }

    public void addQTRetrievalResult(Set<QuotaRetrievalDimensionResult> qtRetrievalResultSet) {
        if (WTCCollections.isNotEmpty(qtRetrievalResultSet)) {
            if (WTCCollections.isEmpty(this.qtRretrievalResultDateMap)) {
                this.qtRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)qtRetrievalResultSet.size());
            }
            this.initRetrievalResultMap(qtRetrievalResultSet, this.qtRretrievalResultDateMap);
        }
    }

    public Set<QuotaRetrievalDimensionResult> getByPersonAndDate(long attPersonId, LocalDate rosterDate) {
        return this.getByPersonAndDate(attPersonId, rosterDate, "wtp_qtgenconfig");
    }

    public Set<QuotaRetrievalDimensionResult> getByPersonAndDate(long attPersonId, LocalDate rosterDate, String type) {
        List<QuotaRetrievalDimensionResult> dimensionResults;
        Map<LocalDate, List<QuotaRetrievalDimensionResult>> localDateListMap;
        Map<Long, Map<LocalDate, List<QuotaRetrievalDimensionResult>>> resultMap = this.qtRretrievalResultDateMap;
        if (WTCCollections.isNotEmpty(resultMap) && WTCCollections.isNotEmpty(localDateListMap = resultMap.get(attPersonId)) && WTCCollections.isNotEmpty(dimensionResults = localDateListMap.get(rosterDate))) {
            return Sets.newHashSet(dimensionResults);
        }
        return new HashSet<QuotaRetrievalDimensionResult>(0);
    }

    public void setQtRuleIds(Set<Long> qtRuleIds) {
        this.qtRuleIds = qtRuleIds;
    }

    public boolean containsQtRuleId(long qtRuleId) {
        return this.qtRuleIds.contains(qtRuleId);
    }

    public Map<Long, Map<LocalDate, List<QuotaRetrievalDimensionResult>>> getQtRretrievalResultDateMap() {
        return this.qtRretrievalResultDateMap;
    }

    public Set<Long> getQtRuleIds() {
        return this.qtRuleIds;
    }
}

