/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.retrieval;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.retrieval.BillRetrievalDimensionResult;

public class BillRetrievalResult {
    private Map<Long, Map<LocalDate, List<BillRetrievalDimensionResult>>> billRretrievalResultDateMap;
    private Map<Long, Map<LocalDate, List<BillRetrievalDimensionResult>>> timeCutRretrievalResultDateMap;
    Set<Long> otRuleIds = Sets.newHashSetWithExpectedSize((int)16);
    Set<Long> timeCutIds = Sets.newHashSetWithExpectedSize((int)16);

    public BillRetrievalResult(Map<String, Set<BillRetrievalDimensionResult>> retrievalResultMap) {
        if (WTCCollections.isNotEmpty(retrievalResultMap)) {
            Set<BillRetrievalDimensionResult> timeCutDimensionResults;
            Set<BillRetrievalDimensionResult> byBillCate = retrievalResultMap.get("OT");
            if (WTCCollections.isNotEmpty(byBillCate)) {
                this.billRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)byBillCate.size());
                this.initRetrievalResultMap(byBillCate, this.billRretrievalResultDateMap);
            }
            if (WTCCollections.isNotEmpty(timeCutDimensionResults = retrievalResultMap.get("time_cut"))) {
                this.timeCutRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)byBillCate.size());
                this.initRetrievalResultMap(timeCutDimensionResults, this.timeCutRretrievalResultDateMap);
            }
        }
    }

    private void initRetrievalResultMap(Set<BillRetrievalDimensionResult> dimensionResults, Map<Long, Map<LocalDate, List<BillRetrievalDimensionResult>>> resultMap) {
        for (BillRetrievalDimensionResult dimensionResult : dimensionResults) {
            long attPersonId = dimensionResult.getAttPersonId();
            LocalDate rosterDate = dimensionResult.getRosterDate();
            Map localDateListMap = resultMap.computeIfAbsent(attPersonId, item -> new HashMap(16));
            List billRetrievalDimensionResults = localDateListMap.computeIfAbsent(rosterDate, item -> new ArrayList(16));
            billRetrievalDimensionResults.add(dimensionResult);
        }
    }

    public void addBillRetrievalResult(Set<BillRetrievalDimensionResult> billRetrievalResultSet) {
        if (WTCCollections.isNotEmpty(billRetrievalResultSet)) {
            if (WTCCollections.isEmpty(this.billRretrievalResultDateMap)) {
                this.billRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)billRetrievalResultSet.size());
            }
            this.initRetrievalResultMap(billRetrievalResultSet, this.billRretrievalResultDateMap);
        }
    }

    public void addTimeCutRetrievalResult(Set<BillRetrievalDimensionResult> billRetrievalResultSet) {
        if (WTCCollections.isNotEmpty(billRetrievalResultSet)) {
            if (WTCCollections.isEmpty(this.timeCutRretrievalResultDateMap)) {
                this.timeCutRretrievalResultDateMap = Maps.newHashMapWithExpectedSize((int)billRetrievalResultSet.size());
            }
            this.initRetrievalResultMap(billRetrievalResultSet, this.timeCutRretrievalResultDateMap);
        }
    }

    public Set<BillRetrievalDimensionResult> getByPersonAndDate(long attPersonId, LocalDate rosterDate) {
        return this.getByPersonAndDate(attPersonId, rosterDate, "OT");
    }

    public Set<BillRetrievalDimensionResult> getByPersonAndDate(long attPersonId, LocalDate rosterDate, String type) {
        List<BillRetrievalDimensionResult> dimensionResults;
        Map<LocalDate, List<BillRetrievalDimensionResult>> localDateListMap;
        Map<Long, Map<LocalDate, List<BillRetrievalDimensionResult>>> resultMap = this.billRretrievalResultDateMap;
        if ("time_cut".equals(type)) {
            resultMap = this.timeCutRretrievalResultDateMap;
        }
        if (WTCCollections.isNotEmpty(resultMap) && WTCCollections.isNotEmpty(localDateListMap = resultMap.get(attPersonId)) && WTCCollections.isNotEmpty(dimensionResults = localDateListMap.get(rosterDate))) {
            return Sets.newHashSet(dimensionResults);
        }
        return new HashSet<BillRetrievalDimensionResult>(0);
    }

    public void setOtRuleIds(Set<Long> otRuleIds) {
        this.otRuleIds = otRuleIds;
    }

    public boolean containsOtRuleId(long otRuleId) {
        return this.otRuleIds.contains(otRuleId);
    }

    public void setTimeCutIds(Set<Long> timeCutIds) {
        this.timeCutIds = timeCutIds;
    }

    public boolean containsTimeCutId(long timeCutId) {
        return this.timeCutIds.contains(timeCutId);
    }
}

