/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlad;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtp.enums.supple.SignCardSourceEnum;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.rlad.AdCalcData;
import kd.wtc.wtes.business.model.util.AdEntityUtils;

public class AdCalcDataModel {
    private static final Log LOG = LogFactory.getLog(AdCalcDataModel.class);
    private Map<Long, Map<LocalDate, List<AdCalcData>>> adCalcDataMap = new HashMap<Long, Map<LocalDate, List<AdCalcData>>>(16);
    private static final String SHIFTDATE = "shiftdate";
    private static final String SOURCE = "source";
    private static final String APPLYREASON = "applyreason";
    private static final String ONCECARD_QUERYFILED = "attperson attperson,shiftdate shiftdate,applyreason applyreason";
    private static final String MULICARD_QUERYFIELD = "attperson attperson,shiftdate shiftdate,entryentity.applyreason applyreason";

    public void initOriginalCard(InitParam initRequest) {
        Tuple<LocalDate, LocalDate> timeScopeRange = AdEntityUtils.getDefaultMaxTimeScopeRange(initRequest);
        if (timeScopeRange != null) {
            LocalDate startDate = (LocalDate)timeScopeRange.getKey();
            LocalDate endDate = (LocalDate)timeScopeRange.getValue();
            Date startDateZero = WTCDateUtils.getZeroDate((Date)WTCDateUtils.toDate((LocalDate)startDate));
            Date endDateZero = WTCDateUtils.getDayLastDate((Date)WTCDateUtils.toDate((LocalDate)endDate));
            LOG.debug("AdCalcDataModel.initOriginalCard Max query date range :beginDate:{},endDate:{}", (Object)startDateZero, (Object)endDateZero);
            List<Long> attFileBoids = initRequest.getAttPersonIds();
            if (AdEntityUtils.isCountByOriginalCard()) {
                this.initOriginalCardData(attFileBoids, startDateZero, endDateZero);
                LOG.debug("AdCalcDataModel.initOriginalCard initOriginalCardData");
            } else {
                this.initEffCardData(attFileBoids, startDateZero, endDateZero);
                LOG.debug("AdCalcDataModel.initOriginalCard initEffCardData");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEffCardData(List<Long> attFileBoids, Date startDate, Date endDate) {
        DataSet onceDataSet = null;
        DataSet mulDataSet = null;
        DataSet unionDataSet = null;
        try {
            QFilter qFilter = this.getQFilter(attFileBoids, startDate, endDate);
            String algoKey = this.getClass().getName();
            QFilter onceSourceFilter = new QFilter(SOURCE, "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
            onceDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_oncecard", (String)ONCECARD_QUERYFILED, (QFilter[])new QFilter[]{qFilter, onceSourceFilter}, null);
            QFilter mulSourceFilter = new QFilter("entryentity.source", "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
            mulDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_multicard", (String)MULICARD_QUERYFIELD, (QFilter[])new QFilter[]{qFilter, mulSourceFilter}, null);
            unionDataSet = onceDataSet.union(mulDataSet);
            while (unionDataSet.hasNext()) {
                Row next = unionDataSet.next();
                Long attPersonId = next.getLong("attperson");
                LocalDate signDate = WTCDateUtils.toLocalDate((Date)next.getDate(SHIFTDATE));
                Long applyReasonId = next.getLong(APPLYREASON);
                Map byDateMap = this.adCalcDataMap.computeIfAbsent(attPersonId, key -> new HashMap(16));
                List adCalcDataList = byDateMap.computeIfAbsent(signDate, key -> new ArrayList(16));
                AdCalcData adCalcData = new AdCalcData(attPersonId, signDate, applyReasonId);
                adCalcDataList.add(adCalcData);
            }
        }
        finally {
            if (onceDataSet != null) {
                onceDataSet.close();
            }
            if (mulDataSet != null) {
                mulDataSet.close();
            }
            if (unionDataSet != null) {
                unionDataSet.close();
            }
        }
    }

    private void initOriginalCardData(List<Long> attFileBoids, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("attperson", "in", attFileBoids);
        String signPoint = "signpoint";
        qFilter.and(signPoint, ">=", (Object)startDate);
        qFilter.and(signPoint, "<=", (Object)endDate);
        qFilter.and(SOURCE, "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
        qFilter.and("status", "=", (Object)"1");
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        String queryProp = "attperson,signpoint,source,applyreason,pointtag";
        DynamicObject[] originalCardArr = baseServiceHelper.queryOriginalArray(queryProp, qFilter.toArray());
        this.resolveData(originalCardArr);
    }

    private void resolveData(DynamicObject[] originalCardArr) {
        for (DynamicObject originalCard : originalCardArr) {
            Long attPersonId = originalCard.getLong("attperson");
            Date signPoint = originalCard.getDate("signpoint");
            String pointTag = originalCard.getString("pointtag");
            LocalDate signDate = WTCDateUtils.toLocalDate((Date)AdCalcDataModel.getShiftBelongDate(signPoint, pointTag));
            long applyReasonId = originalCard.getLong(APPLYREASON);
            Map byDateMap = this.adCalcDataMap.computeIfAbsent(attPersonId, key -> new HashMap(16));
            List adCalcDataList = byDateMap.computeIfAbsent(signDate, key -> new ArrayList(16));
            AdCalcData adCalcData = new AdCalcData(attPersonId, signDate, applyReasonId);
            adCalcDataList.add(adCalcData);
        }
    }

    private QFilter getQFilter(List<Long> attPersonIds, Date checkBeginDate, Date checkEndDate) {
        QFilter attPersonQFilter = null != attPersonIds && attPersonIds.size() == 1 ? new QFilter("attperson", "=", (Object)attPersonIds.get(0)) : new QFilter("attperson", "in", attPersonIds);
        QFilter shiftDateQFilter = checkBeginDate.compareTo(checkEndDate) == 0 ? new QFilter(SHIFTDATE, "=", (Object)checkBeginDate) : new QFilter(SHIFTDATE, ">=", (Object)checkBeginDate).and(new QFilter(SHIFTDATE, "<=", (Object)checkEndDate));
        return shiftDateQFilter.and(attPersonQFilter);
    }

    public static Date getShiftBelongDate(Date signDate, String pointTag) {
        if (signDate == null) {
            return null;
        }
        if ("E".equals(pointTag)) {
            signDate = WTCDateUtils.getBeforeDate((Date)signDate);
        } else if ("F".equals(pointTag)) {
            signDate = WTCDateUtils.getNextDate((Date)signDate);
        }
        return signDate;
    }

    public Map<Long, Map<LocalDate, List<AdCalcData>>> getAdCalcDataMap() {
        return this.adCalcDataMap;
    }
}

