/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlex;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.rlexenum.DurationUnitEnum;
import kd.wtc.wtes.business.model.rlexenum.ExDealTypeEnum;
import kd.wtc.wtes.common.lang.WtesException;

public class ExConfigEntry
implements IEntity {
    private static final Log LOG = LogFactory.getLog(ExConfigEntry.class);
    private long id;
    private String number;
    private Long origAttItem;
    private Long punchCard;
    private ExDealTypeEnum dealType;
    private String backSet;
    private transient RuleConditionInfo backSetCondition;
    private String are;
    private BigDecimal culValue;
    private DurationUnitEnum unit;
    private BigDecimal culValueSecond;
    private String logic;
    private String bre;
    private BigDecimal maxValue;
    private BigDecimal maxValueSecond;
    private DurationUnitEnum aunit;
    private String dealMethod;
    private Long roundRule;
    private BigDecimal timeValue;
    private DurationUnitEnum appointUnit;
    private List<Long> resultAttItems;

    public ExDealTypeEnum getDealType() {
        return this.dealType;
    }

    public String getAre() {
        return this.are;
    }

    public DurationUnitEnum getUnit() {
        return this.unit;
    }

    public String getLogic() {
        return this.logic;
    }

    public String getBre() {
        return this.bre;
    }

    public DurationUnitEnum getAunit() {
        return this.aunit;
    }

    public Long getOrigAttItem() {
        return this.origAttItem;
    }

    public Long getPunchCard() {
        return this.punchCard;
    }

    public String getBackSet() {
        return this.backSet;
    }

    public BigDecimal getCulValue() {
        return this.culValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public String getDealMethod() {
        return this.dealMethod;
    }

    public Long getRoundRule() {
        return this.roundRule;
    }

    public BigDecimal getTimeValue() {
        return this.timeValue;
    }

    public List<Long> getResultAttItems() {
        return this.resultAttItems;
    }

    public BigDecimal getCulValueSecond() {
        return this.culValueSecond;
    }

    public BigDecimal getMaxValueSecond() {
        return this.maxValueSecond;
    }

    public RuleConditionInfo getBackSetCondition() {
        return this.backSetCondition;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public DurationUnitEnum getAppointUnit() {
        return this.appointUnit;
    }

    public static final class ExConfigEntryBuilder {
        private Long id;
        private String number;
        private Long punchCard;
        private String backSet;
        private String are;
        private BigDecimal culValue;
        private DurationUnitEnum unit;
        private String logic;
        private String bre;
        private BigDecimal maxValue;
        private DurationUnitEnum aunit;
        private Long roundRule;
        private String dealMethod;
        private BigDecimal timeValue;
        private DurationUnitEnum appointUnit;
        private ExDealTypeEnum dealType;
        private List<Long> resultAttItems;
        private Long origAttItem;
        private transient RuleConditionInfo backSetCondition;

        private ExConfigEntryBuilder() {
        }

        public static ExConfigEntryBuilder getEmp() {
            return new ExConfigEntryBuilder();
        }

        public ExConfigEntryBuilder origAttItem(Long origAttItem) {
            this.origAttItem = origAttItem;
            return this;
        }

        public ExConfigEntryBuilder punchCard(Long punchCard) {
            this.punchCard = punchCard;
            return this;
        }

        public ExConfigEntryBuilder backSet(String backSet) {
            this.backSet = backSet;
            if (HRStringUtils.isNotEmpty((String)backSet)) {
                try {
                    this.backSetCondition = (RuleConditionInfo)SerializationUtils.fromJsonString((String)backSet, RuleConditionInfo.class);
                }
                catch (Exception e) {
                    LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                    throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
                }
            }
            return this;
        }

        public ExConfigEntryBuilder are(String are) {
            this.are = are;
            return this;
        }

        public ExConfigEntryBuilder culValue(BigDecimal culValue) {
            this.culValue = culValue;
            return this;
        }

        public ExConfigEntryBuilder unit(DurationUnitEnum unit) {
            this.unit = unit;
            return this;
        }

        public ExConfigEntryBuilder logic(String logic) {
            this.logic = logic;
            return this;
        }

        public ExConfigEntryBuilder bre(String bre) {
            this.bre = bre;
            return this;
        }

        public ExConfigEntryBuilder maxValue(BigDecimal maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public ExConfigEntryBuilder aunit(DurationUnitEnum aunit) {
            this.aunit = aunit;
            return this;
        }

        public ExConfigEntryBuilder roundRule(Long roundRule) {
            this.roundRule = roundRule;
            return this;
        }

        public ExConfigEntryBuilder dealMethod(String dealMethod) {
            this.dealMethod = dealMethod;
            return this;
        }

        public ExConfigEntryBuilder timeValue(BigDecimal timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        public ExConfigEntryBuilder appointUnit(DurationUnitEnum appointUnit) {
            this.appointUnit = appointUnit;
            return this;
        }

        public ExConfigEntryBuilder resultAttItems(List<Long> resultAttItems) {
            this.resultAttItems = resultAttItems;
            return this;
        }

        public ExConfigEntryBuilder dealType(ExDealTypeEnum dealType) {
            this.dealType = dealType;
            return this;
        }

        public ExConfigEntryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ExConfigEntryBuilder number(String number) {
            this.number = number;
            return this;
        }

        public ExConfigEntry build() {
            ExConfigEntry configDealEntryPackage = new ExConfigEntry();
            configDealEntryPackage.id = this.id;
            configDealEntryPackage.number = this.number;
            configDealEntryPackage.punchCard = this.punchCard;
            configDealEntryPackage.dealType = this.dealType;
            configDealEntryPackage.backSet = this.backSet;
            configDealEntryPackage.are = this.are;
            configDealEntryPackage.culValue = this.culValue;
            configDealEntryPackage.unit = this.unit;
            configDealEntryPackage.logic = this.logic;
            configDealEntryPackage.bre = this.bre;
            configDealEntryPackage.maxValue = this.maxValue;
            configDealEntryPackage.aunit = this.aunit;
            configDealEntryPackage.roundRule = this.roundRule;
            configDealEntryPackage.dealMethod = this.dealMethod;
            configDealEntryPackage.timeValue = this.timeValue;
            configDealEntryPackage.appointUnit = this.appointUnit;
            configDealEntryPackage.resultAttItems = this.resultAttItems;
            configDealEntryPackage.origAttItem = this.origAttItem;
            configDealEntryPackage.culValueSecond = DurationUnitEnum.changeValueToSecond(this.unit.getCode(), this.culValue);
            configDealEntryPackage.maxValueSecond = DurationUnitEnum.changeValueToSecond(this.aunit.getCode(), this.maxValue);
            configDealEntryPackage.backSetCondition = this.backSetCondition;
            return configDealEntryPackage;
        }
    }
}

