/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlfm;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.model.rlfm.FormulaConfigPackage;

public class FormulaRulePackage
extends AbstractTimeSeqVersion {
    private List<TimeSeqBo<FormulaConfigPackage>> configs;
    private long accountPlanId;

    public FormulaRulePackage(TimeSeqInfo timeSeqInfo) {
        super(timeSeqInfo);
    }

    public List<TimeSeqBo<FormulaConfigPackage>> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<TimeSeqBo<FormulaConfigPackage>> configs) {
        this.configs = configs;
    }

    public List<FormulaConfigPackage> getConfigsByDateAndStepId(LocalDate chainDate, long planId, long stepId) {
        ArrayList<FormulaConfigPackage> list = new ArrayList<FormulaConfigPackage>();
        if (this.accountPlanId == planId) {
            for (TimeSeqBo<FormulaConfigPackage> config : this.configs) {
                FormulaConfigPackage configPack = (FormulaConfigPackage)config.getVersionByDate(chainDate);
                if (null == configPack || configPack.getAccStepId() != stepId) continue;
                list.add(configPack);
            }
        }
        list.sort(Comparator.comparingInt(FormulaConfigPackage::getExecOrder));
        return list;
    }

    public long getAccountPlanId() {
        return this.accountPlanId;
    }

    public void setAccountPlanId(long accountPlanId) {
        this.accountPlanId = accountPlanId;
    }
}

