/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlotcal;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.attconfig.AttRuleCal;
import kd.wtc.wtes.business.model.rlotcal.OtRuleCalCompenConfig;
import kd.wtc.wtes.common.lang.WtesException;

public class OtRuleCalConfig
implements IEntity {
    private static final long serialVersionUID = -6804320637240676152L;
    private static final Log LOG = LogFactory.getLog(AttRuleCal.class);
    private Long otType;
    private Long dataSources;
    private String otCompenMode;
    private Long entryId;
    private String limitscope;
    private String dateRangeCondition;
    private transient AccessDto dateConditionAccessDto;
    private transient AccessDto limitConditionAccessDto;
    private Boolean isempchoice;
    private List<OtRuleCalCompenConfig> otRuleCalCompenConfigs;
    private OtRuleCalCompenConfig matchOtRuleCalCompenConfig;

    public static Builder builder() {
        return new Builder();
    }

    public OtRuleCalCompenConfig getMatchOtRuleCalCompenConfig() {
        return this.matchOtRuleCalCompenConfig;
    }

    public List<OtRuleCalCompenConfig> getOtRuleCalCompenConfigs() {
        return this.otRuleCalCompenConfigs;
    }

    public Boolean getIsempchoice() {
        return this.isempchoice;
    }

    public String getLimitscope() {
        return this.limitscope;
    }

    public String getDateRangeCondition() {
        return this.dateRangeCondition;
    }

    private OtRuleCalConfig() {
    }

    public Long getOtType() {
        return this.otType;
    }

    public Long getDataSources() {
        return this.dataSources;
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public String getOtCompenMode() {
        return this.otCompenMode;
    }

    public AccessDto getDateConditionAccessDto() {
        if (this.dateConditionAccessDto == null && HRStringUtils.isNotEmpty((String)this.dateRangeCondition)) {
            try {
                this.dateConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)this.dateRangeCondition, AccessDto.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this.dateConditionAccessDto;
    }

    public AccessDto getLimitConditionAccessDto() {
        if (this.limitConditionAccessDto == null && HRStringUtils.isNotEmpty((String)this.limitscope)) {
            try {
                this.limitConditionAccessDto = (AccessDto)SerializationUtils.fromJsonString((String)this.limitscope, AccessDto.class);
            }
            catch (Exception e) {
                LOG.warn("JsonProcessingException:", (Object)e.getMessage());
                throw new WtesException(TieEngineErrorCodes.getParamValidateErr(), new Object[]{"JsonProcessingException"});
            }
        }
        return this.limitConditionAccessDto;
    }

    public long getId() {
        return this.entryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtRuleCalConfig calConfig = (OtRuleCalConfig)o;
        return Objects.equals(this.entryId, calConfig.entryId) && Objects.equals(this.matchOtRuleCalCompenConfig.getEntryId(), calConfig.matchOtRuleCalCompenConfig.getEntryId());
    }

    public int hashCode() {
        return Objects.hash(this.entryId, this.matchOtRuleCalCompenConfig.getEntryId());
    }

    public String getNumber() {
        return String.valueOf(this.entryId);
    }

    public static class Builder {
        private OtRuleCalConfig otRuleCalConfig = new OtRuleCalConfig();

        public OtRuleCalConfig build() {
            OtRuleCalConfig temp = this.otRuleCalConfig;
            this.otRuleCalConfig = null;
            return temp;
        }

        public Builder setOtRuleCalCompenConfig(List<OtRuleCalCompenConfig> otRuleCalCompenConfigs) {
            this.otRuleCalConfig.otRuleCalCompenConfigs = otRuleCalCompenConfigs;
            return this;
        }

        public Builder setOtType(Long otType) {
            this.otRuleCalConfig.otType = otType;
            return this;
        }

        public Builder setDataSources(Long dataSources) {
            this.otRuleCalConfig.dataSources = dataSources;
            return this;
        }

        public Builder setLimitscope(String limitscope) {
            this.otRuleCalConfig.limitscope = limitscope;
            return this;
        }

        public Builder setLimitConditionAccessDto(AccessDto limitConditionAccessDto) {
            this.otRuleCalConfig.limitConditionAccessDto = limitConditionAccessDto;
            return this;
        }

        public Builder setDateConditionAccessDto(AccessDto dateConditionAccessDto) {
            this.otRuleCalConfig.dateConditionAccessDto = dateConditionAccessDto;
            return this;
        }

        public Builder setDateRangeCondition(String dateRangeCondition) {
            this.otRuleCalConfig.dateRangeCondition = dateRangeCondition;
            return this;
        }

        public Builder setBaseDataId(Long baseDataId) {
            this.otRuleCalConfig.entryId = baseDataId;
            return this;
        }

        public Builder setOtCompenMode(String otCompenMode) {
            this.otRuleCalConfig.otCompenMode = otCompenMode;
            return this;
        }

        public Builder setIsempchoice(Boolean isempchoice) {
            this.otRuleCalConfig.isempchoice = isempchoice;
            return this;
        }

        public Builder setMatchOtRuleCalCompenConfig(OtRuleCalCompenConfig matchOtRuleCalCompenConfig) {
            this.otRuleCalConfig.matchOtRuleCalCompenConfig = matchOtRuleCalCompenConfig;
            return this;
        }
    }
}

