/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlotcal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtes.business.model.rlotcal.OtDeductSubTimeItem;
import kd.wtc.wtes.business.model.rlotcal.OtSubTimeItem;

public class OtSubConfig
extends AbstractTimeSeqVersion
implements TimeSeqVersion {
    private TimeSeqInfo timeSeqEntity;
    private String subType;
    private BigDecimal fixTimes;
    private String selectSub;
    private BigDecimal desTimes;
    private List<OtSubTimeItem> otSubTimeItemList;
    private List<OtDeductSubTimeItem> otDeductSubTimeItemList;

    private OtSubConfig() {
    }

    private OtSubConfig(TimeSeqInfoImpl timeSeqEntity) {
        this.timeSeqEntity = timeSeqEntity;
    }

    public static Builder createSub() {
        return new Builder(new OtSubConfig());
    }

    public static Builder createSub(TimeSeqInfoImpl timeSeqEntity) {
        return new Builder(new OtSubConfig(timeSeqEntity));
    }

    public TimeSeqInfo getTimeSeqInfo() {
        return this.timeSeqEntity;
    }

    public String getSubType() {
        return this.subType;
    }

    public BigDecimal getFixTimes() {
        return this.fixTimes;
    }

    public String getSelectSub() {
        return this.selectSub;
    }

    public BigDecimal getDesTimes() {
        return this.desTimes;
    }

    public List<OtSubTimeItem> getOtSubTimeItemList() {
        return this.otSubTimeItemList;
    }

    public List<OtDeductSubTimeItem> getOtDeductSubTimeItemList() {
        return this.otDeductSubTimeItemList;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeSeqEntity, this.subType);
    }

    public static class Builder {
        private OtSubConfig subConfig;

        public Builder(OtSubConfig subConfig) {
            this.subConfig = subConfig;
        }

        public OtSubConfig build() {
            OtSubConfig temp = this.subConfig;
            this.subConfig = null;
            return temp;
        }

        public Builder setTimeSeqEntity(TimeSeqInfo timeSeqEntity) {
            this.subConfig.timeSeqEntity = timeSeqEntity;
            this.subConfig.id = timeSeqEntity.getVid();
            return this;
        }

        public Builder setSubType(String subType) {
            this.subConfig.subType = subType;
            return this;
        }

        public Builder setSelectSub(String selectSub) {
            this.subConfig.selectSub = selectSub;
            return this;
        }

        public Builder setFixTimes(BigDecimal fixTimes) {
            this.subConfig.fixTimes = fixTimes;
            return this;
        }

        public Builder setDesTimes(BigDecimal desTimes) {
            this.subConfig.desTimes = desTimes;
            return this;
        }

        public Builder setOtSubTimeItemList(List<OtSubTimeItem> otSubTimeItemList) {
            this.subConfig.otSubTimeItemList = otSubTimeItemList;
            return this;
        }

        public Builder setOtDeductSubTimeItemList(List<OtDeductSubTimeItem> otDeductSubTimeItemList) {
            this.subConfig.otDeductSubTimeItemList = otDeductSubTimeItemList;
            return this;
        }
    }
}

