/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlotcal;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.common.model.common.Fixtimeentity;
import kd.wtc.wtes.business.executor.common.CalTimeCutHelper;
import kd.wtc.wtes.business.model.rlotcal.TimeCutConfig;

public class TimeCut
implements IEntity {
    private static final long serialVersionUID = -6804330637240676152L;
    private List<TimeCutConfig> timeCutConfigs;
    private long id;
    private String number;
    private Fixtimeentity fixtimeentity;
    private boolean iscutattitemPre = false;
    private boolean iscutattitemAfter = false;
    private Set<Long> cutattitems = new HashSet<Long>();

    public List<TimeCutConfig> getTimeCutConfigs() {
        return this.timeCutConfigs;
    }

    public Set<Long> getCutattitems() {
        return this.cutattitems;
    }

    public Fixtimeentity getFixtimeentity() {
        return this.fixtimeentity;
    }

    public boolean isIscutattitemPre() {
        return this.iscutattitemPre;
    }

    public boolean isIscutattitemAfter() {
        return this.iscutattitemAfter;
    }

    public long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public static Builder builder() {
        return new Builder(new TimeCut());
    }

    public String toString() {
        return "TimeCut{timeCutConfigs=" + this.timeCutConfigs + ", id=" + this.id + ", number='" + this.number + '\'' + ", fixtimeentity=" + this.fixtimeentity + ", iscutattitemPre=" + this.iscutattitemPre + ", iscutattitemAfter=" + this.iscutattitemAfter + ", cutattitems=" + this.cutattitems + '}';
    }

    public static class Builder {
        private TimeCut timeCut;

        public Builder(TimeCut timeCut) {
            this.timeCut = timeCut;
        }

        public TimeCut build() {
            LocalTime begintime = null;
            String stagdate = null;
            LocalTime endtime = null;
            String etagdate = null;
            if (this.timeCut != null && this.timeCut.timeCutConfigs != null) {
                for (TimeCutConfig config : this.timeCut.timeCutConfigs) {
                    this.timeCut.cutattitems.add(config.getCutattitem());
                    if (config.getPreDateConditionAccessDto() != null) {
                        this.timeCut.iscutattitemPre = this.timeCut.iscutattitemPre || config.isIscutattitem();
                    }
                    if (config.getAfterDateConditionAccessDto() != null) {
                        this.timeCut.iscutattitemAfter = this.timeCut.iscutattitemAfter || config.isIscutattitem();
                    }
                    for (Fixtimeentity fixtimeentity : config.getFixtimeentitys()) {
                        LocalDateTime currentDate;
                        LocalDateTime temp;
                        if (config.getPreDateConditionAccessDto() != null) {
                            temp = CalTimeCutHelper.getLocalDateTime(fixtimeentity.getStagdate(), fixtimeentity.getBegintime(), LocalDate.now());
                            currentDate = CalTimeCutHelper.getLocalDateTime(stagdate, begintime, LocalDate.now());
                            if (begintime == null || currentDate == null || temp.compareTo(currentDate) < 0) {
                                begintime = fixtimeentity.getBegintime();
                                stagdate = fixtimeentity.getStagdate();
                            }
                        }
                        if (config.getAfterDateConditionAccessDto() == null) continue;
                        temp = CalTimeCutHelper.getLocalDateTime(fixtimeentity.getEtagdate(), fixtimeentity.getEndtime(), LocalDate.now());
                        temp = CalTimeCutHelper.getLocalDateTime(fixtimeentity.getStagdate(), fixtimeentity.getBegintime(), LocalDate.now());
                        currentDate = CalTimeCutHelper.getLocalDateTime(etagdate, endtime, LocalDate.now());
                        if (endtime != null && currentDate != null && temp.compareTo(currentDate) <= 0) continue;
                        endtime = fixtimeentity.getEndtime();
                        etagdate = fixtimeentity.getEtagdate();
                    }
                }
                LocalDateTime startTime = CalTimeCutHelper.getLocalDateTime(stagdate, begintime, LocalDate.now());
                LocalDateTime endTime = CalTimeCutHelper.getLocalDateTime(etagdate, endtime, LocalDate.now());
                if (startTime != null && endTime != null && startTime.compareTo(endTime) > 0) {
                    this.timeCut.fixtimeentity = new Fixtimeentity(begintime, stagdate, begintime, stagdate);
                } else {
                    this.timeCut.fixtimeentity = new Fixtimeentity(begintime, stagdate, endtime, etagdate);
                }
            }
            TimeCut temp1 = this.timeCut;
            this.timeCut = null;
            return temp1;
        }

        public Builder setId(long id) {
            this.timeCut.id = id;
            return this;
        }

        public Builder setNumber(String number) {
            this.timeCut.number = number;
            return this;
        }

        public Builder setTimeCutConfigs(List<TimeCutConfig> timeCutConfigs) {
            this.timeCut.timeCutConfigs = timeCutConfigs;
            return this;
        }
    }
}

