/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.enums.overwork.OverworkAttendanceEnum;
import kd.wtc.wtes.business.model.rlra.AttItemLabelEntryPackage;
import kd.wtc.wtes.business.model.rlra.TimeBucketLabelEnum;

public class AttItemLabelConfigEntity
extends AbstractTimeSeqVersion
implements IEntity {
    private static final String SPLIT_LINE = "|";
    private static final String SPLIT_COMMA = ",";
    private static final String DEFAULT_RELATION = OverworkAttendanceEnum.OTHER.getNumber() + "|" + TimeBucketLabelEnum.OTHER.getNumber();
    private final String country;
    private final List<AttItemLabelEntryPackage> attItemLabelEntryPackageList;
    private final Map<String, List<String>> attItemLabelRelationMap;

    protected AttItemLabelConfigEntity(Builder<?, ?> builder) {
        super(builder);
        this.country = ((Builder)builder).country;
        this.attItemLabelEntryPackageList = ((Builder)builder).attItemLabelEntryPackageList;
        this.attItemLabelRelationMap = ((Builder)builder).attItemLabelRelationMap;
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(timeSeqInfo);
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(id, number);
    }

    public static Builder<?, ?> withNonTimeSeq() {
        return new BuilderImpl(0L, "");
    }

    public String getCountry() {
        return this.country;
    }

    public List<AttItemLabelEntryPackage> getAttItemLabelEntryPackageList() {
        return this.attItemLabelEntryPackageList;
    }

    public Map<String, List<String>> getAttItemLabelRelationMap() {
        return this.attItemLabelRelationMap;
    }

    public List<String> getRelationByParam(String attStatus, String shiftTimeBucketProperty, String dateType) {
        ArrayList<String> reList = new ArrayList<String>(10);
        StringBuilder key = new StringBuilder().append(attStatus).append(SPLIT_LINE).append(shiftTimeBucketProperty).append(SPLIT_LINE).append(dateType);
        if (null != this.attItemLabelRelationMap.get(key.toString())) {
            reList.addAll((Collection<String>)this.attItemLabelRelationMap.get(key.toString()));
        } else {
            reList.add(DEFAULT_RELATION);
        }
        return reList;
    }

    private static final class BuilderImpl
    extends Builder<AttItemLabelConfigEntity, BuilderImpl> {
        BuilderImpl(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        BuilderImpl(long id, String number) {
            super(id, number);
        }

        protected BuilderImpl self() {
            return this;
        }

        public AttItemLabelConfigEntity building() {
            return new AttItemLabelConfigEntity(this);
        }
    }

    public static abstract class Builder<E extends AttItemLabelConfigEntity, B extends Builder<E, B>>
    extends AbstractTimeSeqVersion.Builder<E, B> {
        private String country;
        private List<AttItemLabelEntryPackage> attItemLabelEntryPackageList;
        private Map<String, List<String>> attItemLabelRelationMap;

        protected Builder(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected Builder(long id, String number) {
            super(id, number);
        }

        protected Builder(E source) {
            super(source);
            this.country = ((AttItemLabelConfigEntity)((Object)source)).getCountry();
            this.attItemLabelEntryPackageList = ((AttItemLabelConfigEntity)((Object)source)).getAttItemLabelEntryPackageList();
            this.attItemLabelRelationMap = ((AttItemLabelConfigEntity)((Object)source)).getAttItemLabelRelationMap();
        }

        public B country(String country) {
            this.country = country;
            return (B)((Object)((Builder)this.self()));
        }

        public B attItemLabelRelationEntryPackageList(List<AttItemLabelEntryPackage> attItemLabelEntryPackageList) {
            this.attItemLabelEntryPackageList = attItemLabelEntryPackageList;
            this.attItemLabelRelationMap = this.transferListToMap(attItemLabelEntryPackageList);
            return (B)((Object)((Builder)this.self()));
        }

        private Map<String, List<String>> transferListToMap(List<AttItemLabelEntryPackage> list) {
            HashMap<String, List<String>> relationMap = new HashMap<String, List<String>>(16);
            if (null != list) {
                for (AttItemLabelEntryPackage entryPackage : list) {
                    this.transferToMap(entryPackage, relationMap);
                }
            }
            return relationMap;
        }

        private void transferToMap(AttItemLabelEntryPackage entryPackage, Map<String, List<String>> relationMap) {
            String shiftTimeBucketProperty = entryPackage.getShiftTimeBucketProperty();
            String dataType = entryPackage.getDateType();
            String[] timeArr = shiftTimeBucketProperty.split(AttItemLabelConfigEntity.SPLIT_COMMA);
            String[] dateTypeArr = dataType.split(AttItemLabelConfigEntity.SPLIT_COMMA);
            for (String tbProp : timeArr) {
                if ("".equals(tbProp)) continue;
                for (String dateTypeProp : dateTypeArr) {
                    if ("".equals(dateTypeProp)) continue;
                    String key = entryPackage.getAttStatus() + AttItemLabelConfigEntity.SPLIT_LINE + tbProp + AttItemLabelConfigEntity.SPLIT_LINE + dateTypeProp;
                    List<String> curList = relationMap.get(key);
                    if (null == curList) {
                        curList = new ArrayList<String>();
                    }
                    curList.add(entryPackage.getAttItem() + AttItemLabelConfigEntity.SPLIT_LINE + entryPackage.getPairLabel());
                    relationMap.put(key, curList);
                }
            }
        }

        protected void check() {
            super.check();
        }
    }
}

