/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.model.rlra.AttStatusEntryPackage;
import kd.wtc.wtes.business.model.rlra.AttStatusEnum;

public class AttStatusConfigEntity
extends AbstractTimeSeqVersion
implements IEntity {
    private static final String SPLIT_COMMA = ",";
    public static final String PUNCHCARDTAG_KEY_PRE = "PUNCHCARDTAG_";
    public static final String BILLTAG_KEY_PRE = "BILLTAG_";
    private final String country;
    private final List<AttStatusEntryPackage> attStatusEntryPackageList;
    private final Map<String, List<String>> attStatusRelationMap;

    protected AttStatusConfigEntity(Builder<?, ?> builder) {
        super(builder);
        this.country = ((Builder)builder).country;
        this.attStatusEntryPackageList = ((Builder)builder).attStatusEntryPackageList;
        this.attStatusRelationMap = ((Builder)builder).attStatusRelationMap;
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(timeSeqInfo);
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(id, number);
    }

    public static Builder<?, ?> withNonTimeSeq() {
        return new BuilderImpl(0L, "");
    }

    public String getCountry() {
        return this.country;
    }

    public List<AttStatusEntryPackage> getAttStatusEntryPackageList() {
        return this.attStatusEntryPackageList;
    }

    public Map<String, List<String>> getAttStatusRelationMap() {
        return this.attStatusRelationMap;
    }

    public List<String> getRelationByParam(String punchCardTag, List<String> attendanceBillTagList) {
        ArrayList<String> reList = new ArrayList<String>(10);
        List<String> checkPointList = this.attStatusRelationMap.get(PUNCHCARDTAG_KEY_PRE.concat(punchCardTag));
        ArrayList billList = new ArrayList();
        for (String billTag : attendanceBillTagList) {
            billList.addAll(this.attStatusRelationMap.get(BILLTAG_KEY_PRE.concat(billTag)));
        }
        if (null != checkPointList) {
            reList.addAll(checkPointList);
        }
        reList.addAll(billList);
        if (reList.isEmpty()) {
            reList.add(AttStatusEnum.OTHER.getCode());
        }
        return reList;
    }

    private static final class BuilderImpl
    extends Builder<AttStatusConfigEntity, BuilderImpl> {
        BuilderImpl(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        BuilderImpl(long id, String number) {
            super(id, number);
        }

        protected BuilderImpl self() {
            return this;
        }

        public AttStatusConfigEntity building() {
            return new AttStatusConfigEntity(this);
        }
    }

    public static abstract class Builder<E extends AttStatusConfigEntity, B extends Builder<E, B>>
    extends AbstractTimeSeqVersion.Builder<E, B> {
        private String country;
        private List<AttStatusEntryPackage> attStatusEntryPackageList;
        private Map<String, List<String>> attStatusRelationMap;

        protected Builder(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected Builder(long id, String number) {
            super(id, number);
        }

        protected Builder(E source) {
            super(source);
            this.country = ((AttStatusConfigEntity)((Object)source)).getCountry();
            this.attStatusEntryPackageList = ((AttStatusConfigEntity)((Object)source)).getAttStatusEntryPackageList();
            this.attStatusRelationMap = ((AttStatusConfigEntity)((Object)source)).getAttStatusRelationMap();
        }

        public B country(String country) {
            this.country = country;
            return (B)((Object)((Builder)this.self()));
        }

        public B attStatusRelationEntryPackageList(List<AttStatusEntryPackage> attStatusEntryPackageList) {
            this.attStatusEntryPackageList = attStatusEntryPackageList;
            this.attStatusRelationMap = this.transferListToMap(attStatusEntryPackageList);
            return (B)((Object)((Builder)this.self()));
        }

        private Map<String, List<String>> transferListToMap(List<AttStatusEntryPackage> list) {
            HashMap<String, List<String>> relationMap = new HashMap<String, List<String>>(16);
            if (null != list) {
                for (AttStatusEntryPackage entryPackage : list) {
                    this.transferBillTagIntoMap(entryPackage, relationMap);
                }
            }
            return relationMap;
        }

        private void transferBillTagIntoMap(AttStatusEntryPackage entryPackage, Map<String, List<String>> relationMap) {
            List<String> curList;
            String key;
            String billTag = entryPackage.getAttendanceBillTag();
            String punchCardTag = entryPackage.getPunchCardTag();
            String[] pointArr = punchCardTag.split(AttStatusConfigEntity.SPLIT_COMMA);
            String[] billArr = billTag.split(AttStatusConfigEntity.SPLIT_COMMA);
            for (String str : pointArr) {
                if ("".equals(str)) continue;
                key = AttStatusConfigEntity.PUNCHCARDTAG_KEY_PRE.concat(str);
                curList = relationMap.get(key);
                if (null == curList) {
                    curList = new ArrayList<String>();
                }
                curList.add(entryPackage.getAttStatus());
                relationMap.put(key, curList);
            }
            for (String str : billArr) {
                if ("".equals(str)) continue;
                key = AttStatusConfigEntity.BILLTAG_KEY_PRE.concat(str);
                curList = relationMap.get(key);
                if (null == curList) {
                    curList = new ArrayList<String>();
                }
                curList.add(entryPackage.getAttStatus());
                relationMap.put(key, curList);
            }
        }

        protected void check() {
            super.check();
        }
    }
}

