/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEnum;
import kd.wtc.wtes.business.model.rlra.TimeCardRelationEntryPackage;

public class PunchCardTagEntity
extends AbstractTimeSeqVersion
implements IEntity {
    private static final String SPLIT_LINE = "|";
    private static final String SPLIT_COMMA = ",";
    private final String country;
    private final List<TimeCardRelationEntryPackage> timeCardRelationEntryPackageList;
    private final Map<String, String> timeCardRelationMap;

    protected PunchCardTagEntity(Builder<?, ?> builder) {
        super(builder);
        this.country = ((Builder)builder).country;
        this.timeCardRelationEntryPackageList = ((Builder)builder).timeCardRelationEntryPackageList;
        this.timeCardRelationMap = ((Builder)builder).timeCardRelationMap;
    }

    public static Builder<?, ?> withTimeSeq(TimeSeqInfo timeSeqInfo) {
        return new BuilderImpl(timeSeqInfo);
    }

    public static Builder<?, ?> withNonTimeSeq(long id, String number) {
        return new BuilderImpl(id, number);
    }

    public static Builder<?, ?> withNonTimeSeq() {
        return new BuilderImpl(0L, "");
    }

    public String getCountry() {
        return this.country;
    }

    public List<TimeCardRelationEntryPackage> getTimeCardRelationEntryPackageList() {
        return this.timeCardRelationEntryPackageList;
    }

    public Map<String, String> getTimeCardRelationMap() {
        return this.timeCardRelationMap;
    }

    public String getRelationByParam(String timeCardRelation, String shiftTimeBucketProperty, String exceptionType) {
        String result = this.timeCardRelationMap.get(timeCardRelation.concat(SPLIT_LINE).concat(exceptionType).concat(SPLIT_LINE).concat(shiftTimeBucketProperty));
        if (null == result) {
            result = PunchCardTagEnum.OTHER.code;
        }
        return result;
    }

    private static final class BuilderImpl
    extends Builder<PunchCardTagEntity, BuilderImpl> {
        BuilderImpl(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        BuilderImpl(long id, String number) {
            super(id, number);
        }

        protected BuilderImpl self() {
            return this;
        }

        public PunchCardTagEntity building() {
            return new PunchCardTagEntity(this);
        }
    }

    public static abstract class Builder<E extends PunchCardTagEntity, B extends Builder<E, B>>
    extends AbstractTimeSeqVersion.Builder<E, B> {
        private String country;
        private List<TimeCardRelationEntryPackage> timeCardRelationEntryPackageList;
        private Map<String, String> timeCardRelationMap;

        protected Builder(TimeSeqInfo timeSeqInfo) {
            super(timeSeqInfo);
        }

        protected Builder(long id, String number) {
            super(id, number);
        }

        protected Builder(E source) {
            super(source);
            this.country = ((PunchCardTagEntity)((Object)source)).getCountry();
            this.timeCardRelationEntryPackageList = ((PunchCardTagEntity)((Object)source)).getTimeCardRelationEntryPackageList();
            this.timeCardRelationMap = ((PunchCardTagEntity)((Object)source)).getTimeCardRelationMap();
        }

        public B country(String country) {
            this.country = country;
            return (B)((Object)((Builder)this.self()));
        }

        public B timeCardRelationEntryPackageList(List<TimeCardRelationEntryPackage> timeCardRelationEntryPackageList) {
            this.timeCardRelationEntryPackageList = timeCardRelationEntryPackageList;
            this.timeCardRelationMap = this.transferListToMap(timeCardRelationEntryPackageList);
            return (B)((Object)((Builder)this.self()));
        }

        private Map<String, String> transferListToMap(List<TimeCardRelationEntryPackage> list) {
            HashMap<String, String> relationMap = new HashMap<String, String>(16);
            if (null != list) {
                for (TimeCardRelationEntryPackage entryPackage : list) {
                    this.transferToMap(entryPackage, relationMap);
                }
            }
            return relationMap;
        }

        private void transferToMap(TimeCardRelationEntryPackage entryPackage, Map<String, String> relationMap) {
            String shiftTimeBucketProperty = entryPackage.getShiftTimeBucketProperty();
            if (shiftTimeBucketProperty.contains(PunchCardTagEntity.SPLIT_COMMA)) {
                String[] tempArr;
                for (String str : tempArr = shiftTimeBucketProperty.split(PunchCardTagEntity.SPLIT_COMMA)) {
                    if ("".equals(str)) continue;
                    relationMap.put(entryPackage.getTimeCardRelation() + PunchCardTagEntity.SPLIT_LINE + entryPackage.getPunchCardExceptionType() + PunchCardTagEntity.SPLIT_LINE + str, entryPackage.getPunchCardTag());
                }
            } else {
                relationMap.put(entryPackage.getTimeCardRelation() + PunchCardTagEntity.SPLIT_LINE + entryPackage.getPunchCardExceptionType() + PunchCardTagEntity.SPLIT_LINE + shiftTimeBucketProperty, entryPackage.getPunchCardTag());
            }
        }

        protected void check() {
            super.check();
        }
    }
}

