/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.List;
import kd.wtc.wtes.business.model.base.PunchCardPair;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;

public class ShouldPunchCardSeqCounter {
    int onDutyStatus;
    private int index;
    private List<PunchCardPair> punchCardPairs;

    public ShouldPunchCardSeqCounter(TieContextStd context) {
        this.init(context);
    }

    private void init(TieContextStd context) {
        this.index = -1;
        this.onDutyStatus = 0;
        this.punchCardPairs = ContextUtil.getPunchCardPairs(context);
    }

    public void switchShouldPunchCardSeqIndex(AbstractCardPoint cardPoint) {
        int statusNew = this.onDutyStatus;
        switch (cardPoint.getPointType()) {
            case 2: 
            case 3: 
            case 19: 
            case 21: 
            case 22: 
            case 25: {
                statusNew = 1;
                if (this.onDutyStatus == 0) {
                    this.index = 0;
                    break;
                }
                ++this.index;
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                statusNew = 2;
                break;
            }
            case 14: {
                if (this.onDutyStatus != 2) break;
                statusNew = 3;
                break;
            }
            case 15: {
                statusNew = 1;
                break;
            }
            case 43: {
                statusNew = 1;
                break;
            }
            case 44: {
                statusNew = 1;
                break;
            }
            case 17: {
                statusNew = 1;
                break;
            }
            case 18: {
                statusNew = 1;
                break;
            }
        }
        this.onDutyStatus = statusNew;
    }

    public long getShouldPunchCardSeqId(TimeBucketPositionEnum timeBucketPosition) {
        long ShouldPunchCardSeqId = 0L;
        if ((timeBucketPosition == TimeBucketPositionEnum.IN_SHIFT || timeBucketPosition == TimeBucketPositionEnum.IN_REST) && this.onDutyStatus == 1) {
            ShouldPunchCardSeqId = this.punchCardPairs.get(this.index).getId();
        }
        return ShouldPunchCardSeqId;
    }
}

