/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.rlra;

import java.util.List;
import kd.wtc.wtbs.common.predata.wtbd.PreDataPunchCardPair;
import kd.wtc.wtes.business.model.base.ShiftPeriod;
import kd.wtc.wtes.business.model.base.ShiftTypeEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.TimeSeqEnum;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.pairtime.AbstractCardPoint;

public class TimeSeqCounter {
    private static final TimeSeqEnum NON_TIME_SEQ = TimeSeqEnum.UNKNOWN;
    public static final Long NON_TIME_SEQ_ID = PreDataPunchCardPair.PD_NON_TIME_SEQ_ID;
    private List<ShiftPeriod> attList;
    private List<ShiftPeriod> coreList;
    private List<ShiftPeriod> restList;
    private List<ShiftPeriod> otList;
    private List<ShiftPeriod> nonPlanTimeList;
    private int attSeq = -1;
    private int coreAttSeq = -1;
    private int restSeq = -1;
    private int otSeq = -1;

    public TimeSeqCounter(TieContextStd context) {
        this.attList = ContextUtil.getShiftPeriodByType(context, ShiftTypeEnum.WORK);
        this.coreList = ContextUtil.getShiftPeriodByType(context, ShiftTypeEnum.CORE_WORK);
        this.restList = ContextUtil.getShiftPeriodByType(context, ShiftTypeEnum.REST);
        this.otList = ContextUtil.getShiftPeriodByType(context, ShiftTypeEnum.OVER_WORK);
        this.nonPlanTimeList = ContextUtil.getShiftPeriodByType(context, ShiftTypeEnum.NO_OFF_PLAN);
    }

    public void attSeqAdd() {
        ++this.attSeq;
    }

    public void coreAttSeqAdd() {
        ++this.coreAttSeq;
    }

    public void restSeqAdd() {
        ++this.restSeq;
    }

    public void otSeqAdd() {
        ++this.otSeq;
    }

    public void switchTimeSeqIndex(AbstractCardPoint cardPoint) {
        switch (cardPoint.getPointType()) {
            case 49: {
                this.attSeqAdd();
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 14: {
                this.restSeqAdd();
                break;
            }
            case 43: {
                this.otSeqAdd();
                break;
            }
            case 17: {
                this.coreAttSeqAdd();
                break;
            }
        }
    }

    public Long getTimeSeqId(ShiftTimeBucketPropertyEnum shiftTimeBucketProperty) {
        Long seqId = NON_TIME_SEQ_ID;
        switch (shiftTimeBucketProperty) {
            case NON_PLAN_TIME: {
                seqId = this.nonPlanTimeList.get(0).getId();
                break;
            }
            case BEFORE_SHIFT: 
            case AFTER_SHIFT: {
                seqId = NON_TIME_SEQ_ID;
                break;
            }
            case ATTENDANCE: {
                seqId = this.attList.get(this.attSeq).getId();
                break;
            }
            case CORE_ATT: {
                seqId = this.coreList.get(this.coreAttSeq).getId();
                break;
            }
            case ATT_OT: {
                seqId = this.otList.get(this.otSeq).getId();
                break;
            }
            case REST: {
                seqId = this.restList.get(this.restSeq).getId();
                break;
            }
            case UNKNOWN: 
            case TEMP: {
                break;
            }
            default: {
                seqId = NON_TIME_SEQ_ID;
            }
        }
        return seqId;
    }
}

