/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.ruleengine;

import kd.bos.config.client.util.StringUtils;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;

public enum EnginePlanEnum {
    vp("vp", "wtc_scene_vacation", new MultiLangEnumBridge("\u4f11\u5047\u65b9\u6848", "EnginePlanEnum_0", "wtc-wtes-business")),
    tp("tp", "wtc_scene_tp", new MultiLangEnumBridge("{0}\u65b9\u6848", "EnginePlanEnum_1", "wtc-wtes-business", new Object[]{BillTypeEnum.EVECTIONBILL})),
    otp("otp", "wtc_scene_otp", new MultiLangEnumBridge("\u52a0\u73ed\u65b9\u6848", "EnginePlanEnum_2", "wtc-wtes-business")),
    exs("exs", "wtc_scene_exception", new MultiLangEnumBridge("\u5f02\u5e38\u65b9\u6848", "EnginePlanEnum_3", "wtc-wtes-business")),
    idp("idp", "wtc_scene_idp", new MultiLangEnumBridge("\u589e\u51cf\u65b9\u6848", "EnginePlanEnum_4", "wtc-wtes-business")),
    mhs("mhs", "wtc_scene_mhs", new MultiLangEnumBridge("\u5de5\u65f6\u89e3\u6790\u65b9\u6848", "EnginePlanEnum_5", "wtc-wtes-business")),
    cp("cp", "wtc_scene_cp", new MultiLangEnumBridge("\u5408\u89c4\u6027\u65b9\u6848", "EnginePlanEnum_6", "wtc-wtes-business")),
    cul("cul", "wtc_scene_cul", new MultiLangEnumBridge("\u7d2f\u8ba1\u65b9\u6848", "EnginePlanEnum_7", "wtc-wtes-business"));

    private final String planFlag;
    private final String sceneNumber;
    private MultiLangEnumBridge planName;

    private EnginePlanEnum(String planFlag, String sceneNumber, MultiLangEnumBridge planName) {
        this.planFlag = planFlag;
        this.sceneNumber = sceneNumber;
        this.planName = planName;
    }

    public static String getSceneNumberByPlanFlag(String planFlag) {
        EnginePlanEnum planEnum = EnginePlanEnum.getPlanEnum(planFlag);
        if (planEnum == null) {
            return StringUtils.getEmpty();
        }
        return planEnum.sceneNumber;
    }

    public static EnginePlanEnum getPlanEnum(String key) {
        EnginePlanEnum[] planEnumArr;
        for (EnginePlanEnum planEnum : planEnumArr = EnginePlanEnum.values()) {
            if (!planEnum.getPlanFlag().equals(key)) continue;
            return planEnum;
        }
        return null;
    }

    public static String getPlanFlagByFormId(String formId) {
        switch (formId) {
            case "wtp_vacationplan": {
                return "vp";
            }
            case "wtp_culplan": {
                return "cul";
            }
            case "wtp_exscheme": {
                return "exs";
            }
            case "wtp_taplan": {
                return "tp";
            }
            case "wtp_otplan": {
                return "otp";
            }
            case "wtp_incdecplan": {
                return "idp";
            }
        }
        return "";
    }

    public String getPlanFlag() {
        return this.planFlag;
    }

    public String getSceneNumber() {
        return this.sceneNumber;
    }

    public String getPlanName() {
        return this.planName.loadKDString();
    }
}

