/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.util;

import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.ruleengine.RuleEngineQueryServiceImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtes.business.model.rlid.IncrDecrConf;
import kd.wtc.wtes.business.model.rlid.IncrDecrConfEntry;
import kd.wtc.wtes.business.model.rlid.IncrDecrPlan;
import kd.wtc.wtes.business.model.rlid.IncrDecrRule;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.Strings;

public final class IncrDecrEntityUtils {
    public static Map<Long, TimeSeqBo<IncrDecrPlan>> getIncrDecrPlanTimeSeqBo(Set<Long> planIds, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqBo<IncrDecrPlan>> result = new HashMap<Long, TimeSeqBo<IncrDecrPlan>>(planIds.size());
        HRBaseServiceHelper planHisServiceHelper = new HRBaseServiceHelper("wtp_incdecplan");
        DynamicObject[] hisPlanArray = planHisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(planIds, startDate, endDate));
        HashMap<Long, List> hisPlanCluster = new HashMap<Long, List>(planIds.size());
        HashSet<Long> ruleIds = new HashSet<Long>();
        ArrayList<Long> planVersionIds = new ArrayList<Long>(hisPlanArray.length);
        for (DynamicObject hisPlan2 : hisPlanArray) {
            long fid = hisPlan2.getLong("boid");
            planVersionIds.add(hisPlan2.getLong("id"));
            List list = hisPlanCluster.getOrDefault(fid, new LinkedList());
            list.add(hisPlan2);
            hisPlanCluster.put(fid, list);
            IncrDecrEntityUtils.collectRuleIds(hisPlan2, ruleIds);
        }
        Map ruleSetMap = RuleEngineQueryServiceImpl.getInstance().queryRuleEngineAssociation(planVersionIds);
        Map<Long, TimeSeqAvailableBo<IncrDecrRule>> ruleBoMap = IncrDecrEntityUtils.getIncrDecrRuleTimeSeqBo(ruleIds, startDate, endDate);
        for (Map.Entry entry : hisPlanCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(hisPlan -> IncrDecrEntityUtils.generateIncrDecrPlan(hisPlan, ruleBoMap, ruleSetMap)).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqBo<IncrDecrPlan>)TimeSeqBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    private static void collectRuleIds(DynamicObject plan, Set<Long> ruleIds) {
        DynamicObject RuleDy = plan.getDynamicObject("incdecrulef7");
        if (null != RuleDy) {
            ruleIds.add((Long)RuleDy.getPkValue());
        }
    }

    private static IncrDecrPlan generateIncrDecrPlan(DynamicObject plan, Map<Long, TimeSeqAvailableBo<IncrDecrRule>> ruleBoMap, Map<Long, String> ruleSetMap) {
        long id = plan.getLong("id");
        String number = plan.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(plan);
        IncrDecrPlan.Builder builder = IncrDecrPlan.withTimeSeq(id, number, timeSeqEntity);
        String ruleWay = ruleSetMap.get(id);
        builder.setSetRuleWay(ruleWay);
        DynamicObject RuleDy = plan.getDynamicObject("incdecrulef7");
        if (null != RuleDy && !HRStringUtils.equalsIgnoreCase((String)"2", (String)ruleWay)) {
            long ruleId = (Long)RuleDy.getPkValue();
            TimeSeqAvailableBo<IncrDecrRule> incrDecrRuleBo = ruleBoMap.get(ruleId);
            builder.addIncrDecrRuleBo((TimeSeqBo<IncrDecrRule>)incrDecrRuleBo);
        }
        return builder.build();
    }

    public static Map<Long, TimeSeqAvailableBo<IncrDecrRule>> getIncrDecrRuleTimeSeqBo(Set<Long> ruleIds, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqAvailableBo<IncrDecrRule>> result = new HashMap<Long, TimeSeqAvailableBo<IncrDecrRule>>(ruleIds.size());
        HRBaseServiceHelper rulesHisServiceHelper = new HRBaseServiceHelper("wtp_incdecrules");
        DynamicObject[] hisRuleArray = rulesHisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(ruleIds, startDate, endDate));
        HashSet<Long> confIds = new HashSet<Long>();
        HashMap<Long, List> hisRuleCluster = new HashMap<Long, List>(ruleIds.size());
        for (DynamicObject hisRule2 : hisRuleArray) {
            long fid = hisRule2.getLong("boid");
            List list = hisRuleCluster.getOrDefault(fid, new LinkedList());
            list.add(hisRule2);
            hisRuleCluster.put(fid, list);
            IncrDecrEntityUtils.collectConfIds(hisRule2, confIds);
        }
        Map<Long, TimeSeqBo<IncrDecrConf>> confBoMap = IncrDecrEntityUtils.getIncrDecrConfTimeSeqBo(confIds, startDate, endDate);
        for (Map.Entry entry : hisRuleCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(hisRule -> IncrDecrEntityUtils.generateIncrDecrRule(hisRule, confBoMap)).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqAvailableBo<IncrDecrRule>)TimeSeqAvailableBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    private static void collectConfIds(DynamicObject rule, Set<Long> confIds) {
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("wtp_rulessettingentity");
        for (DynamicObject entry : entries) {
            confIds.add((Long)entry.getDynamicObject("incdecconfig").getPkValue());
        }
    }

    private static IncrDecrRule generateIncrDecrRule(DynamicObject rule, Map<Long, TimeSeqBo<IncrDecrConf>> confBoMap) {
        long id = rule.getLong("id");
        String number = rule.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(rule);
        IncrDecrRule.Builder builder = IncrDecrRule.withTimeSeq(id, number, timeSeqEntity);
        DynamicObjectCollection entries = rule.getDynamicObjectCollection("wtp_rulessettingentity");
        for (DynamicObject row : entries) {
            Long confId = (Long)row.getDynamicObject("incdecconfig").getPkValue();
            TimeSeqBo<IncrDecrConf> incrDecrConfBo = confBoMap.get(confId);
            builder.addTuple(incrDecrConfBo);
        }
        return builder.build();
    }

    private static Map<Long, TimeSeqBo<IncrDecrConf>> getIncrDecrConfTimeSeqBo(Set<Long> confIds, LocalDate startDate, LocalDate endDate) {
        HashMap<Long, TimeSeqBo<IncrDecrConf>> result = new HashMap<Long, TimeSeqBo<IncrDecrConf>>(confIds.size());
        HRBaseServiceHelper confHisServiceHelper = new HRBaseServiceHelper("wtp_incdecconf");
        DynamicObject[] hisConfArray = confHisServiceHelper.loadDynamicObjectArray(TimeSeqEntityGenerateUtils.getQueryCondition(confIds, startDate, endDate));
        HashMap<Long, List> hisConfCluster = new HashMap<Long, List>(confIds.size());
        for (DynamicObject hisConf : hisConfArray) {
            long fid = hisConf.getLong("boid");
            List list = hisConfCluster.getOrDefault(fid, new LinkedList());
            list.add(hisConf);
            hisConfCluster.put(fid, list);
        }
        for (Map.Entry entry : hisConfCluster.entrySet()) {
            List hisSeqList = ((List)entry.getValue()).stream().map(IncrDecrEntityUtils::generateIncrDecrConf).collect(Collectors.toList());
            result.put((Long)entry.getKey(), (TimeSeqBo<IncrDecrConf>)TimeSeqBo.ofMultiTimeSeq(hisSeqList));
        }
        return result;
    }

    private static IncrDecrConf generateIncrDecrConf(DynamicObject conf) {
        long id = conf.getLong("id");
        String number = conf.getString("number");
        TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(conf);
        IncrDecrConf.Builder builder = IncrDecrConf.withTimeSeq(id, number, timeSeqEntity);
        builder.suitType(conf.getString("suittype"));
        builder.condition(conf.getString("conditionjson"));
        String triggerMode = conf.getString("triggertype");
        builder.triggerMode(triggerMode);
        DynamicObjectCollection entryDys = conf.getDynamicObjectCollection("entryentity");
        ArrayList<IncrDecrConfEntry> entryList = new ArrayList<IncrDecrConfEntry>(entryDys.size());
        for (DynamicObject entryDy : entryDys) {
            IncrDecrConfEntry entry = new IncrDecrConfEntry();
            entry.setSerialLimit(entryDy.getString("seriallimit"));
            entry.setSerialPeriod(entryDy.getString("serialperiod"));
            entry.setCurAttItemId(null != entryDy.getDynamicObject("curattitem") ? (Long)entryDy.getDynamicObject("curattitem").getPkValue() : 0L);
            entry.setbAttItemId(null != entryDy.getDynamicObject("battitem") ? (Long)entryDy.getDynamicObject("battitem").getPkValue() : 0L);
            entry.setIndecrRel(entryDy.getString("indecrrel"));
            entry.setIndecrValue(entryDy.getBigDecimal("indecrvalue"));
            entry.setDayType(entryDy.getString("daytype"));
            entry.setShiftType(entryDy.getString("shifttype"));
            entry.setRegularTime(entryDy.getLong("regulartime"));
            entry.setLogicType(entryDy.getString("logictype"));
            entry.setLogicStr(entryDy.getString("logicstr"));
            entry.setRelateExpress(IncrDecrEntityUtils.parseToCulCondition(entryDy.getString("logicstr")));
            entry.setTriggerItem(entryDy.getBoolean("istriggeritem"));
            entry.setTriggerComp(entryDy.getString("triggercomp"));
            entry.setTriggerVal(entryDy.getBigDecimal("triggerval"));
            entry.setTriggerItemId(entryDy.getLong("triggeritem.id"));
            entry.setTriggerSign(entryDy.getString("triggersign"));
            entry.setTriggerResult(entryDy.getBigDecimal("triggerresult"));
            DynamicObjectCollection limitDys = entryDy.getDynamicObjectCollection("condsubentryentity");
            ArrayList<IncrDecrConfEntry.LimitEntry> limitList = new ArrayList<IncrDecrConfEntry.LimitEntry>(limitDys.size());
            for (DynamicObject limitDy : limitDys) {
                IncrDecrConfEntry.LimitEntry limitEntry = new IncrDecrConfEntry.LimitEntry();
                List<Long> attItems = limitDy.getDynamicObjectCollection("condattitem").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                limitEntry.setAttItems(attItems);
                limitEntry.setCondRel(limitDy.getString("condrel"));
                limitEntry.setCondValue(limitDy.getBigDecimal("condvalue"));
                limitEntry.setLimitNo(limitDy.getString("limitno"));
                StringBuilder sbr = new StringBuilder();
                if (Strings.isNotEmpty((String)limitDy.getString("condrel"))) {
                    sbr.append('(');
                }
                if (Strings.isNotEmpty((String)limitDy.getString("condrel"))) {
                    sbr.append(' ').append("attValue");
                    sbr.append(' ').append(limitDy.getString("condrel"));
                    sbr.append(' ').append(limitDy.getBigDecimal("condvalue").setScale(10, RoundingMode.HALF_UP));
                }
                if (Strings.isNotEmpty((String)limitDy.getString("condrel"))) {
                    sbr.append(" )");
                }
                limitEntry.setParser(sbr.toString());
                limitList.add(limitEntry);
            }
            entry.setLimitEntry(limitList);
            DynamicObjectCollection resultDys = entryDy.getDynamicObjectCollection("resultsubentryentity");
            ArrayList<IncrDecrConfEntry.ResultEntry> resultList = new ArrayList<IncrDecrConfEntry.ResultEntry>(resultDys.size());
            for (DynamicObject resultDy : resultDys) {
                IncrDecrConfEntry.ResultEntry resultEntry = new IncrDecrConfEntry.ResultEntry();
                resultEntry.setResultItemId(resultDy.getLong("resultitem.id"));
                resultEntry.setResultValue(resultDy.getBigDecimal("resultvalue"));
                resultEntry.setResultRel(resultDy.getString("resultrel"));
                resultList.add(resultEntry);
            }
            entry.setResultEntry(resultList);
            entryList.add(entry);
        }
        builder.entry(entryList);
        return builder.build();
    }

    private static String parseToCulCondition(String condition) {
        return condition.replace("\uff08", "\\(").replace('\uff09', ')').replaceAll(ResManager.loadKDString((String)"\u6216\u8005", (String)"IncrDecrEntityUtils_0", (String)"wtc-wtes-business", (Object[])new Object[0]), "or").replaceAll(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"IncrDecrEntityUtils_1", (String)"wtc-wtes-business", (Object[])new Object[0]), "and");
    }

    public static int getBaseSecond(String weekDay) {
        switch (weekDay) {
            case "1": {
                return 0;
            }
            case "2": {
                return 86400;
            }
            case "3": {
                return 172800;
            }
            case "4": {
                return 259200;
            }
            case "5": {
                return 345600;
            }
            case "6": {
                return 432000;
            }
            case "7": {
                return 518400;
            }
        }
        return -1;
    }

    private IncrDecrEntityUtils() {
    }
}

