/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.model.util;

import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class ParserUtil {
    private static Map<String, Integer> operatorMap = null;

    private ArrayList<String> getTokens(String pattern) {
        String[] splitArr = pattern.split(" ");
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)splitArr.length);
        for (String split : splitArr) {
            String trim = split.trim();
            if (trim == null || trim.length() == 0) continue;
            tokens.add(trim);
        }
        return tokens;
    }

    public boolean calculate(String pattern, String log) throws Exception {
        Stack<String> stack = new Stack<String>();
        ArrayList<String> tokens = this.generateReversePolish(this.getTokens(pattern));
        for (String token : tokens) {
            if (!operatorMap.containsKey(token.toLowerCase())) {
                stack.push(token);
                continue;
            }
            String right = this.getValueFromContext((String)stack.pop(), log);
            String left = this.getValueFromContext((String)stack.pop(), log);
            if (left != null && right != null) {
                stack.push(String.valueOf(this.operate(left, right, token)));
                continue;
            }
            throw new Exception("explan existed null");
        }
        return stack.size() == 1 && ((String)stack.pop()).equalsIgnoreCase("true");
    }

    private String getValueFromContext(String variable, String log) {
        if (!variable.contains("$")) {
            return variable;
        }
        if (variable.equalsIgnoreCase("$")) {
            return log;
        }
        if (variable.contains("$.")) {
            return String.valueOf(JSONPath.read((String)log, (String)variable));
        }
        return null;
    }

    private ArrayList<String> generateReversePolish(ArrayList<String> tokens) throws Exception {
        Stack<String> operatorStack = new Stack<String>();
        Stack<String> numberStack = new Stack<String>();
        for (String token : tokens) {
            if (!operatorMap.containsKey(token.toLowerCase())) {
                numberStack.push(token);
                continue;
            }
            if (operatorStack.empty()) {
                operatorStack.push(token);
                continue;
            }
            if (")".equals(token)) {
                String popToken = null;
                try {
                    while (!"(".equals(popToken = (String)operatorStack.pop())) {
                        numberStack.push(popToken);
                    }
                    continue;
                }
                catch (EmptyStackException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", "invalid expression:  '"), new Object[0]);
                }
            }
            String preOperator = (String)operatorStack.peek();
            if ("(".equals(preOperator)) {
                operatorStack.push(token);
                continue;
            }
            if (operatorMap.get(token) <= operatorMap.get(preOperator)) {
                operatorStack.push(token);
                continue;
            }
            numberStack.push((String)operatorStack.pop());
            operatorStack.push(token);
        }
        while (!operatorStack.empty()) {
            numberStack.push((String)operatorStack.pop());
        }
        ArrayList<String> resArrayList = new ArrayList<String>();
        String[] array = numberStack.toArray(new String[0]);
        for (int i = 0; i < array.length; ++i) {
            resArrayList.add(array[i]);
        }
        return resArrayList;
    }

    private boolean operate(String left, String right, String op) {
        Op operator = Op.getByOperator(op);
        if (operator == null) {
            return false;
        }
        Double leftNum = null;
        Double rightNum = null;
        switch (operator) {
            case GT: {
                leftNum = Double.valueOf(left);
                rightNum = Double.valueOf(right);
                return leftNum > rightNum;
            }
            case GE: {
                leftNum = Double.valueOf(left);
                rightNum = Double.valueOf(right);
                return leftNum >= rightNum;
            }
            case LT: {
                leftNum = Double.valueOf(left);
                rightNum = Double.valueOf(right);
                return leftNum < rightNum;
            }
            case LE: {
                leftNum = Double.valueOf(left);
                rightNum = Double.valueOf(right);
                return leftNum <= rightNum;
            }
            case EQ: {
                return left.equals(right);
            }
            case AND: {
                return "true".equals(left) && "true".equals(right);
            }
            case OR: {
                return "true".equals(left) || "true".equals(right);
            }
            case CONTAINS: {
                if (left == null || right == null) {
                    return false;
                }
                return left.contains(right);
            }
            case CONTAINS_NOT: {
                if (left == null || right == null) {
                    return false;
                }
                return !left.contains(right);
            }
        }
        return false;
    }

    static {
        operatorMap = new HashMap<String, Integer>();
        operatorMap.put("(", 1);
        operatorMap.put(")", 1);
        operatorMap.put("and", 11);
        operatorMap.put("or", 12);
        operatorMap.put("==", 7);
        operatorMap.put("!=", 7);
        operatorMap.put(">", 6);
        operatorMap.put(">=", 6);
        operatorMap.put("<", 6);
        operatorMap.put("<=", 6);
        operatorMap.put("contains", 14);
        operatorMap.put("containsnot", 14);
    }

    static enum Op {
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        EQ("=="),
        AND("and"),
        OR("or"),
        CONTAINS("contains"),
        CONTAINS_NOT("containsnot");

        private String operator;

        private Op(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }

        public static Op getByOperator(String operator) {
            if (operator == null || operator.length() == 0) {
                return null;
            }
            for (Op op : Op.values()) {
                if (!op.getOperator().equalsIgnoreCase(operator)) continue;
                return op;
            }
            return null;
        }
    }
}

