/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.chain.QuotaExecutionException;
import kd.wtc.wtes.business.quota.chain.QuotaExecutor;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.service.QuotaAlarm;
import kd.wtc.wtes.business.quota.service.QuotaMessage;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.common.util.Assert;

public abstract class AbstractQuotaExecutor<T extends IQuotaDataNode<T>>
implements QuotaExecutor<T>,
QuotaAlarm {
    private TieStatus resultStatus = TieStatus.UNKNOWN;
    private final List<T> resultDataNodes = new LinkedList<T>();
    private static final int VARIABLE_SIZE = 8;
    private final Map<String, Object> executorVariable = new HashMap<String, Object>(8);
    protected static final String EXECUTOR_TAG_DELIMITER = WTCAppContextHelper.getProjectParams().getString("quota.executor.tag.delimiter", ":");
    protected final List<QuotaMessage> tieMessages = new LinkedList<QuotaMessage>();
    private CalReportParaHolder reportPara;

    @Override
    public final void execute() {
        try {
            this.beforeExecute();
            this.init();
            this.doExecute();
            this.afterExecute();
            this.confirmResult();
        }
        catch (QuotaExecutionException e) {
            this.setResultStatus(TieStatus.EXCLUSION);
            this.tieMessages.add(new QuotaMessageStd(QuotaMsgLevel.WARNING, e.getMessage()));
        }
        finally {
            this.tieMessages.forEach(this::alarm);
        }
    }

    protected void beforeExecute() throws QuotaExecutionException {
    }

    protected void init() throws QuotaExecutionException {
    }

    protected abstract void doExecute() throws QuotaExecutionException;

    protected void afterExecute() throws QuotaExecutionException {
    }

    private void confirmResult() {
        if (this.resultStatus == TieStatus.UNKNOWN) {
            this.resultStatus = this.resultDataNodes.isEmpty() ? TieStatus.EXCLUSION : TieStatus.SUCCESS;
        }
    }

    @Override
    public TieStatus getResultStatus() {
        return this.resultStatus;
    }

    @Override
    public List<T> getResultDataNodes() {
        return this.resultDataNodes;
    }

    @Override
    public Map<String, Object> getExecutorVariable() {
        return this.executorVariable;
    }

    protected void setResultStatus(TieStatus resultStatus) {
        Assert.nonNull((Object)((Object)resultStatus), (String)"resultStatus");
        this.resultStatus = resultStatus;
    }

    protected void addResultDataNodes(List<T> dataNodes) {
        this.resultDataNodes.addAll(dataNodes);
    }

    @Override
    public List<QuotaMessage> getQuotaMessages() {
        return this.tieMessages;
    }

    @Override
    public CalReportParaHolder getReportPara() {
        return this.reportPara;
    }

    public void setReportPara(CalReportParaHolder reportPara) {
        this.reportPara = reportPara;
    }
}

