/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TieStatusDecision;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseIdentity;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.chain.AbstractQuotaExecutorsExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaChainExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaExecutionException;
import kd.wtc.wtes.business.quota.chain.QuotaExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaPhaseExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutor;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtes.business.quota.std.QuotaStepExecutorStd;
import kd.wtc.wtes.common.util.Assert;

public class QuotaPhaseExecutorDefault<T extends IQuotaDataNode<T>>
extends AbstractQuotaExecutorsExecutor<T>
implements QuotaPhaseExecutor<T> {
    private TiePhaseConfig phaseConfig;
    private QuotaChainExecutor<T> chainExecutor;
    private TiePhaseIdentity phaseIdentity;

    @Override
    protected void init() throws QuotaExecutionException {
        super.init();
        Assert.nonNull((Object)this.phaseConfig, (String)"phaseConfig");
        Assert.nonNull(this.chainExecutor, (String)"chainExecutor");
        this.phaseIdentity = new TiePhaseIdentity(this.phaseConfig.getNumber(), this.chainExecutor.getSchemeIdentity(), this.phaseConfig.getIndex(), this.phaseConfig.getSaveFlag(), this.phaseConfig.getResult(), this.phaseConfig.getId());
    }

    @Override
    protected int getExecutorSize() {
        return this.phaseConfig.getStepConfigsByDate(this.chainExecutor.getChainDate()).size();
    }

    @Override
    protected QuotaExecutor<T> makeExecutor(int executorIndex) {
        List<TieStepConfig> stepConfigs = this.phaseConfig.getStepConfigsByDate(this.chainExecutor.getChainDate());
        TieStepConfig stepConfig = stepConfigs.get(executorIndex);
        QuotaStepExecutor executor = (QuotaStepExecutor)WTCAppContextHelper.getBean(QuotaStepExecutorStd.class);
        executor.setPhaseExecutor(this);
        executor.setStepConfig(stepConfig);
        return executor;
    }

    @Override
    public String getExecutorTag() {
        return this.phaseIdentity.getNumber();
    }

    @Override
    public String getExecutorName() {
        return this.phaseConfig.getName();
    }

    @Override
    protected TieStatusDecision makeDecision() {
        TieStatusDecision tieStatusDecision = (TieStatusDecision)WTCAppContextHelper.getBean(TieStatusDecision.class);
        tieStatusDecision.mackDecisionMap(this.phaseConfig.getExecutorDecision());
        return tieStatusDecision;
    }

    @Override
    public void setChainExecutor(QuotaChainExecutor<T> chainExecutor) {
        this.chainExecutor = chainExecutor;
    }

    @Override
    public QuotaChainExecutor<T> getChainExecutor() {
        return this.chainExecutor;
    }

    @Override
    public void setPhaseConfig(TiePhaseConfig phaseConfig) {
        this.phaseConfig = phaseConfig;
    }

    @Override
    public TiePhaseIdentity getPhaseIdentity() {
        return this.phaseIdentity;
    }

    @Override
    public void setPhaseIdentity(TiePhaseIdentity phaseIdentity) {
        this.phaseIdentity = phaseIdentity;
    }

    @Override
    public QuotaPhaseDataResult<T> getPhaseDataResult() {
        List stepDataResults = this.getExecutedExecutors().stream().map(QuotaStepExecutor::getStepDataResult).collect(Collectors.toList());
        return new PhaseDataResult(stepDataResults, this.getResultStatus(), this.phaseConfig.getNumber(), this.phaseConfig.getName());
    }

    @Override
    public List<QuotaStepExecutor<T>> getExecutedExecutors() {
        return super.getExecutedExecutors();
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.chainExecutor.getAlarm().alarm(msgLevel, msg);
    }

    private static class PhaseDataResult<T extends IQuotaDataNode<T>>
    implements QuotaPhaseDataResult<T> {
        private final List<QuotaStepDataResult<T>> stepDataResults;
        private final TieStatus resultStatus;
        private final String number;
        private final String name;

        public PhaseDataResult(List<QuotaStepDataResult<T>> stepDataResults, TieStatus resultStatus, String number, String name) {
            this.stepDataResults = stepDataResults;
            this.resultStatus = resultStatus;
            this.number = number;
            this.name = name;
        }

        @Override
        public List<QuotaStepDataResult<T>> getStepDataResults() {
            return this.stepDataResults;
        }

        @Override
        public String getNumber() {
            return this.number;
        }

        @Override
        public TieStatus getResultStatus() {
            return this.resultStatus;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

