/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.core.scheme.TieStepIdentity;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.chain.AbstractQuotaExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaContext;
import kd.wtc.wtes.business.quota.chain.QuotaContextDefault;
import kd.wtc.wtes.business.quota.chain.QuotaDataResult;
import kd.wtc.wtes.business.quota.chain.QuotaEvaluator;
import kd.wtc.wtes.business.quota.chain.QuotaExecutionException;
import kd.wtc.wtes.business.quota.chain.QuotaFilter;
import kd.wtc.wtes.business.quota.chain.QuotaPhaseExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactory;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.IQuotaTraceable;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeCore;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeWrapper;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtes.business.quota.service.QuotaAlarm;
import kd.wtc.wtes.business.quota.service.QuotaIdService;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.Strings;

public class QuotaStepExecutorDefault<T extends IQuotaDataNode<T>>
extends AbstractQuotaExecutor<T>
implements QuotaStepExecutor<T> {
    protected static final Log LOG = LogFactory.getLog(QuotaStepExecutorDefault.class);
    private TieStepConfig stepConfig;
    private QuotaPhaseExecutor<T> phaseExecutor;
    private QuotaEvaluator<T, ? extends IQuotaTraceable<T>> evaluator;
    @Nullable
    private QuotaFilter<T> filter;
    private QuotaAlarm alarm;
    private QuotaDataNodeWrapper<T> dataNodeWrapper;
    private QuotaIdService idService;
    private TieStepIdentity stepIdentity;
    protected CalReportParaHolder reportPara;

    @Override
    protected void init() throws QuotaExecutionException {
        super.init();
        Assert.nonNull(this.phaseExecutor, (String)"phaseExecutor");
        Assert.nonNull((Object)((Object)this.stepConfig), (String)"stepConfig");
        this.alarm = this.phaseExecutor.getChainExecutor().getAlarm();
        this.dataNodeWrapper = this.phaseExecutor.getChainExecutor().getDataNodeWrapper();
        this.idService = this.phaseExecutor.getChainExecutor().getIdService();
        QuotaStepExecutorUnitFactory<T> unitFactory = this.phaseExecutor.getChainExecutor().getStepExecutorUnitFactory();
        this.evaluator = unitFactory.createEvaluator(this.stepConfig.getEvaluatorName(), this.stepConfig.getTieUnitType());
        if (Strings.isNotBlank((String)this.stepConfig.getFilterName())) {
            this.filter = unitFactory.createFilter(this.stepConfig.getFilterName(), this.stepConfig.getTieUnitType());
        }
        this.stepIdentity = new TieStepIdentity(this.stepConfig.getId(), this.stepConfig.getNumber(), this.phaseExecutor.getPhaseIdentity(), this.stepConfig.getStepEntryId());
    }

    @Override
    protected void doExecute() throws QuotaExecutionException {
        try {
            QuotaContext<T> context = this.makeContext();
            this.beforeExecute(context);
            this.doExecute(context);
            this.afterExecute(context);
        }
        catch (Exception e) {
            LOG.warn("QuotaStepExecutorDefault_doExecute", (Throwable)e);
            throw e;
        }
    }

    private void doExecute(QuotaContext<T> context) throws QuotaExecutionException {
        QuotaDataResult<IQuotaTraceable<T>> evaluatorResult;
        if (this.filter == null) {
            evaluatorResult = this.evaluator.evaluate(context);
        } else {
            QuotaDataResult<T> filterResult = this.filter.filter(context);
            if (filterResult.hasMessage()) {
                this.tieMessages.add(filterResult.getMessage());
            }
            if (CollectionUtils.isEmpty(filterResult.getDataNodes())) {
                return;
            }
            evaluatorResult = this.evaluator.evaluate(context, filterResult.getDataNodes());
        }
        if (evaluatorResult.hasMessage()) {
            this.tieMessages.add(evaluatorResult.getMessage());
        }
        if (CollectionUtils.isNotEmpty(evaluatorResult.getDataNodes())) {
            this.addWrappedResultDataNodes(evaluatorResult.getDataNodes());
        }
    }

    private void addWrappedResultDataNodes(List<? extends IQuotaTraceable<T>> dataNodes) {
        ArrayList dataNodeCores = new ArrayList(dataNodes.size());
        long[] ids = this.idService.genLongIds(dataNodes.size());
        int index = 0;
        for (IQuotaTraceable<T> dataNode : dataNodes) {
            QuotaDataNodeCore<T> dataNodeCore = new QuotaDataNodeCore<T>();
            dataNodeCore.setId(ids[index++]);
            dataNodeCore.setData(dataNode);
            dataNodeCore.setStepIdentity(this.getStepIdentity());
            dataNodeCores.add(dataNodeCore);
            if (dataNode.parentDataNodes().isEmpty()) continue;
            List<QuotaDataNodeCore<T>> parentDataNodeCodes = this.dataNodeWrapper.unwrap(dataNode.parentDataNodes());
            for (QuotaDataNodeCore<T> parentDataNodeCore : parentDataNodeCodes) {
                parentDataNodeCore.setLeaf(false);
                if (!parentDataNodeCore.getStepIdentity().getPhaseIdentity().getNumber().equals(this.getStepIdentity().getPhaseIdentity().getNumber())) continue;
                parentDataNodeCore.setLeafInPhase(false);
            }
        }
        List<T> wrappedDataNodeCores = this.dataNodeWrapper.wrap(dataNodeCores);
        this.addResultDataNodes(wrappedDataNodeCores);
    }

    protected void beforeExecute(QuotaContext<T> context) throws QuotaExecutionException {
    }

    protected void afterExecute(QuotaContext<T> context) throws QuotaExecutionException {
    }

    protected QuotaContext<T> makeContext() {
        return new QuotaContextDefault(this);
    }

    @Override
    public String getExecutorTag() {
        return this.stepIdentity.getNumber();
    }

    @Override
    public String getExecutorName() {
        return this.stepConfig.getName();
    }

    @Override
    public void setPhaseExecutor(QuotaPhaseExecutor<T> phaseExecutor) {
        this.phaseExecutor = phaseExecutor;
    }

    @Override
    public void setStepConfig(TieStepConfig stepConfig) {
        this.stepConfig = stepConfig;
    }

    @Override
    public TieStepIdentity getStepIdentity() {
        return this.stepIdentity;
    }

    @Override
    public QuotaPhaseExecutor<T> getPhaseExecutor() {
        return this.phaseExecutor;
    }

    @Override
    public QuotaStepDataResult<T> getStepDataResult() {
        return new StepDataResultImpl(this.getResultDataNodes(), this.getResultStatus(), this.stepConfig.getId(), this.stepConfig.getNumber(), this.stepConfig.getName());
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.alarm.alarm(msgLevel, msg);
    }

    private static class StepDataResultImpl<T extends IQuotaDataNode<T>>
    implements QuotaStepDataResult<T> {
        private final List<T> dataNodes;
        private final TieStatus resultStatus;
        private final long stepId;
        private final String number;
        private final String name;

        public StepDataResultImpl(List<T> dataNodes, TieStatus resultStatus, long stepId, String number, String name) {
            this.dataNodes = dataNodes;
            this.resultStatus = resultStatus;
            this.stepId = stepId;
            this.number = number;
            this.name = name;
        }

        @Override
        public List<T> getDataNodes() {
            return this.dataNodes;
        }

        @Override
        public long getId() {
            return this.stepId;
        }

        @Override
        public String getNumber() {
            return this.number;
        }

        @Override
        public TieStatus getResultStatus() {
            return this.resultStatus;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

