/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.chain;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.scheme.TieSchemeIdentity;
import kd.wtc.wtes.business.quota.chain.QuotaChainExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaPhaseExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutor;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtp.business.cumulate.trading.model.ScalableExtObj;

class QuotaWrappedDataPackage<T extends IQuotaDataNode<T>>
extends ScalableExtObj
implements QuotaDataPackage<T> {
    private final QuotaChainExecutor<T> chainExecutor;
    private List<QuotaPhaseDataResult<T>> phaseDataResults;
    private List<T> allDataNodes;
    boolean emptyDataPackage = false;
    private int bitMap = 0;

    @Override
    public int getBitMap() {
        return this.bitMap;
    }

    @Override
    public void setBitMap(int bitMap) {
        this.bitMap = bitMap;
    }

    @Override
    public boolean isEmptyDataPackage() {
        return this.emptyDataPackage;
    }

    @Override
    public void setEmptyDataPackage(boolean isEmptyDataPackage) {
        this.emptyDataPackage = isEmptyDataPackage;
    }

    public QuotaWrappedDataPackage(QuotaChainExecutor<T> chainExecutor) {
        this.chainExecutor = chainExecutor;
    }

    @Override
    public List<T> getAllDataNodes() {
        if (this.isEmptyDataPackage()) {
            return Collections.emptyList();
        }
        if (this.allDataNodes == null) {
            this.allDataNodes = new LinkedList(this.chainExecutor.getResultDataNodes());
            if (this.chainExecutor.getResultStatus() == TieStatus.UNKNOWN) {
                this.appendExecutingResults();
            }
        }
        return this.allDataNodes;
    }

    private void appendExecutingResults() {
        QuotaPhaseExecutor<T> lastPhase;
        List<QuotaPhaseExecutor<T>> phaseExecutors = this.chainExecutor.getExecutedExecutors();
        if (!phaseExecutors.isEmpty() && (lastPhase = phaseExecutors.get(phaseExecutors.size() - 1)).getResultStatus() == TieStatus.UNKNOWN) {
            this.allDataNodes.addAll(lastPhase.getResultDataNodes());
        }
    }

    @Override
    public List<QuotaPhaseDataResult<T>> getPhaseDataResults() {
        if (this.isEmptyDataPackage()) {
            return Collections.emptyList();
        }
        if (this.phaseDataResults == null) {
            this.phaseDataResults = this.chainExecutor.getExecutedExecutors().stream().map(PhaseDataResultDefault::new).collect(Collectors.toList());
        }
        return this.phaseDataResults;
    }

    @Override
    public String getVersion() {
        return this.chainExecutor.getQuotaRequest().getVersion();
    }

    @Override
    public long getAttPersonId() {
        return this.chainExecutor.getAttSubjectEntry().getPersonId();
    }

    @Override
    public LocalDate getChainDate() {
        return this.chainExecutor.getChainDate();
    }

    @Override
    public TieStatus getResultStatus() {
        return this.chainExecutor.getResultStatus();
    }

    @Override
    public TieSchemeIdentity getQuotaSchemeIdentity() {
        return this.chainExecutor.getSchemeIdentity();
    }

    public String toString() {
        return "DataPackage{version=" + this.getVersion() + ", attPersonId=" + this.getAttPersonId() + ", chainDate=" + this.getChainDate() + ", phaseDataResults=" + this.getPhaseDataResults() + ", tieSchemeNumber=" + this.getQuotaSchemeIdentity().getNumber() + '}';
    }

    private static class StepDataResultDefault<T extends IQuotaDataNode<T>>
    implements QuotaStepDataResult<T> {
        QuotaStepExecutor<T> stepExecutor;

        public StepDataResultDefault(QuotaStepExecutor<T> stepExecutor) {
            this.stepExecutor = stepExecutor;
        }

        @Override
        public List<T> getDataNodes() {
            return this.stepExecutor.getResultDataNodes();
        }

        @Override
        public long getId() {
            return this.stepExecutor.getStepIdentity().getId();
        }

        @Override
        public String getNumber() {
            return this.stepExecutor.getStepIdentity().getNumber();
        }

        @Override
        public String getName() {
            return this.stepExecutor.getExecutorName();
        }

        @Override
        public TieStatus getResultStatus() {
            return this.stepExecutor.getResultStatus();
        }

        public String toString() {
            return "StepDataResultDefault{id=" + this.getId() + ",number=" + this.getNumber() + ",dataNodes=" + this.getDataNodes() + '}';
        }
    }

    private static class PhaseDataResultDefault<T extends IQuotaDataNode<T>>
    implements QuotaPhaseDataResult<T> {
        QuotaPhaseExecutor<T> phase;
        List<QuotaStepDataResult<T>> stepDataResults;

        PhaseDataResultDefault(QuotaPhaseExecutor<T> phase) {
            this.phase = phase;
        }

        @Override
        public List<QuotaStepDataResult<T>> getStepDataResults() {
            if (this.stepDataResults == null) {
                this.stepDataResults = this.phase.getExecutedExecutors().stream().map(StepDataResultDefault::new).collect(Collectors.toList());
            }
            return this.stepDataResults;
        }

        @Override
        public String getNumber() {
            return this.phase.getPhaseIdentity().getNumber();
        }

        @Override
        public String getName() {
            return this.phase.getExecutorName();
        }

        @Override
        public TieStatus getResultStatus() {
            return this.phase.getResultStatus();
        }

        public String toString() {
            return "PhaseDataResultDefault{phaseNumber=" + this.getNumber() + ", getDataNodes=" + this.getStepDataResults() + '}';
        }
    }
}

