/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.datanode;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;

public interface QuotaPhaseDataResult<T extends IQuotaDataNode<T>> {
    public List<QuotaStepDataResult<T>> getStepDataResults();

    default public List<T> getPhaseLeafDataNodes() {
        List<QuotaStepDataResult<T>> quotaStepDataResults = this.getStepDataResults();
        if (quotaStepDataResults.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<T> phaseResult = new LinkedList<T>();
        for (QuotaStepDataResult<T> quotaStepDataResult : quotaStepDataResults) {
            phaseResult.addAll(quotaStepDataResult.getDataNodes());
        }
        return phaseResult.stream().filter(IQuotaDataNode::isLeafInPhase).collect(Collectors.toList());
    }

    public String getNumber();

    public TieStatus getResultStatus();

    public String getName();
}

