/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.drouter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.model.jsondto.QuotaAccountPlanJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaAttitemJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaBucketJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaPhaseJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaRuleJsonDto;
import kd.wtc.wtbs.common.model.jsondto.QuotaStepJsonDto;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaPhaseDataResult;
import kd.wtc.wtes.business.quota.datanode.QuotaStepDataResult;
import kd.wtc.wtes.business.quota.drouter.AbstractQuotaDataPackageRouterStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaAttRecordModel;
import kd.wtc.wtes.business.quota.model.QuotaDataPackageInfo;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataPackageStd;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.business.quota.storage.QuotaDataPackageStoreManager;
import kd.wtc.wtes.business.quota.storage.QuotaRecordAndPackageWrapper;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaRecordRouter
extends AbstractQuotaDataPackageRouterStd {
    @Override
    public void commitStd(QuotaDataPackageStd dataPackage) {
        List<QuotaAttRecordModel> recordModelList;
        QuotaRequestStd quotaRequestStd = this.getQuotaRequestStd();
        List<Long> needSaveBoIds = quotaRequestStd.getAttFileBoIds();
        if (WTCCollections.isEmpty(needSaveBoIds)) {
            return;
        }
        List<QuotaDataNodeStd> dataNodes = dataPackage.getAllDataNodes();
        boolean saveEvaluationDetail = quotaRequestStd.isSaveEvaluationDetail();
        QuotaDataPackageInfo packageInfo = this.makePackInfoByOriPackage(dataPackage);
        QuotaAccountPlanJsonDto phaseJsonDto = null;
        if (saveEvaluationDetail) {
            phaseJsonDto = this.transformerJsonDto(dataPackage, packageInfo);
        }
        if (!WTCCollections.isEmpty(recordModelList = this.geneRecordModelListByDateNodes(dataNodes, packageInfo, needSaveBoIds))) {
            QuotaDataPackageStoreManager dataPackageStoreManager = QuotaDataPackageStoreManager.getInstance();
            dataPackageStoreManager.store(new QuotaRecordAndPackageWrapper(recordModelList, packageInfo, phaseJsonDto));
        }
    }

    private List<QuotaAttRecordModel> geneRecordModelListByDateNodes(List<QuotaDataNodeStd> dataNodes, QuotaDataPackageInfo packageInfo, List<Long> needSaveBoIds) {
        Map<String, QuotaAttItemValue> attItemValueMap = QuotaContextUtil.getAllHandleResultAttItemValue(dataNodes);
        ArrayList recordModelList = Lists.newArrayList();
        HashSet attItemIdSpliteSet = Sets.newHashSetWithExpectedSize((int)16);
        List<QuotaDataNodeStd> quotaDataNodeStdList = QuotaContextUtil.reverseNodeList(dataNodes);
        LinkedHashMap phaseDataNodes = quotaDataNodeStdList.stream().collect(Collectors.groupingBy(ob -> ob.getStepIdentity().getPhaseIdentity().getId(), LinkedHashMap::new, Collectors.toList()));
        phaseDataNodes.forEach((entry, dataNodeList) -> dataNodeList.forEach(node -> {
            List<QuotaAttItemInstance> attItemInstances = node.getAttItemInstances();
            for (QuotaAttItemInstance itemInstance : attItemInstances) {
                QuotaAttItemValue attItemValue;
                String attitemSpliteStr;
                QuotaAttItemType quotaAttItemType;
                Long attItemId;
                AttItemSpec attItemSpec;
                boolean persistence;
                if (!needSaveBoIds.contains(itemInstance.getAttFileBoId()) || !(persistence = (attItemSpec = itemInstance.getAttItemSpec()).isPersistence()) || (attItemId = Long.valueOf(attItemSpec.getBid())) == null || (quotaAttItemType = itemInstance.getQuotaAttItemType()) == null || attItemIdSpliteSet.contains(attitemSpliteStr = QuotaContextUtil.getSpliteStr(itemInstance)) || itemInstance.getHandleFlag() == null || !itemInstance.getHandleFlag().booleanValue() || (attItemValue = (QuotaAttItemValue)attItemValueMap.get(attitemSpliteStr)) == null) continue;
                attItemIdSpliteSet.add(attitemSpliteStr);
                recordModelList.add(this.getAttRecordModel((QuotaDataNodeStd)node, attItemValue, itemInstance, packageInfo));
            }
        }));
        return recordModelList;
    }

    private QuotaAttRecordModel getAttRecordModel(QuotaDataNodeStd nodeStd, QuotaAttItemValue attItemValue, QuotaAttItemInstance itemInstance, QuotaDataPackageInfo packageInfo) {
        AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
        QuotaAttRecordModel model = new QuotaAttRecordModel();
        this.setRecordModelValue(nodeStd, attItemValue, attItemSpec, model);
        model.setGenStartDate(itemInstance.getGenStartDate());
        long timeBuckId = nodeStd.getId();
        model.setTimeBuckId(timeBuckId);
        model.setGenEndDate(itemInstance.getGenEndDate());
        model.setUseStartDate(itemInstance.getUseStartDate());
        model.setUseEndDate(itemInstance.getUseEndDate());
        model.setAttitemVid(itemInstance.getAttItemSpec().getId());
        model.setSourceAttitemId(itemInstance.getAttItemSpec().getBid());
        model.setQtTypeId(itemInstance.getQttypeId());
        Long qtTypeId = packageInfo.getQtTypeId();
        if (qtTypeId != null && qtTypeId != 0L) {
            model.setQtTypeId(packageInfo.getQtTypeId());
        }
        model.setPeriodCircleId(itemInstance.getPeriodcircleId());
        model.setPeriodNum(itemInstance.getPeriodNum());
        Integer periodNum = packageInfo.getPeriodNum();
        if (periodNum != null && (long)periodNum.intValue() != 0L) {
            model.setPeriodNum(packageInfo.getPeriodNum());
        }
        model.setSource(itemInstance.getSource() == null ? null : itemInstance.getSource().code);
        model.setBoId(itemInstance.getQtDetailId());
        model.setType(itemInstance.getQuotaAttItemType() == null ? null : itemInstance.getQuotaAttItemType().code);
        model.setAssignDate(itemInstance.getPeriodAttribtion());
        model.setCrossStartDate(itemInstance.getChangeSatrt());
        model.setCrossEndDate(itemInstance.getChangeEnd());
        BigDecimal value = model.getValue();
        model.setAttitemValue(value);
        int dataAccuracy = attItemSpec.getDataAccuracy();
        String precisionTail = attItemSpec.getPrecisionTail();
        model.setAttitemValueStr(QuotaRecordRouter.scale(value, dataAccuracy, BigDecimal.ONE, precisionTail));
        model.setVestDay(itemInstance.getVestDay());
        model.setVestType(itemInstance.getVestType());
        model.setAttFileVid(itemInstance.getAttFileVId());
        return model;
    }

    private static String scale(BigDecimal value, int dataaccuracy, BigDecimal scale, String precisionTail) {
        if (value == null) {
            return null;
        }
        int precision = 4;
        switch (precisionTail) {
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
        }
        return value.divide(scale, dataaccuracy, precision).stripTrailingZeros().toPlainString();
    }

    private void setRecordModelValue(QuotaDataNodeStd nodeStd, QuotaAttItemValue attItemValue, AttItemSpec attItemSpec, QuotaAttRecordModel model) {
        BigDecimal value = attItemValue.getAttItemInstance().getItemValue();
        model.setValue(value);
        long[] parentIds = attItemValue.getParentIds();
        if (parentIds != null && parentIds.length > 0) {
            Set<Long> set = Arrays.stream(attItemValue.getParentIds()).boxed().collect(Collectors.toSet());
            set.remove(nodeStd.getId());
            set.addAll(Arrays.stream(nodeStd.getParentIds()).boxed().collect(Collectors.toSet()));
            nodeStd.getDataNodeCore().setLinkParentIdSet(set);
        }
    }

    private QuotaDataPackageInfo makePackInfoByOriPackage(QuotaDataPackageStd dataPackage) {
        QuotaRequestStd quotaRequestStd = this.getQuotaRequestStd();
        QuotaDataPackageInfo packageInfo = new QuotaDataPackageInfo();
        String version = quotaRequestStd.getVersion();
        packageInfo.setVersion(version);
        packageInfo.setCalculateDate(WTCDateUtils.toDate((LocalDateTime)quotaRequestStd.getCreateTime()));
        packageInfo.setCalculatorId(quotaRequestStd.getCreateUserId());
        packageInfo.setShardingIndex(quotaRequestStd.getShardingIndex());
        long attPersonId = dataPackage.getAttPersonId();
        packageInfo.setAttPersonId(attPersonId);
        LocalDate endDate = dataPackage.getChainDate();
        AttFileCabinet attFileTimeSeqBoMap = (AttFileCabinet)this.getInitParam("ATT_FILE");
        AttFileModel attFileModel = attFileTimeSeqBoMap.getByAttPersonIdAndDate(attPersonId, endDate);
        long attFileId = attFileModel.getTimeSeqInfo().getBid();
        packageInfo.setAttFileId(attFileId);
        long attFileVid = attFileModel.getTimeSeqInfo().getVid();
        packageInfo.setAttFileVid(attFileVid);
        packageInfo.setQtTypeId(dataPackage.getQuotaTypeId());
        CircleRestVo circleRestVo = dataPackage.getCircleRestVo();
        packageInfo.setPeriodNum(circleRestVo != null ? circleRestVo.getIndex() : 0);
        packageInfo.setBitMap(dataPackage.getBitMap());
        packageInfo.copyAllExtAttribute(dataPackage);
        return packageInfo;
    }

    private QuotaAccountPlanJsonDto transformerJsonDto(QuotaDataPackageStd dataPackage, QuotaDataPackageInfo packageInfo) {
        QuotaAccountPlanJsonDto accountPlanJsonDto = this.transferAccountPlanJsonByPackage(dataPackage);
        List<QuotaDataNodeStd> dataNodes = dataPackage.getAllDataNodes();
        ArrayList<QuotaBucketJsonDto> bucketJsonDtoList = new ArrayList<QuotaBucketJsonDto>(dataNodes.size());
        for (QuotaDataNodeStd dataNode : dataNodes) {
            boolean lastInPhase = dataNode.isLeafInPhase();
            QuotaBucketJsonDto bucketJsonDto = new QuotaBucketJsonDto();
            bucketJsonDto.setBucketId(Long.valueOf(dataNode.getId()));
            bucketJsonDto.setStepId(Long.valueOf(dataNode.getStepIdentity().getId()));
            List<EvaluationRuleModel> evaluationRules = dataNode.getEvaluationRule();
            if (!CollectionUtils.isEmpty(evaluationRules)) {
                ArrayList quotaRuleJsonDtoList = Lists.newArrayListWithExpectedSize((int)16);
                for (EvaluationRuleModel evaluationRuleModel : evaluationRules) {
                    QuotaRuleJsonDto quotaRuleJsonDto = new QuotaRuleJsonDto();
                    quotaRuleJsonDto.setEntityName(evaluationRuleModel.getRuleSourceNumber());
                    quotaRuleJsonDto.setParamId(Long.valueOf(evaluationRuleModel.getId()));
                    quotaRuleJsonDtoList.add(quotaRuleJsonDto);
                }
                bucketJsonDto.setQuotaRuleJsonDtoList((List)quotaRuleJsonDtoList);
                bucketJsonDto.setEntityName(StringUtils.join((Iterable)evaluationRules.stream().map(EvaluationRuleModel::getRuleSourceNumber).collect(Collectors.toList()), (String)","));
            }
            long[] parentIds = dataNode.getParentIds();
            ArrayList<Long> parentBucketIds = new ArrayList<Long>(parentIds.length);
            for (int i = 0; i < parentIds.length; ++i) {
                parentBucketIds.add(parentIds[i]);
            }
            Set<Long> linkParentIdSet = dataNode.getDataNodeCore().getLinkParentIdSet();
            if (!CollectionUtils.isEmpty(linkParentIdSet)) {
                bucketJsonDto.setParentBucketId(new ArrayList<Long>(linkParentIdSet));
            } else {
                bucketJsonDto.setParentBucketId(parentBucketIds);
            }
            bucketJsonDto.setLastInPhase(Boolean.valueOf(lastInPhase));
            bucketJsonDto.setType("1");
            List<QuotaAttItemInstance> attItemInstances = dataNode.getAttItemInstances();
            ArrayList<QuotaAttitemJsonDto> attitemJsonDtos = new ArrayList<QuotaAttitemJsonDto>(attItemInstances.size());
            for (QuotaAttItemInstance itemInstance : attItemInstances) {
                AttItemSpec attItemSpec = itemInstance.getAttItemSpec();
                QuotaAttitemJsonDto attitemJsonDto = new QuotaAttitemJsonDto();
                attitemJsonDto.setQtTypeId(packageInfo.getQtTypeId());
                attitemJsonDto.setPeriodNum(itemInstance.getPeriodNum());
                attitemJsonDto.setAttitemId(attItemSpec.getId());
                attitemJsonDto.setNumber(attItemSpec.getNumber());
                attitemJsonDto.setDataType(attItemSpec.getDataType().code);
                attitemJsonDto.setItemType(attItemSpec.getItemType());
                int dataAccuracy = attItemSpec.getDataAccuracy();
                String precisionTail = attItemSpec.getPrecisionTail();
                attitemJsonDto.setItemValueStr(QuotaRecordRouter.scale(itemInstance.getItemValue(), dataAccuracy, BigDecimal.ONE, precisionTail));
                attitemJsonDto.setItemValue(itemInstance.getItemValue());
                attitemJsonDto.setOriginalItem(attItemSpec.isOriginalItem());
                attitemJsonDto.setUnit(attItemSpec.getUnit());
                attitemJsonDto.setGenStartDate(itemInstance.getGenStartDate());
                attitemJsonDto.setGenEndDate(itemInstance.getGenEndDate());
                attitemJsonDto.setUseStartDate(itemInstance.getUseStartDate());
                attitemJsonDto.setUseEndDate(itemInstance.getUseEndDate());
                attitemJsonDtos.add(attitemJsonDto);
            }
            bucketJsonDto.setQuotaAttitemList(attitemJsonDtos);
            bucketJsonDtoList.add(bucketJsonDto);
        }
        this.mountBuckets(accountPlanJsonDto, bucketJsonDtoList);
        return accountPlanJsonDto;
    }

    private void mountBuckets(QuotaAccountPlanJsonDto accountPlanJsonDto, List<QuotaBucketJsonDto> bucketJsonDtoList) {
        List phaseList = accountPlanJsonDto.getPhaseList();
        for (QuotaPhaseJsonDto phase : phaseList) {
            List steps = phase.getSteps();
            steps.forEach(stepJsonDto -> {
                Long stepId = stepJsonDto.getStepId();
                List filterBucketList = bucketJsonDtoList.stream().filter(bucketJsonDto -> bucketJsonDto.getStepId().equals(stepId)).collect(Collectors.toList());
                stepJsonDto.setBucketDto(filterBucketList);
            });
        }
    }

    private QuotaAccountPlanJsonDto transferAccountPlanJsonByPackage(QuotaDataPackageStd dataPackage) {
        QuotaAccountPlanJsonDto accountPlanJsonDto = new QuotaAccountPlanJsonDto();
        List<QuotaPhaseDataResult<QuotaDataNodeStd>> phaseDataResultList = dataPackage.getPhaseDataResults();
        ArrayList<QuotaPhaseJsonDto> phaseJsonDtoList = new ArrayList<QuotaPhaseJsonDto>(phaseDataResultList.size());
        for (QuotaPhaseDataResult<QuotaDataNodeStd> phase : phaseDataResultList) {
            QuotaPhaseJsonDto phaseJsonDto = new QuotaPhaseJsonDto();
            phaseJsonDto.setName(phase.getName());
            List<QuotaStepDataResult<QuotaDataNodeStd>> steps = phase.getStepDataResults();
            ArrayList<QuotaStepJsonDto> stepJsonDtoList = new ArrayList<QuotaStepJsonDto>(steps.size());
            for (QuotaStepDataResult<QuotaDataNodeStd> step : steps) {
                QuotaStepJsonDto stepJsonDto = new QuotaStepJsonDto();
                stepJsonDto.setStepId(Long.valueOf(step.getId()));
                stepJsonDto.setName(step.getName());
                stepJsonDtoList.add(stepJsonDto);
            }
            phaseJsonDto.setSteps(stepJsonDtoList);
            phaseJsonDtoList.add(phaseJsonDto);
        }
        accountPlanJsonDto.setPhaseList(phaseJsonDtoList);
        return accountPlanJsonDto;
    }
}

