/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.QuotaException;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.engine.AbstractQuotaEngine;
import kd.wtc.wtes.business.quota.engine.QuotaLine;
import kd.wtc.wtes.business.quota.engine.QuotaParamInitExecutor;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaBillCalInfo;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaEngineConcurrent<T extends IQuotaDataNode<T>>
extends AbstractQuotaEngine<T> {
    private volatile Map<Long, Future<?>> attPersonId2LineFutureMap;
    private List<Future<Tuple<String, QuotaInitParamResult>>> initFutures;
    static final int DEFAULT_LINE_POOL_SIZE = 2;
    static final int LINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("quota.engine.pool.size", 2);
    static final String DEFAULT_LINE_POOL_NAME = "QuotaLinePool";
    static final String LINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("quota.engine.pool.name", "QuotaLinePool");
    private static final ExecutorService LINE_EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)LINE_POOL_NAME, (int)LINE_POOL_SIZE);

    @Override
    protected Map<String, Object> loadInitParams(List<QuotaParamInitializer> initialises, QuotaInitParamRequest initRequest) throws InterruptedException, QuotaException {
        RequestContext requestContext = RequestContext.get();
        List tieParamInitExecutors = initialises.stream().map(initializer -> TaskTracer.wrap((Callable)new QuotaParamInitExecutor((QuotaParamInitializer)initializer, initRequest))).collect(Collectors.toList());
        this.initFutures = INIT_EXECUTOR_SERVICE.invokeAll(tieParamInitExecutors);
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Future<Tuple<String, QuotaInitParamResult>> future : this.initFutures) {
            Tuple<String, QuotaInitParamResult> tuple;
            this.checkInterrupt();
            try {
                tuple = future.get();
            }
            catch (ExecutionException e) {
                this.log.warn("[TIE] init error ", (Throwable)e);
                this.terminateRunningInitializer();
                throw new QuotaException(e.getCause(), TieEngineErrorCodes.getParamInitErr(), e.getCause().getMessage());
            }
            if (((QuotaInitParamResult)tuple.getValue()).hasParams()) {
                params.put((String)tuple.getKey(), ((QuotaInitParamResult)tuple.getValue()).getInitData());
            }
            if (!((QuotaInitParamResult)tuple.getValue()).hasMessage()) continue;
            this.exporter.alarm(((QuotaInitParamResult)tuple.getValue()).getMessage());
        }
        return params;
    }

    @Override
    protected void terminateRunningInitializer() {
        if (WTCCollections.isNotEmpty(this.initFutures)) {
            for (Future<Tuple<String, QuotaInitParamResult>> initFuture : this.initFutures) {
                initFuture.cancel(true);
            }
        }
    }

    @Override
    protected void doRun() throws InterruptedException, QuotaException {
        List<AttPersonRange> attSubjects = this.getAttSubjects();
        ExecutorCompletionService completionService = new ExecutorCompletionService(LINE_EXECUTOR_SERVICE);
        this.attPersonId2LineFutureMap = new ConcurrentHashMap(attSubjects.size());
        for (AttPersonRange attSubject : attSubjects) {
            Date minStartDate = attSubject.getAttFileInfoList().stream().map(AttFileInfo::getStartDate).distinct().sorted(Comparator.comparing(Date::getTime)).findFirst().get();
            Date maxEndDate = attSubject.getAttFileInfoList().stream().map(AttFileInfo::getEndDate).distinct().sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().get();
            Future future = completionService.submit(TaskTracer.wrap(() -> {
                try (Span lineSpan = TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_PIPELINE + "[" + attSubject.getPersonId() + "]"));){
                    lineSpan.info(CalcReportConstants.CALCULATE_DATE_RANGER, (Object)(WTCDateUtils.toLocalDate((Date)minStartDate) + "," + WTCDateUtils.toLocalDate((Date)maxEndDate)));
                    QuotaLine currentLine = this.makeLine(attSubject);
                    currentLine.run();
                    this.attPersonId2LineFutureMap.remove(attSubject.getPersonId());
                    this.addDataPackageReportNode(currentLine);
                    if (currentLine.isError()) {
                        lineSpan.warn(CalcReportConstants.RESULT_FAILED_REMARK, (Object)currentLine.getExceptionStr());
                    }
                    lineSpan.info(CalcReportConstants.CALCULATE_RESULT, () -> currentLine.getState() == QuotaState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED);
                    QuotaLine quotaLine = currentLine;
                    return quotaLine;
                }
            }, (String)CalcReportConstants.CALCULATE_PIPELINE));
            this.attPersonId2LineFutureMap.put(attSubject.getPersonId(), future);
        }
        int size = attSubjects.size();
        int finishLine = 0;
        for (int i = 0; i < size; ++i) {
            QuotaLine currentLine;
            this.checkInterrupt();
            try {
                currentLine = (QuotaLine)completionService.take().get();
            }
            catch (ExecutionException e) {
                this.log.warn("QuotaEngineConcurrent_run", (Throwable)e);
                throw new WtesException(e.getCause().getCause(), TieEngineErrorCodes.getLineRunnerErr(), new Object[]{e.getCause().getMessage()});
            }
            if (currentLine.isError()) {
                if (this.exporter.loadInitParamsBeforeErrorOnLine()) {
                    this.exporter.setInitParams(this.getInitParams());
                }
                this.exporter.errorOneLine(currentLine.getAttSubject());
            } else if (currentLine.isSuccess()) {
                this.exporter.finishOneLine(currentLine.getAttSubject());
            }
            this.reportProcess(size, ++finishLine);
        }
        this.storeLastDataPackage();
        this.waitStoreFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        QuotaRequest request = this.getQuotaRequest();
        TaskDesc taskDesc = new TaskDesc("wtte_qttie", request.getVersion(), request.getTaskId(), request.getSubTaskId(), 0L, request.getShardingIndex(), request.getCreateUserId());
        try (TaskTracer taskTracer = TaskTracer.makeTracer((TaskDesc)taskDesc);){
            Span rootSpan = TaskTracer.newRootSpan();
            try {
                super.run();
            }
            catch (Throwable throwable) {
                if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                    rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
                }
                rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == QuotaState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
                rootSpan.close();
                throw throwable;
            }
            if (HRStringUtils.isNotEmpty((String)this.exceptionStr)) {
                rootSpan.error(CalcReportConstants.RESULT_FAILED_REMARK, (Object)this.exceptionStr);
            }
            rootSpan.info(CalcReportConstants.SUBTASK_DISPATCHED_TIME, (Object)request.getSubTaskDispatchedTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            rootSpan.info(CalcReportConstants.CALCULATE_RESULT, (Object)(this.getState() == QuotaState.SUCCESS ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED));
            rootSpan.close();
        }
    }

    @Override
    protected void terminateRunningLines() {
        if (CollectionUtils.isNotEmpty(this.attPersonId2LineFutureMap)) {
            for (Future<?> future : this.attPersonId2LineFutureMap.values()) {
                future.cancel(true);
            }
            this.attPersonId2LineFutureMap.clear();
        }
    }

    @Override
    protected void doRunAfter() {
        try (Span lineSpan = TaskTracer.newSpan((String)"QuotaRunTimeCache_flushDb");){
            QuotaRunTimeCache quotaRunTimeCache = (QuotaRunTimeCache)this.getInitParams().get("QT_RUN_TIME_CACHE");
            quotaRunTimeCache.flushDb();
        }
    }

    @Override
    protected void beforeDoRun() {
        try (Span lineSpan = TaskTracer.newSpan((String)"calBillDeductionBatch");){
            long begin = System.currentTimeMillis();
            this.log.warn("QuotaEngineConcurrent_call_QuotaEngineConcurrent_begin");
            new QuotaBillCalInfo(this.getAttSubjects(), this.getInitParams(), this.getRequest());
            long end = System.currentTimeMillis();
            this.log.warn("QuotaEngineConcurrent_call_QuotaEngineConcurrent_end_{}", (Object)(end - begin));
        }
    }
}

