/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtes.business.quota.engine.QuotaEngineConfigImpl;
import kd.wtc.wtes.business.quota.engine.QuotaEngineService;
import kd.wtc.wtes.business.quota.engine.QuotaEngineServiceSupport;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.common.util.Assert;

public class QuotaEngineServiceImpl
implements QuotaEngineService {
    private static final Log log = LogFactory.getLog(QuotaEngineServiceImpl.class);

    public boolean isTerminate(WTCSubTaskStatus subTaskStatus) {
        return subTaskStatus == WTCSubTaskStatus.TERMINATED;
    }

    private boolean isRunnable(WTCSubTaskStatus subTaskStatus) {
        return subTaskStatus == WTCSubTaskStatus.NEW || subTaskStatus == WTCSubTaskStatus.DISPATCHED;
    }

    @Override
    public void submitQuotaRequest(QuotaRequestStd request) {
        this.submitRequest(request, false);
    }

    @Override
    public void terminateEngineBySubTaskId(long taskId, long subTaskId) {
        QuotaEngineServiceSupport.terminate(taskId, subTaskId);
    }

    @Override
    public void terminateEnginesByTaskId(long taskId) {
        QuotaEngineServiceSupport.terminate(taskId);
    }

    @Override
    public void submitSyncQuotaRequest(QuotaRequestStd request) {
        this.submitRequest(request, true);
    }

    private void submitRequest(QuotaRequestStd request, boolean syncFlag) {
        Assert.nonNull((Object)request.getEndDate(), (String)"tieRequest.getEndDate");
        Assert.isTrue((boolean)WTCCollections.isNotEmpty(request.getAttPlainSubjects()), (String)"attPlainSubjects could not be null or empty");
        Assert.nonNull((Object)request.getVersion(), (String)"tieRequest.getVersion");
        WTCCalSubTaskEntity wtcCalSubTaskEntity = WTCTaskServiceHelper.loadSubTaskById((String)"wtte_qttie", (long)request.getSubTaskId());
        if (wtcCalSubTaskEntity == null) {
            throw new WTCBizException("Task could not found:" + request.getTaskId());
        }
        WTCSubTaskStatus subTaskStatus = wtcCalSubTaskEntity.getSubTaskStatus();
        log.debug("QuotaEngine main task status={}, traceId={},version={}", new Object[]{subTaskStatus, RequestContext.get().getTraceId(), request.getVersion()});
        if (this.isRunnable(subTaskStatus)) {
            boolean transSucceed = WTCTaskServiceHelper.transferToSpecialStateSub((Long)request.getSubTaskId(), (Long)request.getTaskId(), (WTCSubTaskStatus)WTCSubTaskStatus.RUNNING, (String)"wtte_qttie");
            if (transSucceed) {
                if (syncFlag) {
                    QuotaEngineServiceSupport.submitSync(QuotaEngineConfigImpl.DEFAULT, request);
                } else {
                    QuotaEngineServiceSupport.submit(QuotaEngineConfigImpl.DEFAULT, request);
                }
                log.debug("QuotaEngine submit task, subTaskId={}, traceId={},version={}", new Object[]{request.getSubTaskId(), RequestContext.get().getTraceId(), request.getVersion()});
            } else {
                log.debug("QuotaEngine set sub task to RUNNING state failed, state={},subTaskId={}, traceId={},version={}", new Object[]{wtcCalSubTaskEntity.getSubTaskStatus(), request.getSubTaskId(), RequestContext.get().getTraceId(), request.getVersion()});
            }
        } else if (this.isTerminate(subTaskStatus)) {
            WTCTaskServiceHelper.transferToSpecialStateSub((Long)request.getSubTaskId(), (Long)request.getTaskId(), (WTCSubTaskStatus)WTCSubTaskStatus.TERMINATED, (String)"wtte_qttie");
        } else {
            throw new WTCBizException("Task status illegal:" + subTaskStatus);
        }
    }
}

