/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.quota.engine.IQuotaEngineConfig;
import kd.wtc.wtes.business.quota.engine.QuotaEngine;
import kd.wtc.wtes.business.quota.engine.QuotaEngineConcurrent;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaEngineCallbackExecutor;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.business.quota.validator.QuotaValidatorExecutor;
import kd.wtc.wtes.common.lang.WtesException;

final class QuotaEngineServiceSupport {
    static final int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    static final int ENGINE_POOL_SIZE;
    static final String DEFAULT_POOL_NAME = "WTC_WTES_QuotaEnginePool";
    static final String ENGINE_POOL_NAME;
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final Map<String, Future<?>> TASK_ID2FUTURE_MAP;

    static void submit(IQuotaEngineConfig engineConfig, QuotaRequestStd request) {
        String key = QuotaEngineServiceSupport.genKey(request.getTaskId(), request.getSubTaskId());
        TASK_ID2FUTURE_MAP.remove(key);
        QuotaEngine<QuotaDataNodeStd> tieEngine = QuotaEngineServiceSupport.buildQuotaEngine(engineConfig, request);
        Future<?> future = EXECUTOR_SERVICE.submit(tieEngine);
        TASK_ID2FUTURE_MAP.put(key, future);
    }

    static void submitSync(IQuotaEngineConfig engineConfig, QuotaRequestStd request) {
        QuotaEngine<QuotaDataNodeStd> tieEngine = QuotaEngineServiceSupport.buildQuotaEngine(engineConfig, request);
        tieEngine.run();
    }

    static void terminate(long taskId, long subTaskId) {
        String key = QuotaEngineServiceSupport.genKey(taskId, subTaskId);
        QuotaEngineServiceSupport.terminateInner(key);
    }

    private static void terminateInner(String key) {
        TASK_ID2FUTURE_MAP.computeIfPresent(key, (key_, future) -> {
            future.cancel(true);
            return null;
        });
    }

    static void terminate(long taskId) {
        String keyPrefix = QuotaEngineServiceSupport.genKeyPrefix(taskId);
        TASK_ID2FUTURE_MAP.keySet().stream().filter(key -> key.startsWith(keyPrefix)).forEach(QuotaEngineServiceSupport::terminateInner);
    }

    private static String genKey(long taskId, long subTaskId) {
        return QuotaEngineServiceSupport.genKeyPrefix(taskId) + subTaskId;
    }

    private static String genKeyPrefix(long taskId) {
        return taskId + "_";
    }

    private QuotaEngineServiceSupport() {
    }

    private static QuotaEngine<QuotaDataNodeStd> buildQuotaEngine(IQuotaEngineConfig engineConfig, QuotaRequestStd request) {
        String serialized = WTCAppContextHelper.getProjectParams().getString("quota.engine", "CONCURRENT");
        QuotaEngine engine = (QuotaEngine)WTCAppContextHelper.getBean(QuotaEngineConcurrent.class);
        request.setSubTaskDispatchedTime(LocalDateTime.now());
        engine.setDataPackageRouterFactory(engineConfig.getDataPackageRouterFactory());
        engine.setExporter(engineConfig.getExporter());
        engine.setRequest(request);
        engine.setRangeChecker(engineConfig.getRangeChecker());
        engine.setInitialises(engineConfig.getInitialises());
        engine.setIdService(engineConfig.getIdService());
        engine.setDataNodeWrapper(engineConfig.getDataNodeWrapper());
        engine.setStepExecutorUnitFactory(engineConfig.getStepExecutorUnitFactory());
        engine.setValidatorExecutor(new QuotaValidatorExecutor());
        engine.setCompletedCallback(new QuotaEngineCallbackExecutor(engineConfig.getCompletedCallbackList()));
        engine.setRequestContext(RequestContext.get());
        return engine;
    }

    static {
        try {
            ENGINE_POOL_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("quota.engine.pool.size", DEFAULT_POOL_SIZE);
            ENGINE_POOL_NAME = WTCAppContextHelper.getProjectParams().getString("quota.engine.pool.name", DEFAULT_POOL_NAME);
            EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)ENGINE_POOL_NAME, (int)ENGINE_POOL_SIZE);
        }
        catch (Exception e) {
            throw new WtesException((Throwable)e, ResManager.loadKDString((String)"\u5f15\u64ce\u521d\u59cb\u5316\u53c2\u6570\u52a0\u8f7d\u5f02\u5e38", (String)"QuotaEngineServiceSupport_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        TASK_ID2FUTURE_MAP = new ConcurrentHashMap();
    }
}

