/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.engine;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.core.engine.TieEngineKDStrings;
import kd.wtc.wtes.business.core.scheme.ITieSchemeService;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.quota.AbstractQuotaRunner;
import kd.wtc.wtes.business.quota.QuotaException;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.QuotaState;
import kd.wtc.wtes.business.quota.chain.QuotaChainExecutor;
import kd.wtc.wtes.business.quota.chain.QuotaStepExecutorUnitFactory;
import kd.wtc.wtes.business.quota.datanode.IQuotaDataNode;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNodeWrapper;
import kd.wtc.wtes.business.quota.datanode.QuotaDataPackage;
import kd.wtc.wtes.business.quota.drouter.QuotaDataPackageRouter;
import kd.wtc.wtes.business.quota.engine.QuotaLine;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.service.IQuotaLineExporter;
import kd.wtc.wtes.business.quota.service.QuotaIdService;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.service.QuotaTerminable;
import kd.wtc.wtes.business.quota.std.QuotaChainExecutorStd;
import kd.wtc.wtes.business.quota.validator.QuotaValidatorExecutor;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.ErrorCodeUtils;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;

public class QuotaLineDefault<T extends IQuotaDataNode<T>>
extends AbstractQuotaRunner
implements QuotaLine<T> {
    private QuotaRequest tieRequest;
    private Map<String, Object> engineVariable;
    private IQuotaLineExporter lineExporter;
    private QuotaDataPackageRouter<T> dataPackageRouter;
    private Map<String, Object> lineVariable;
    private Map<String, Object> initParams;
    private QuotaDataNodeWrapper<T> dataNodeWrapper;
    private QuotaIdService idService;
    private QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory;
    private static final int VARIABLE_SIZE = 32;
    private QuotaValidatorExecutor validatorExecutor;
    private AttPersonRange attSubject;
    private Set<Long> successFileBo = WTCCollections.modifiableEmptySet();
    private QuotaDataPackage<T> preDataPackage = null;

    @Override
    public QuotaRequest getQuotaRequest() {
        return this.tieRequest;
    }

    @Override
    public String getExceptionStr() {
        return this.exceptionStr;
    }

    @Override
    protected void init() {
        Assert.nonNull((Object)this.tieRequest, (String)"tieRequest");
        Assert.nonNull(this.engineVariable, (String)"engineVariable");
        Assert.nonNull((Object)this.lineExporter, (String)"lineExporter");
        Assert.nonNull(this.dataPackageRouter, (String)"dataPackageRouter");
        Assert.nonNull((Object)this.idService, (String)"idService");
        Assert.nonNull(this.stepExecutorUnitFactory, (String)"stepExecutorUnitFactory");
        Assert.nonNull(this.initParams, (String)"initParams");
        Assert.nonNull((Object)this.attSubject, (String)"attSubject");
        this.lineVariable = new HashMap<String, Object>(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws QuotaException, InterruptedException {
        this.log.debug("QuotaLineDefault_run");
        if (this.log.isDebugEnabled()) {
            this.log.debug("QuotaLineDefault_run {}", (Object)JSON.toJSONString((Object)this.attSubject));
        }
        if (QTAccountModeHelper.isDeductChain((String)this.tieRequest.getAccountMode())) {
            this.runLineForDeductChain();
            return;
        }
        Date startDate = WTCDateUtils.toDate((LocalDate)this.tieRequest.getStartDate());
        Date endDate = WTCDateUtils.toDate((LocalDate)this.tieRequest.getEndDate());
        AttRecordDetailHolder detailHolder = (AttRecordDetailHolder)this.initParams.get("QT_ATT_RECORD_DETAIL");
        AttRecordDetailTable attRecordDetailTable = detailHolder == null ? null : detailHolder.getAttRecordDetailTable();
        try {
            Map<String, Date> map = this.getCircleRestEndDate();
            for (AttFileInfo attFileInfo : this.attSubject.getAttFileInfoList()) {
                if (!Boolean.TRUE.equals(attFileInfo.getLegal()) || null == attFileInfo.getTypeCircleMap() || attFileInfo.getTypeCircleMap().isEmpty() || !this.attFileRun(attFileInfo, startDate, endDate, map)) continue;
                this.successFileBo.add(attFileInfo.getAttFileBaseBoId());
                if (this.preDataPackage == null) continue;
                this.markBoEndAndCarryBoId(this.preDataPackage, attFileInfo.getAttFileBaseBoId());
            }
        }
        finally {
            this.freeAttRecordForSubject(attRecordDetailTable);
        }
    }

    private void freeAttRecordForSubject(AttRecordDetailTable attRecordDetailTable) {
        if (attRecordDetailTable != null) {
            attRecordDetailTable.removeByPersonId(this.attSubject.getPersonId());
            for (AttFileInfo attFileInfo : this.attSubject.getAttFileInfoList()) {
                this.freeAttRecordForFileBo(attRecordDetailTable, attFileInfo);
            }
        }
    }

    private void freeAttRecordForFileBo(AttRecordDetailTable attRecordDetailTable, AttFileInfo attFileInfo) {
        if (attRecordDetailTable != null) {
            attRecordDetailTable.removeByFileBoId(attFileInfo.getAttFileBaseBoId());
        }
    }

    private boolean attFileRun(AttFileInfo attFileInfo, Date startChainDate, Date endChainDate, Map<String, Date> map) {
        boolean hasRun = false;
        try {
            for (Map.Entry<Long, QuotaCycInfo> mapEntry : attFileInfo.getTypeCircleMap().entrySet()) {
                List<CircleRestVo> circleRestVoList = mapEntry.getValue().getRestVos();
                if (null == circleRestVoList || circleRestVoList.isEmpty()) continue;
                this.lineVariable.put("circleRestVoList", circleRestVoList);
                for (CircleRestVo restVo : circleRestVoList) {
                    Date endDay;
                    Date startDate = attFileInfo.getStartDate().after(startChainDate) ? attFileInfo.getStartDate() : startChainDate;
                    Date date = endDay = attFileInfo.getEndDate().after(endChainDate) ? endChainDate : attFileInfo.getEndDate();
                    if (!this.isCanChain(restVo, map, startDate, endDay)) continue;
                    hasRun = true;
                    this.attSubject.setStartDate(startDate);
                    this.attSubject.setCurrentChainAttFileInfo(attFileInfo);
                    this.checkInterrupt();
                    QuotaChainExecutor<T> chain = this.makeChain(this.attSubject);
                    Date endDate = attFileInfo.getEndDate().before(restVo.getEndDate()) ? attFileInfo.getEndDate() : restVo.getEndDate();
                    chain.setChainDate(WTCDateUtils.toLocalDate((Date)endDate));
                    chain.setCircleRestVo(restVo);
                    chain.setQoutaTypeId(mapEntry.getKey());
                    this.executeChain(chain);
                    if (chain.isSuccess()) {
                        QuotaDataPackage<T> dataPackage = this.makeDataPackage(chain);
                        this.commitDataPackageDelay(dataPackage);
                        this.finishOneChain(this.attSubject);
                        continue;
                    }
                    if (chain.isError()) {
                        this.errorOneChain(this.attSubject);
                        throw new QuotaException(TieEngineErrorCodes.getLineBreak(), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate()));
                    }
                    QuotaDataPackage<T> emptyDataPackage = this.makeEmptyDataPackage(chain);
                    this.commitDataPackageDelay(emptyDataPackage);
                    if (chain.isExclusion()) {
                        this.finishOneChain(this.attSubject);
                    }
                    this.lineExporter.alarm(QuotaMsgLevel.WARNING, TieEngineKDStrings.NULL_DATA_PACKAGE.loadKDString(new Object[]{WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate())}));
                }
            }
        }
        catch (Exception ex) {
            this.log.warn("QuotaEngine_error", (Throwable)ex);
            QuotaRunTimeCache runTimeCache = (QuotaRunTimeCache)this.initParams.get("QT_RUN_TIME_CACHE");
            QTRuntime runtime = runTimeCache.getRunTimeByAttFileBoId(attFileInfo.getAttFileBaseBoId());
            if (runtime != null) {
                runtime.discard();
            }
            attFileInfo.setLegal(Boolean.FALSE);
            String errorMsg = attFileInfo.getMessage();
            errorMsg = errorMsg == null ? ex.getMessage() : errorMsg + "\r\n" + ex.getMessage();
            attFileInfo.setMessage(errorMsg);
        }
        return hasRun;
    }

    private void runLineForDeductChain() throws QuotaException, InterruptedException {
        for (AttFileInfo attFileInfo : this.attSubject.getAttFileInfoList()) {
            if (!Boolean.TRUE.equals(attFileInfo.getLegal())) continue;
            this.attSubject.setStartDate(attFileInfo.getStartDate());
            this.attSubject.setCurrentChainAttFileInfo(attFileInfo);
            this.checkInterrupt();
            QuotaChainExecutor<T> chain = this.makeChain(this.attSubject);
            this.executeChain(chain);
            if (chain.isSuccess()) {
                QuotaDataPackage<T> dataPackage = this.makeDataPackage(chain);
                this.markBoEndAndCarryBoId(dataPackage, attFileInfo.getAttFileBaseBoId());
                this.commitDataPackageDelay(dataPackage);
                this.successFileBo.add(attFileInfo.getAttFileBaseBoId());
                this.finishOneChain(this.attSubject);
                continue;
            }
            if (chain.isError()) {
                this.errorOneChain(this.attSubject);
                String message = ErrorCodeUtils.getMessage((ErrorCode)TieEngineErrorCodes.getLineBreak(), (Object[])new Object[]{WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate())});
                attFileInfo.setLegal(Boolean.FALSE);
                String errorMsg = attFileInfo.getMessage();
                errorMsg = errorMsg == null ? message : errorMsg + "\r\n" + message;
                attFileInfo.setMessage(errorMsg);
                continue;
            }
            QuotaDataPackage<T> emptyDataPackage = this.makeEmptyDataPackage(chain);
            this.markBoEndAndCarryBoId(emptyDataPackage, attFileInfo.getAttFileBaseBoId());
            this.commitDataPackageDelay(emptyDataPackage);
            this.successFileBo.add(attFileInfo.getAttFileBaseBoId());
            if (chain.isExclusion()) {
                this.finishOneChain(this.attSubject);
            }
            this.lineExporter.alarm(QuotaMsgLevel.WARNING, TieEngineKDStrings.NULL_DATA_PACKAGE.loadKDString(new Object[]{WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate())}));
        }
    }

    private void carryQTRuntimeCache(QuotaDataPackage<T> dataPackage) {
        QuotaRunTimeCache runTimeCache = (QuotaRunTimeCache)this.initParams.get("QT_RUN_TIME_CACHE");
        dataPackage.setExtAttribute("ext_key_qt_runtime_cache", runTimeCache);
    }

    Map<String, Date> getCircleRestEndDate() {
        HashMap<String, Date> map = new HashMap<String, Date>();
        for (AttFileInfo attFileInfo : this.attSubject.getAttFileInfoList()) {
            if (!Boolean.TRUE.equals(attFileInfo.getLegal()) || null == attFileInfo.getTypeCircleMap() || attFileInfo.getTypeCircleMap().isEmpty()) continue;
            for (Map.Entry<Long, QuotaCycInfo> mapEntry : attFileInfo.getTypeCircleMap().entrySet()) {
                List<CircleRestVo> circleRestVoList = mapEntry.getValue().getRestVos();
                if (null == circleRestVoList || circleRestVoList.isEmpty()) continue;
                for (CircleRestVo restVo : circleRestVoList) {
                    String key = restVo.getCycSetId() + ":" + restVo.getIndex();
                    map.put(key, restVo.getEndDate());
                }
            }
        }
        return map;
    }

    private QuotaDataPackage<T> makeEmptyDataPackage(QuotaChainExecutor<T> chain) throws QuotaException {
        QuotaDataPackage<T> dataPackage = this.makeDataPackage(chain);
        dataPackage.setEmptyDataPackage(true);
        return dataPackage;
    }

    private boolean isCanChain(CircleRestVo restVo, Map<String, Date> map, Date startChainDate, Date endChainDate) {
        String key;
        Date nextBoEndDate;
        if (restVo.getStartDate().compareTo(endChainDate) > 0) {
            return false;
        }
        Date endDay = restVo.getEndDate();
        if (restVo.getNextCycSetId() != null && (nextBoEndDate = map.get(key = restVo.getNextCycSetId() + ":" + restVo.getNextIndex())) != null) {
            endDay = nextBoEndDate;
        }
        return endDay.compareTo(startChainDate) >= 0;
    }

    private void errorOneChain(AttPersonRange attSubjectEntry) throws QuotaException {
        try {
            this.lineExporter.errorOneChain(attSubjectEntry);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuotaException(e, TieEngineErrorCodes.getExporterLineErr(), attSubjectEntry.getCurrentChainAttFileInfo().getAttFileBaseBoId());
        }
    }

    private QuotaDataPackage<T> makeDataPackage(QuotaChainExecutor<T> chain) throws QuotaException {
        try {
            return chain.makeDataPackage();
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuotaException(e, TieEngineErrorCodes.getChainExecutorErr(), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate()));
        }
    }

    private void finishOneChain(AttPersonRange attSubjectEntry) throws QuotaException {
        try {
            this.lineExporter.finishOneChain(attSubjectEntry);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuotaException(e, TieEngineErrorCodes.getExporterErr(), attSubjectEntry.getCurrentChainAttFileInfo().getEndDate());
        }
    }

    private void commitDataPackageDelay(QuotaDataPackage<T> dataPackage) throws QuotaException {
        if (this.preDataPackage != null) {
            this.commitDataPackage(this.preDataPackage);
        }
        this.preDataPackage = dataPackage;
    }

    private void markBoEndAndCarryBoId(QuotaDataPackage<T> dataPackage, Long fileBo) {
        if (dataPackage != null) {
            dataPackage.mark(1);
            dataPackage.setExtAttribute("ext_key_line_one_bo", fileBo);
            this.log.debug("QuotaLineDefault markBoEndAndCarryBoId:{}", (Object)fileBo);
        }
    }

    private void commitLastDataPackage(Set<Long> runBo) throws QuotaException {
        if (this.preDataPackage != null) {
            this.preDataPackage.mark(2);
            this.preDataPackage.setExtAttribute("ext_key_line_all_bo", runBo);
            this.log.debug("QuotaLineDefault commitLastDataPackage:{}", runBo);
            this.commitDataPackage(this.preDataPackage);
            this.preDataPackage = null;
        }
    }

    private void commitDataPackage(QuotaDataPackage<T> dataPackage) throws QuotaException {
        try {
            this.carryQTRuntimeCache(dataPackage);
            this.dataPackageRouter.commit(dataPackage);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuotaException(e, TieEngineErrorCodes.getDrouterErr(), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)dataPackage.getChainDate()));
        }
    }

    private void executeChain(QuotaChainExecutor<T> chain) throws QuotaException {
        Span chainSpan = QTAccountModeHelper.isDeductChain((String)this.tieRequest.getAccountMode()) ? TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_CHAIN + "[" + chain.getAttSubjectEntry().getCurrentChainAttFileInfo().getAttFileBaseBoId() + "]")) : TaskTracer.newSpan((String)(CalcReportConstants.CALCULATE_CHAIN + "[" + WTCDateUtils.toLocalDate((Date)chain.getCircleRestVo().getStartDate()) + "," + WTCDateUtils.toLocalDate((Date)chain.getCircleRestVo().getEndDate()) + "]"));
        try {
            chain.execute();
            if (chain.getQuotaScheme() != null) {
                chainSpan.info(CalcReportConstants.CALCULATE_CHAIN_TIESCHEME, () -> chain.getQuotaScheme().getNumber());
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuotaException(e, TieEngineErrorCodes.getChainExecutorErr(), WTCInteDateUtil.formatLocalDateBySysTzAndUserFmt((LocalDate)chain.getChainDate()));
        }
        finally {
            chainSpan.info(CalcReportConstants.CALCULATE_CHAIN_RESULT, () -> chain.isSuccess() ? CalcReportConstants.RESULT_SUCCESS : CalcReportConstants.RESULT_FAILED);
            chainSpan.close();
        }
    }

    @Override
    public void stateChanged(QuotaState oldState, QuotaState newState) {
        this.lineExporter.stateChanged(oldState, newState);
        if (newState.isTerminating()) {
            if (this.dataPackageRouter instanceof QuotaTerminable) {
                ((QuotaTerminable)((Object)this.dataPackageRouter)).terminate();
            }
        } else if (newState.isDone()) {
            this.dataPackageRouter.close();
        }
    }

    @Override
    public void setQuotaRequest(QuotaRequest tieRequest) {
        this.tieRequest = tieRequest;
    }

    protected QuotaChainExecutor<T> makeChain(AttPersonRange attSubjectEntry) {
        AccountPlanData planData = (AccountPlanData)this.initParams.get("ACCOUNT_PLAN");
        TieScheme tieScheme = planData.getTieSchemeByDetailAndDate(WTCDateUtils.toLocalDate((Date)attSubjectEntry.getCurrentChainAttFileInfo().getEndDate()));
        QuotaChainExecutor chainExecutor = (QuotaChainExecutor)WTCAppContextHelper.getBean(QuotaChainExecutorStd.class);
        chainExecutor.setChainDate(WTCDateUtils.toLocalDate((Date)attSubjectEntry.getCurrentChainAttFileInfo().getEndDate()));
        chainExecutor.setEngineVariable(this.engineVariable);
        chainExecutor.setLineExporter(this.lineExporter);
        chainExecutor.setAttSubjectEntry(attSubjectEntry);
        chainExecutor.setLineVariable(this.lineVariable);
        chainExecutor.setQuotaRequest(this.tieRequest);
        chainExecutor.setQuotaScheme(tieScheme);
        chainExecutor.setDataNodeWrapper(this.dataNodeWrapper);
        chainExecutor.setIdService(this.idService);
        chainExecutor.setStepExecutorUnitFactory(this.stepExecutorUnitFactory);
        chainExecutor.setInitParams(this.initParams);
        return chainExecutor;
    }

    @Override
    public void setEngineVariable(Map<String, Object> engineVariable) {
        this.engineVariable = engineVariable;
    }

    @Override
    public void setQuotaSchemeService(ITieSchemeService tieSchemeService) {
    }

    @Override
    public void setAttSubject(AttPersonRange attSubject) {
        this.attSubject = attSubject;
    }

    @Override
    public AttPersonRange getAttSubject() {
        return this.attSubject;
    }

    @Override
    public void setLineExporter(IQuotaLineExporter lineExporter) {
        this.lineExporter = lineExporter;
    }

    @Override
    public void setDataPackageRouter(QuotaDataPackageRouter<T> dataPackageRouter) {
        this.dataPackageRouter = dataPackageRouter;
    }

    @Override
    public void setDataNodeWrapper(QuotaDataNodeWrapper<T> dataNodeWrapper) {
        this.dataNodeWrapper = dataNodeWrapper;
    }

    @Override
    public void setIdService(QuotaIdService idService) {
        this.idService = idService;
    }

    @Override
    public void setStepExecutorUnitFactory(QuotaStepExecutorUnitFactory<T> stepExecutorUnitFactory) {
        this.stepExecutorUnitFactory = stepExecutorUnitFactory;
    }

    @Override
    public void alarm(QuotaMsgLevel msgLevel, String msg) {
        this.lineExporter.alarm(msgLevel, msg);
    }

    @Override
    protected String getRunnerTag() {
        return this.tieRequest.getVersion() + ".P." + this.attSubject.getPersonId();
    }

    @Override
    protected void doRunAfter() {
    }

    @Override
    protected void beforeDoRun() {
    }

    @Override
    protected void afterRun() {
        boolean lineNotSuccess = !this.isSuccess();
        QuotaRunTimeCache runTimeCache = (QuotaRunTimeCache)this.initParams.get("QT_RUN_TIME_CACHE");
        for (AttFileInfo attFileInfo : this.attSubject.getAttFileInfoList()) {
            boolean curBoNotSuccess;
            QTRuntime runtime = runTimeCache.getRunTimeByAttFileBoId(attFileInfo.getAttFileBaseBoId());
            boolean bl = curBoNotSuccess = lineNotSuccess || !this.successFileBo.contains(attFileInfo.getAttFileBaseBoId());
            if (runtime == null || !curBoNotSuccess) continue;
            runtime.discard();
        }
        try {
            this.commitLastDataPackage(this.successFileBo);
        }
        catch (QuotaException e) {
            throw new WtesException((Throwable)e);
        }
    }

    @Override
    public void setInitParams(Map<String, Object> initParams) {
        this.initParams = initParams;
    }

    public QuotaValidatorExecutor getValidatorExecutor() {
        return this.validatorExecutor;
    }

    @Override
    public void setValidatorExecutor(QuotaValidatorExecutor validatorExecutor) {
        this.validatorExecutor = validatorExecutor;
    }

    @Override
    public QuotaDataPackageRouter<T> getDataPackageRouter() {
        return this.dataPackageRouter;
    }

    @Override
    protected void validate() throws WtesException {
        super.validate();
        this.validatorExecutor.validateLine(this.tieRequest, this.engineVariable, this.initParams, this.attSubject, this.lineVariable);
    }
}

