/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.executor.generate.QTQualificationsEvaluator;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTCarryOverLimitEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTCarryOverLimitEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverLimitEvaluator not found dataNodes"));
        }
        LinkedList<QuotaDataNode> quotaDataNodeList = new LinkedList<QuotaDataNode>();
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        ArrayList<QuotaAttItemValueStd> carryStds = new ArrayList<QuotaAttItemValueStd>(4);
        for (QuotaAttItemValueStd node : quotaAttStds) {
            QuotaAttItemInstance instance = node.getAttItemInstance();
            if (null == instance || null == instance.getQuotaAttItemType() || QuotaAttItemType.CARRYDOWN_DURATION != instance.getQuotaAttItemType() || !node.isLeaf()) continue;
            carryStds.add(node);
        }
        if (CollectionUtils.isEmpty(carryStds)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverLimitEvaluator not found carrydown AttItemInstance");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTCarryOverLimitEvaluator not found carrydown AttItemInstance"));
        }
        for (QuotaAttItemValueStd carryDown : carryStds) {
            this.processCarryOverLimit(carryDown, quotaDataNodeList, contextStd);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void processCarryOverLimit(QuotaAttItemValueStd carryDown, List<QuotaDataNode> quotaDataNodeList, QuotaContextStd contextStd) {
        QuotaAttItemInstance carryInstance = carryDown.getAttItemInstance();
        if (carryInstance == null) {
            return;
        }
        Date endDate = contextStd.getCircleRestVo().getEndDate();
        LocalDate localDate = contextStd.getChainDate();
        AttFileCabinet attFileCabinet = contextStd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        List<QTLineDetail> curQtDetails = new ArrayList(16);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)carryInstance.getQttypeId(), (long)carryInstance.getPeriodcircleId(), (long)contextStd.getCircleRestVo().getIndex().intValue());
        curQtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        curQtDetails.forEach(qtLineDetail -> {
            if (qtLineDetail.getBid() == carryInstance.getQtDetailId().longValue()) {
                qtLineDetail.setCarryDownedValue(carryInstance.getItemValue());
                qtLineDetail.setCarryDownedStart(carryInstance.getUseStartDate());
                qtLineDetail.setCarryDownedend(carryInstance.getUseEndDate());
                qtLineDetail.setVestType(carryInstance.getVestType());
            }
        });
        QTCalRule qtCalRule = (QTCalRule)carryDown.getMatchedRule();
        if (qtCalRule == null) {
            LOG.info("QTCarryOverLimitEvaluator not found qtCalRule");
            return;
        }
        if (qtCalRule.getCarryQualification() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTCarryOverLimitEvaluator not found qtQualification");
            }
            return;
        }
        LocalDate date = carryInstance.getOrgEndDay() == null ? contextStd.getChainDate() : carryInstance.getOrgEndDay();
        QTQualification qtQualification = (QTQualification)qtCalRule.getCarryQualification().getVersionByDate(date);
        if (qtQualification == null) {
            LOG.info("QTCarryOverLimitEvaluator not found qtQualification version");
            return;
        }
        QTQualificationsEvaluator evaluator = new QTQualificationsEvaluator();
        boolean parseCondition = evaluator.checkCondition(qtQualification, contextStd);
        if (parseCondition) {
            long qtDetailId = carryDown.getAttItemInstance().getQtDetailId();
            QuotaAttItemInstance instance = null;
            if (HRStringUtils.equals((String)qtQualification.getLimitMethod(), (String)"A")) {
                if (null != carryInstance && null != carryInstance.getItemValue() && null != carryInstance.getAttItemSpec()) {
                    BigDecimal amount = carryInstance.getItemValue().compareTo(qtQualification.getLimitQuatity()) > 0 ? qtQualification.getLimitQuatity() : carryInstance.getItemValue();
                    instance = new QuotaAttItemInstance(qtDetailId, carryInstance.getAttItemSpec(), amount, AttitemUnitEnum.of((String)carryInstance.getAttItemSpec().getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, carryInstance.getSource(), carryInstance.getQttypeId(), carryInstance.getPeriodcircleId(), carryInstance.getPeriodNum(), carryInstance.getPeriodAttribtion());
                    instance.setVestType(carryInstance.getVestType());
                    instance.setVestDay(carryInstance.getVestDay());
                    instance.setOrgEndDay(carryInstance.getOrgEndDay());
                    instance.setAttFileVId(carryInstance.getAttFileVId());
                    instance.setAttFileBoId(carryInstance.getAttFileBoId());
                }
            } else {
                BigDecimal amount = carryDown.getAttItemInstance().getItemValue().multiply(qtQualification.getLimitPercent()).multiply(BigDecimal.valueOf(0.01));
                QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(carryInstance.getOrgEndDay());
                long roundRuleId = null != qtGenConfig.getQtGenCfEntryByDetail(qtDetailId) ? qtGenConfig.getQtGenCfEntryByDetail(qtDetailId).getRoundRule() : 0L;
                BigDecimal roundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, amount);
                roundResult = roundResult.setScale(6, RoundingMode.HALF_UP);
                if (null != carryInstance && null != carryInstance.getAttItemSpec()) {
                    instance = new QuotaAttItemInstance(qtDetailId, carryInstance.getAttItemSpec(), roundResult, AttitemUnitEnum.of((String)carryInstance.getAttItemSpec().getUnit()), QuotaAttItemType.CARRYDOWN_DURATION, carryInstance.getSource(), carryInstance.getQttypeId(), carryInstance.getPeriodcircleId(), carryInstance.getPeriodNum(), carryInstance.getPeriodAttribtion());
                    instance.setVestType(carryInstance.getVestType());
                    instance.setVestDay(carryInstance.getVestDay());
                    instance.setOrgEndDay(carryInstance.getOrgEndDay());
                    instance.setAttFileVId(carryInstance.getAttFileVId());
                    instance.setAttFileBoId(carryInstance.getAttFileBoId());
                }
            }
            this.fillQtDetails(instance, curQtDetails, qtDetailId);
            QuotaAttItemValue quotaAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(instance)).matchedRule(carryDown.getMatchedRule())).parentDataNodes(Collections.singletonList(carryDown))).evaluationRule(EvaluationRuleModel.of(qtQualification.getId(), "wtp_qtqualification"))).build();
            if (null != carryInstance) {
                quotaAttItemValue.getAttItemInstance().setGenStartDate(carryInstance.getGenStartDate());
                quotaAttItemValue.getAttItemInstance().setGenEndDate(carryInstance.getGenEndDate());
                quotaAttItemValue.getAttItemInstance().setUseStartDate(carryInstance.getUseStartDate());
                quotaAttItemValue.getAttItemInstance().setUseEndDate(carryInstance.getUseEndDate());
                quotaAttItemValue.getAttItemInstance().setOrgEndDay(carryInstance.getOrgEndDay());
                quotaAttItemValue.getAttItemInstance().setAttFileBoId(carryInstance.getAttFileBoId());
                quotaAttItemValue.getAttItemInstance().setAttFileVId(carryInstance.getAttFileVId());
            }
            quotaDataNodeList.add(quotaAttItemValue);
        }
    }

    private void fillQtDetails(QuotaAttItemInstance instance, List<QTLineDetail> curQtDetails, long qtDetailId) {
        if (instance != null) {
            QuotaAttItemInstance finalCarryInstance = instance;
            curQtDetails.forEach(qtLineDetail -> {
                if (qtLineDetail.getBid() == qtDetailId && finalCarryInstance != null) {
                    qtLineDetail.setCarryDownedValue(finalCarryInstance.getItemValue());
                }
            });
        }
    }
}

