/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.wtc.wtes.business.qte.executor.CarryDwonType;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailCarryDwon;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTDepartCarryDown;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDepartVestDayEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDepartCarryOverEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTDepartCarryOverEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDepartCarryOverEvaluator not found dataNodes"));
        }
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        Date departDate = QuotaContextUtil.getDepartDate(context);
        if (departDate == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDepartCarryOverEvaluator not found depart day"));
        }
        List<QTLineDetail> qtDetails = QuotaContextUtil.getLineDetail(context);
        if (CollectionUtils.isEmpty(qtDetails)) {
            LOG.warn("QTDepartCarryOverEvaluator qtDetails is empty ");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDepartCarryOverEvaluator not qtlinedtail need Carry over"));
        }
        ArrayList needStds = new ArrayList();
        List availableStds = quotaAttStds.stream().filter(dataNode -> this.needCarryDownAttItem((QuotaAttItemValueStd)dataNode, QuotaAttItemType.AVAILABLE, qtDetails)).collect(Collectors.toList());
        needStds.addAll(availableStds);
        List overStds = quotaAttStds.stream().filter(dataNode -> this.needCarryDownAttItem((QuotaAttItemValueStd)dataNode, QuotaAttItemType.OVERDRAWN, qtDetails)).collect(Collectors.toList());
        needStds.addAll(overStds);
        List canBeOverStds = quotaAttStds.stream().filter(dataNode -> this.needCarryDownAttItem((QuotaAttItemValueStd)dataNode, QuotaAttItemType.OVERDRAW_AVAILABLE, qtDetails)).collect(Collectors.toList());
        needStds.addAll(canBeOverStds);
        List carryStds = quotaAttStds.stream().filter(dataNode -> this.needCarryDownAttItem((QuotaAttItemValueStd)dataNode, QuotaAttItemType.CARRYDOWN_DURATION, qtDetails)).collect(Collectors.toList());
        needStds.addAll(carryStds);
        if (CollectionUtils.isEmpty(needStds)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDepartCarryOverEvaluator not AttItem need Carry over"));
        }
        Map<Long, List<QuotaAttItemValueStd>> needStdMap = needStds.stream().collect(Collectors.groupingBy(std -> std.getAttItemInstance().getQtDetailId()));
        Date sysDate = WTCDateUtils.getDayBegin();
        ArrayList<QuotaAttItemValue> quotaDataNodeList = new ArrayList<QuotaAttItemValue>();
        Map qtLineDetailMap = qtDetails.stream().collect(Collectors.toMap(QTLineDetail::getBid, Function.identity(), (v1, v2) -> v2));
        if (sysDate.compareTo(departDate) >= 0) {
            for (Map.Entry<Long, List<QuotaAttItemValueStd>> entry : needStdMap.entrySet()) {
                if (entry.getKey() == null || CollectionUtils.isEmpty((Collection)entry.getValue()) || qtLineDetailMap.get(entry.getKey()) == null) continue;
                this.doCarryOverAttItem(quotaDataNodeList, context, entry.getValue(), (QTLineDetail)qtLineDetailMap.get(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(quotaDataNodeList)) {
            QteGenExtPluginUtils.afterDoEvalua(context, quotaDataNodeList, "carrydown", QTDepartCarryOverEvaluator::buildQuotaDetail);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private boolean needCarryDownAttItem(QuotaAttItemValueStd dataNode, QuotaAttItemType quotaAttItemType, List<QTLineDetail> qtDetails) {
        if (dataNode == null) {
            return false;
        }
        if (dataNode.getAttItemInstance() == null) {
            return false;
        }
        QTLineDetail qtLineDetail = qtDetails.stream().filter(qt -> qt.getBid() == dataNode.getAttItemInstance().getQtDetailId().longValue()).findFirst().orElse(null);
        if (qtLineDetail == null) {
            return false;
        }
        if (QuotaAttItemStatus.of(qtLineDetail.getBusstatus()) != QuotaAttItemStatus.EFFECT) {
            return false;
        }
        boolean avLeadNode = dataNode.isLeaf() && dataNode.getAttItemInstance().getQuotaAttItemType() == quotaAttItemType;
        boolean timeValueNoZero = BigDecimal.ZERO.compareTo(dataNode.getAttItemInstance().getItemValue()) != 0;
        String vestType = dataNode.getAttItemInstance().getVestType();
        boolean noBusinessOver = !VestTypeEnum.BUSINESS_AREA.getCode().equals(vestType);
        return avLeadNode && timeValueNoZero && noBusinessOver;
    }

    private void doCarryOverAttItem(List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd context, List<QuotaAttItemValueStd> stds, QTLineDetail qtLineDetail) {
        QuotaAttItemValueStd std = stds.get(0);
        QTCalRule qtCalRule = (QTCalRule)std.getMatchedRule();
        if (qtCalRule == null || qtCalRule.getCarryDown() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u7ed3\u8f6c\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(std.getAttItemInstance().getOrgEndDay());
        if (carryDown == null) {
            LOG.warn("QTDepartCarryOverEvaluator not found carryDown version");
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u7ed3\u8f6c\u89c4\u5219\u3002", (String)"QTCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        if (carryDown.getDepartCarryDown() == null || StringUtils.isEmpty((String)carryDown.getDepartCarryDown().getVestDayMethod())) {
            LOG.info("QTDepartCarryOverEvaluator info not found ");
            return;
        }
        BigDecimal departValue = BigDecimal.ZERO;
        for (QuotaAttItemValueStd quotaAttItemValueStd : stds) {
            QuotaAttItemInstance parentAttItemInstance = quotaAttItemValueStd.getAttItemInstance();
            BigDecimal value = parentAttItemInstance.getItemValue();
            if (QuotaAttItemType.OVERDRAWN == parentAttItemInstance.getQuotaAttItemType()) {
                value = value.negate();
            }
            QuotaAttItemValue subStds = quotaAttItemValueStd.unwrapAndCopy();
            subStds.getAttItemInstance().setItemValue(BigDecimal.ZERO);
            subStds.setParentDataNodes(Collections.singletonList(quotaAttItemValueStd));
            subStds.getEvaluationRule().clear();
            subStds.setEvaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"));
            subStds.setMatchedRule(std.getMatchedRule());
            if (QuotaAttItemType.OVERDRAWN == parentAttItemInstance.getQuotaAttItemType()) {
                qtLineDetail.setUseOdValue(BigDecimal.ZERO);
            } else if (QuotaAttItemType.AVAILABLE == parentAttItemInstance.getQuotaAttItemType()) {
                qtLineDetail.setUsableValue(BigDecimal.ZERO);
            } else if (QuotaAttItemType.CARRYDOWN_DURATION == parentAttItemInstance.getQuotaAttItemType()) {
                qtLineDetail.setCarryDownedValue(BigDecimal.ZERO);
            } else if (QuotaAttItemType.OVERDRAW_AVAILABLE == parentAttItemInstance.getQuotaAttItemType()) {
                qtLineDetail.setCanBeOdValue(BigDecimal.ZERO);
            }
            if (QuotaAttItemType.OVERDRAW_AVAILABLE == parentAttItemInstance.getQuotaAttItemType()) continue;
            departValue = departValue.add(value);
        }
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec itemSpec = attItemSpecData.getByBidAndDate(carryDown.getDepartCarryDown().getDepartAttItem(), context.getChainDate());
        QuotaAttItemValue departStd = std.unwrapAndCopy();
        departStd.getAttItemInstance().setItemValue(departValue);
        departStd.getAttItemInstance().setAttItemSpec(itemSpec);
        departStd.getAttItemInstance().setUntil(AttitemUnitEnum.of((String)itemSpec.getUnit()));
        departStd.getAttItemInstance().setQuotaAttItemType(QuotaAttItemType.QUIT_DEPART);
        departStd.setMatchedRule(std.getMatchedRule());
        departStd.getEvaluationRule().clear();
        departStd.setEvaluationRule(EvaluationRuleModel.of(carryDown.getId(), "wtp_qtcarrydown"));
        Date day = this.getVestDay(carryDown, context);
        if (day == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79bb\u804c\u7ed3\u8f6c\u7684\u5f52\u5c5e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QTDepartCarryOverEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        departStd.getAttItemInstance().setVestDay(WTCDateUtils.getZeroDate((Date)day));
        departStd.getAttItemInstance().setVestType(VestTypeEnum.DEPART.getCode());
        qtLineDetail.setDepartValue(departValue);
        qtLineDetail.setVestType(VestTypeEnum.DEPART.getCode());
        qtLineDetail.setCarryDownedValue(departValue);
        quotaDataNodeList.add(departStd);
    }

    private Date getVestDay(QTCarryDown carryDown, QuotaContextStd context) {
        Date vestDay = QuotaContextUtil.getDepartDate(context);
        QTDepartCarryDown departCarryDown = carryDown.getDepartCarryDown();
        String vestDayMethod = departCarryDown.getVestDayMethod();
        if (QTDepartVestDayEnum.QT_END_EMPLOYMENT.type.equals(vestDayMethod) && vestDay != null && departCarryDown.getDPDelay().booleanValue() && vestDay != null) {
            vestDay = QTFloatUnitEnum.NATURAL_DAY == departCarryDown.getVestDayFloatUnit() ? WTCDateUtils.addDays((Date)vestDay, (int)departCarryDown.getDepartCDDelay()) : WTCDateUtils.add((Date)vestDay, (int)2, (int)departCarryDown.getDepartCDDelay());
        }
        return vestDay;
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailCarryDwon quotaDetailCarryDwon = new QuotaDetailCarryDwon(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        quotaDetailCarryDwon.setCarryValue(qtLineDetail.getCarryDownedValue(), CarryDwonType.DEPART_CARRY, Boolean.FALSE.booleanValue());
        return quotaDetailCarryDwon;
    }
}

