/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.carryover.detailadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjust;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTExtensionDateEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTExtensionMethodEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailAdjustUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDetailExtensionEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTDetailExtensionEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (WTCCollections.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found dataNodes"));
        }
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        List<QuotaAttItemValueStd> enjoyAttStds = quotaAttStds.stream().filter(dt -> this.isEnjoy((QuotaAttItemValueStd)dt)).collect(Collectors.toList());
        List<QuotaAttItemValueStd> starAttStds = quotaAttStds.stream().filter(dt -> QuotaAttItemType.STANDARD == dt.getAttItemInstance().getQuotaAttItemType() && dt.isLeaf()).collect(Collectors.toList());
        if (WTCCollections.isEmpty(enjoyAttStds)) {
            LOG.error("QTDetailAdjustEvaluator not found enjoy dataNodes");
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy dataNodes"));
        }
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        QTDetailAdjustTable qtDetailAdjustTable = context.getInitParamMust("QT_DETAIL_EXTENSION", QTDetailAdjustTable.class);
        List<QTDetailAdjust> qtDetailAdjusts = qtDetailAdjustTable.getQtDetailAdjustByBid(attFileModel.getBid());
        if (WTCCollections.isEmpty(qtDetailAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDetailAdjustEvaluator not found QTDetailAdjust");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy QTDetailAdjust"));
        }
        HashMap<Long, List<QTDetailAdjust>> matchQTDetailAdjusts = new HashMap<Long, List<QTDetailAdjust>>();
        QuotaDetailAdjustUtils.matchQtDetailAdjust(matchQTDetailAdjusts, qtDetailAdjusts, enjoyAttStds, starAttStds, qtDetails);
        if (WTCCollections.isEmpty(matchQTDetailAdjusts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDetailAdjustEvaluator not found QTDetailAdjust");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTDetailAdjustEvaluator not found enjoy QTDetailAdjust"));
        }
        ArrayList<QuotaDataNode> quotaDataNodeList = new ArrayList<QuotaDataNode>();
        for (QuotaAttItemValueStd enjoyAttStd : enjoyAttStds) {
            this.doExtensionDetail(matchQTDetailAdjusts, quotaDataNodeList, enjoyAttStd, context);
        }
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void doExtensionDetail(Map<Long, List<QTDetailAdjust>> matchQTDetailAdjusts, List<QuotaDataNode> quotaDataNodeList, QuotaAttItemValueStd enjoyAttStd, QuotaContextStd context) {
        Long qtLineDetailId = enjoyAttStd.getAttItemInstance().getQtDetailId();
        List<QTDetailAdjust> qtDetailAdjusts = matchQTDetailAdjusts.get(qtLineDetailId);
        if (WTCCollections.isEmpty(qtDetailAdjusts)) {
            return;
        }
        qtDetailAdjusts = qtDetailAdjusts.stream().sorted(Comparator.comparing(QTDetailAdjust::getCreateTime)).collect(Collectors.toList());
        Date useStartDate = enjoyAttStd.getAttItemInstance().getUseStartDate();
        Date useStartLastDate = WTCDateUtils.getDayLastDate((Date)useStartDate);
        Date useEndDate = enjoyAttStd.getAttItemInstance().getUseEndDate();
        Date useEndLastDate = WTCDateUtils.getDayLastDate((Date)useEndDate);
        boolean isStartLastDay = WTCDateUtils.getEndDayOfMonth((Date)useStartDate).compareTo(useStartLastDate) == 0;
        boolean isEndLastDay = WTCDateUtils.getEndDayOfMonth((Date)useEndDate).compareTo(useEndLastDate) == 0;
        for (QTDetailAdjust qtDetailAdjust : qtDetailAdjusts) {
            Date afterEndDate = useEndDate;
            Date afterStartDate = useStartDate;
            if (QTExtensionDateEnum.EX_START_DATE.type.equals(qtDetailAdjust.getMdfyDate())) {
                afterStartDate = this.extensionDate(isStartLastDay, useStartDate, qtDetailAdjust.getMdfyMethod(), qtDetailAdjust.getDelayUnit(), qtDetailAdjust.getDelayValue());
            } else if (QTExtensionDateEnum.EX_END_DATE.type.equals(qtDetailAdjust.getMdfyDate())) {
                afterEndDate = this.extensionDate(isEndLastDay, useEndDate, qtDetailAdjust.getMdfyMethod(), qtDetailAdjust.getDelayUnit(), qtDetailAdjust.getDelayValue());
            }
            useStartDate = afterStartDate;
            useEndDate = afterEndDate;
        }
        Set<Long> evaluationRuleIds = qtDetailAdjusts.stream().map(QTDetailAdjust::getId).collect(Collectors.toSet());
        this.buildItem(enjoyAttStd, useStartDate, useEndDate, quotaDataNodeList, evaluationRuleIds);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)enjoyAttStd.getAttItemInstance().getQttypeId(), (long)enjoyAttStd.getAttItemInstance().getPeriodcircleId(), (long)enjoyAttStd.getAttItemInstance().getPeriodNum().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        for (QTLineDetail qt : qtDetails) {
            if (qt.getBid() != enjoyAttStd.getAttItemInstance().getQtDetailId().longValue()) continue;
            qt.setUseStartDate(useStartDate);
            qt.setUseEndDate(useEndDate);
        }
    }

    private Date extensionDate(boolean isLastday, Date refDate, String mdfyMethod, String delayUnit, BigDecimal delayValue) {
        int dateUnit;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(refDate);
        int n = dateUnit = QTFloatUnitEnum.NATURAL_DAY.type.equals(delayUnit) ? 5 : 2;
        if (QTExtensionMethodEnum.EX_METHOD_OLD.type.equals(mdfyMethod)) {
            delayValue = delayValue.negate();
            calendar.add(dateUnit, delayValue.intValue());
        } else if (QTExtensionMethodEnum.EX_METHOD_FUTURE.type.equals(mdfyMethod)) {
            calendar.add(dateUnit, delayValue.intValue());
        }
        if (isLastday && QTFloatUnitEnum.MOUTH.type.equals(delayUnit)) {
            return this.getEndDayOfMonth(calendar.getTime());
        }
        return calendar.getTime();
    }

    private Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int nowYear = HRDateTimeUtils.getYear((Date)date);
        int nowMonth = WTCDateUtils.getNowMonth((Date)date);
        calendar.set(nowYear, nowMonth - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(nowYear, nowMonth - 1, day);
        return calendar.getTime();
    }

    private boolean isEnjoy(QuotaAttItemValueStd dt) {
        boolean enjoyItem = QuotaAttItemType.DURATION_ENJOYMENT == dt.getAttItemInstance().getQuotaAttItemType();
        boolean sysAndManualItem = QuotaDetailType.CUR_PERIOD_GEN == dt.getAttItemInstance().getSource() || QuotaDetailType.MANUAL_GIVE == dt.getAttItemInstance().getSource() || QuotaDetailType.BO_SETTLEMENT == dt.getAttItemInstance().getSource();
        return enjoyItem && sysAndManualItem && dt.isLeaf();
    }

    private void buildItem(QuotaAttItemValueStd enjoyAttStd, Date useStartDate, Date useEndDate, List<QuotaDataNode> quotaDataNodeList, Set<Long> evaluationRuleIds) {
        QuotaAttItemInstance attItemInstance = enjoyAttStd.getAttItemInstance();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), attItemInstance.getItemValue(), attItemInstance.getUntil(), attItemInstance.getQuotaAttItemType(), attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion(), attItemInstance.getGenStartDate(), attItemInstance.getGenEndDate(), useStartDate, useEndDate, attItemInstance.getChangeSatrt(), attItemInstance.getChangeEnd());
        quotaAttItemInstance.setStatus(attItemInstance.getStatus());
        quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).appendParentDataNode(enjoyAttStd)).matchedRule(enjoyAttStd.getMatchedRule())).build();
        for (Long id : evaluationRuleIds) {
            attItemValue.setEvaluationRule(EvaluationRuleModel.of(id, "wtte_qtdetailextension"));
        }
        quotaDataNodeList.add(attItemValue);
    }
}

