/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.deduction;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.QTType;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaBillCalInfo;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtp.business.cumulate.trading.QTBillOuterService;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTBillEntryDeal;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTDeductEvaluatorHelper {
    private static final Log LOG = LogFactory.getLog(QTDeductEvaluatorHelper.class);

    public static QuotaDataResultStd evacuation(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        return QTDeductEvaluatorHelper.doDeduct(context, dataNodes, true);
    }

    public static QuotaDataResultStd deduct(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        return QTDeductEvaluatorHelper.doDeduct(context, dataNodes, false);
    }

    private static QuotaDataResultStd doDeduct(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes, boolean justEvacuation) {
        QTCalRule matchedRule;
        CircleRestVo circleRestVo = context.getCircleRestVo();
        if (circleRestVo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u671f\u95f4\u5faa\u73af\u3002", (String)"QTDurationDeductionEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        boolean isDyNoDetails = false;
        if (CollectionUtils.isEmpty(dataNodes)) {
            String rule;
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDeductEvaluatorHelper not found dataNodes");
            }
            isDyNoDetails = (matchedRule = (QTCalRule)context.getVariable(rule = "rule" + DetailLogicKey.getIndexKey((long)QuotaContextUtil.getAttFileModle(context).getBid(), (long)context.getQuotaTypeId(), (long)circleRestVo.getCycSetId(), (long)circleRestVo.getIndex().intValue()), VScope.LINE)) != null;
        } else {
            matchedRule = (QTCalRule)dataNodes.get(0).getMatchedRule();
        }
        if (matchedRule == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTDurationDeductionEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        List<QTLineDetail> applyRes = QTDeductEvaluatorHelper.evaluate(context, matchedRule, isDyNoDetails, justEvacuation);
        ArrayList resItemValue = Lists.newArrayListWithCapacity((int)10);
        if (WTCCollections.isEmpty(applyRes) || WTCCollections.isEmpty(dataNodes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDeductEvaluatorHelper \u6ca1\u6709\u8981\u5904\u7406\u7684\u660e\u7ec6");
            }
            return QuotaDataResultStd.success(resItemValue);
        }
        List<QuotaAttItemValueStd> allAttStd = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        resItemValue.addAll(QTDeductEvaluatorHelper.dealItemValue(context, allAttStd, matchedRule, applyRes));
        return QuotaDataResultStd.success(resItemValue);
    }

    private static List<QTLineDetail> evaluate(QuotaContextStd context, QTCalRule qtCalRule, boolean isDyNoDetails, boolean justEvacuation) {
        List qtLineDetails;
        TimeSeqAvailableBo<QTGenConfig> genConfigSeqBo = qtCalRule.getGenConfig();
        CircleRestVo circleRestVo = context.getCircleRestVo();
        LocalDate chainDate = context.getChainDate();
        QTGenConfig genConfigVersion = (QTGenConfig)genConfigSeqBo.getVersionByDate(chainDate);
        QTType qtType = genConfigVersion.getQtType();
        long cycSetId = genConfigVersion.getCycSet();
        QuotaRunTimeCache quotaRunTimeCache = (QuotaRunTimeCache)context.getInitParam("QT_RUN_TIME_CACHE");
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        long attFileBoId = attFileModel.getBid();
        AttRecordDetailHolder attRecordDetailHolder = (AttRecordDetailHolder)context.getInitParam("QT_ATT_RECORD_DETAIL");
        Integer index = circleRestVo.getIndex();
        long cycSetIndex = 0L;
        if (index != null) {
            cycSetIndex = index.intValue();
        }
        if (WTCCollections.isEmpty((Collection)(qtLineDetails = (List)context.getVariable(DetailLogicKey.getIndexKey((long)attFileBoId, (long)qtType.getId(), (long)cycSetId, (long)cycSetIndex), VScope.LINE))) && !isDyNoDetails) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTDurationDeductionEvaluator_qtLineDetails is emp");
            }
            return Collections.emptyList();
        }
        QTRuntime qtRuntime = quotaRunTimeCache.getRunTimeByAttFileBoId(attFileBoId);
        qtLineDetails = qtLineDetails == null ? Collections.emptyList() : qtLineDetails;
        HashSet needDelDetailLK = Sets.newHashSetWithExpectedSize((int)1);
        if (isDyNoDetails) {
            index = index == null ? Integer.valueOf(0) : index;
            DetailLogicKey detailLogicKey = new DetailLogicKey(attFileBoId, qtType.getId(), cycSetId, index.intValue());
            needDelDetailLK.add(detailLogicKey);
        }
        if (justEvacuation) {
            QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
            Set<Long> oldDBLineDetailId = qtPoolHolder.getOldDBLineDetailId(new DetailLogicKey(attFileBoId, qtType.getId(), cycSetId, (int)cycSetIndex));
            List<QTBillDeal> allBillDeal = attRecordDetailHolder.getBillInfo(attFileBoId, qtType.getId(), cycSetId, cycSetIndex);
            QTBillOuterService.evacuation(allBillDeal, (List)qtLineDetails, oldDBLineDetailId, (Set)needDelDetailLK, (QTRuntime)qtRuntime);
            return qtLineDetails;
        }
        QuotaBillCalInfo quotaBillCalInfo = (QuotaBillCalInfo)context.getInitParam("QT_BILL_CAL");
        List<BillApply> calcResult = quotaBillCalInfo.billCalListByAttFileBoId(attFileBoId);
        Set calResIds = calcResult.stream().map(BillApply::getId).collect(Collectors.toSet());
        List<QTBillDeal> billInfoOptional = attRecordDetailHolder.getBillInfo(attFileBoId, qtType.getId(), cycSetId, cycSetIndex);
        List frozenBill = billInfoOptional.stream().filter(qtBill -> !calResIds.contains(qtBill.getBillId())).filter(QTBillDeal::isFrozen).map(qtBillDeal -> {
            Date applyTime = qtBillDeal.getApplyTime();
            BillApply applyBill = attRecordDetailHolder.getBillApplyById(qtBillDeal.getBillId());
            if (applyBill != null) {
                if (applyTime != null) {
                    applyBill.setApplyTime(applyTime);
                }
                Map entryDealMap = qtBillDeal.getEntryDealList().stream().collect(Collectors.toMap(QTBillEntryDeal::getBillEntryId, Function.identity()));
                for (BillApplyEntry entry : applyBill.getEntryEntities()) {
                    QTBillEntryDeal qtBillEntryDeal = (QTBillEntryDeal)entryDealMap.get(entry.getEntryId());
                    if (null == qtBillEntryDeal) continue;
                    entry.setDeductionRuleId(qtBillEntryDeal.getDeductRuleId());
                }
            }
            return applyBill;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Set alteredSuccessBillId = calcResult.stream().map(BillApply::getParentId).collect(Collectors.toSet());
        frozenBill.removeIf(ele -> alteredSuccessBillId.contains(ele.getId()));
        HashSet existBillId = new HashSet(calResIds);
        existBillId.addAll(frozenBill.stream().map(BillApply::getId).collect(Collectors.toSet()));
        Set notExistBillId = billInfoOptional.stream().filter(billDeal -> !existBillId.contains(billDeal.getBillId())).collect(Collectors.toSet());
        if (!notExistBillId.isEmpty()) {
            LOG.warn("handleReqSemiAtom before: lack deduct info.detected some bill has billDeal, but can't obtain billInfo from BillCal or BillQuery. those bill Id is:{}", notExistBillId.stream().map(QTBillDeal::getBillId).collect(Collectors.toList()));
            LOG.warn("handleReqSemiAtom before: lack deduct info. billInfoOptional;{}", billInfoOptional);
            LOG.warn("handleReqSemiAtom before: lack deduct info. calcResult;{}", calcResult);
            LOG.warn("handleReqSemiAtom before: lack deduct info. frozenBill;{}", frozenBill);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("before handleReqSemiAtom. useBill:{}", calcResult.stream().map(BillApply::getBillNo).collect(Collectors.toList()));
            }
            QTBillOuterService.handleReqSemiAtom(calcResult, frozenBill, notExistBillId, (List)qtLineDetails, (Set)needDelDetailLK, (QTRuntime)qtRuntime);
            QTBillOuterService.amend((QTRuntime)qtRuntime, attRecordDetailHolder.getDetailLogicKeyListMap(attFileBoId));
        }
        catch (KDBizException exp) {
            String errCode;
            String string = errCode = exp.getErrorCode() == null ? "" : exp.getErrorCode().getCode();
            if ("bill_deduct_fail".equals(errCode)) {
                throw new WtesBizException(exp.getMessage());
            }
            throw exp;
        }
        return qtLineDetails;
    }

    private static List<QuotaAttItemValue> dealItemValue(QuotaContextStd context, List<QuotaAttItemValueStd> allAttStd, QTCalRule matchedRule, List<QTLineDetail> applyRes) {
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        CircleRestVo circleRestVo = context.getCircleRestVo();
        LocalDate chainDate = WTCDateUtils.toLocalDate((Date)circleRestVo.getEndDate());
        ArrayList resItemValue = Lists.newArrayListWithCapacity((int)10);
        List availableStd = allAttStd.stream().filter(dataNode -> dataNode.isLeaf() && QuotaAttItemType.AVAILABLE == dataNode.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        for (QTLineDetail applyRe : applyRes) {
            AttItemSpec useItemSpec;
            QTUseConfig useConfig;
            QuotaAttItemInstance attItemInstance;
            List availableParentNode = availableStd.stream().filter(std -> applyRe.getBid() == std.getAttItemInstance().getQtDetailId().longValue()).collect(Collectors.toList());
            QuotaAttItemValueStd attItemValue = (QuotaAttItemValueStd)availableParentNode.get(0);
            QTCalRule qTCalRule = matchedRule = attItemValue.getMatchedRule() != null ? (QTCalRule)attItemValue.getMatchedRule() : matchedRule;
            if (QTDeductEvaluatorHelper.isNonZero(applyRe.getFreezeValue()) || QTDeductEvaluatorHelper.isNonZero(applyRe.getUsedValue()) || QTDeductEvaluatorHelper.isNonZero(applyRe.getInvalidValue())) {
                QuotaAttItemValue quotaAttItemValue = ((QuotaAttItemValueStd)availableParentNode.get(0)).unwrapAndCopy();
                attItemInstance = quotaAttItemValue.getAttItemInstance();
                QTGenConfig genConfig = (QTGenConfig)matchedRule.getGenConfig().getVersionByDate(quotaAttItemValue.getAttItemInstance().getOrgEndDay());
                QTGenConfigEntry configEntry = genConfig.getQtGenCfEntryByDetail(applyRe.getBid());
                long usableAttItem = configEntry.getUsableAttItem();
                AttItemSpec itemSpec = attItemSpecData.getByBidAndDate(usableAttItem, chainDate);
                attItemInstance.setItemValue(applyRe.getUsableValue());
                attItemInstance.setAttItemSpec(itemSpec);
                attItemInstance.setUntil(AttitemUnitEnum.of((String)itemSpec.getUnit()));
                attItemInstance.setQuotaAttItemType(QuotaAttItemType.AVAILABLE);
                quotaAttItemValue.setParentDataNodes(availableParentNode.stream().map(QuotaDataNodeStd.class::cast).collect(Collectors.toList()));
                resItemValue.add(quotaAttItemValue);
            }
            if (QTDeductEvaluatorHelper.isNonZero(applyRe.getUsedValue())) {
                QuotaAttItemValue useItemValue = ((QuotaAttItemValueStd)availableParentNode.get(0)).unwrapAndCopy();
                attItemInstance = useItemValue.getAttItemInstance();
                useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(attItemInstance.getOrgEndDay());
                long useDuration = useConfig.getUseDuration();
                useItemSpec = attItemSpecData.getByBidAndDate(useDuration, chainDate);
                attItemInstance.setItemValue(applyRe.getUsedValue());
                attItemInstance.setAttItemSpec(useItemSpec);
                attItemInstance.setUntil(AttitemUnitEnum.of((String)useItemSpec.getUnit()));
                attItemInstance.setQuotaAttItemType(QuotaAttItemType.USING);
                useItemValue.setAttItemInstance(attItemInstance);
                resItemValue.add(useItemValue);
            }
            if (QTDeductEvaluatorHelper.isNonZero(applyRe.getInvalidValue())) {
                QuotaAttItemValue invalidItemValue = ((QuotaAttItemValueStd)availableParentNode.get(0)).unwrapAndCopy();
                attItemInstance = invalidItemValue.getAttItemInstance();
                useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(attItemInstance.getOrgEndDay());
                long invalidItemId = useConfig.getUseDuration();
                useItemSpec = attItemSpecData.getByBidAndDate(invalidItemId, chainDate);
                attItemInstance.setItemValue(applyRe.getInvalidValue());
                attItemInstance.setAttItemSpec(useItemSpec);
                attItemInstance.setUntil(AttitemUnitEnum.of((String)useItemSpec.getUnit()));
                attItemInstance.setQuotaAttItemType(QuotaAttItemType.INVALID_VALUE_ITEM);
                invalidItemValue.setAttItemInstance(attItemInstance);
                resItemValue.add(invalidItemValue);
            }
            if (!QTDeductEvaluatorHelper.isNonZero(applyRe.getFreezeValue())) continue;
            QuotaAttItemValue freezeItemValue = ((QuotaAttItemValueStd)availableParentNode.get(0)).unwrapAndCopy();
            attItemInstance = freezeItemValue.getAttItemInstance();
            useConfig = (QTUseConfig)matchedRule.getUseConfig().getVersionByDate(attItemInstance.getOrgEndDay());
            long freeze = useConfig.getFreeze();
            AttItemSpec itemSpec = attItemSpecData.getByBidAndDate(freeze, chainDate);
            attItemInstance.setItemValue(applyRe.getFreezeValue());
            attItemInstance.setAttItemSpec(itemSpec);
            attItemInstance.setUntil(AttitemUnitEnum.of((String)itemSpec.getUnit()));
            attItemInstance.setQuotaAttItemType(QuotaAttItemType.FREEZE);
            freezeItemValue.setAttItemInstance(attItemInstance);
            resItemValue.add(freezeItemValue);
        }
        return resItemValue;
    }

    private static boolean isNonZero(BigDecimal o1) {
        return null != o1 && BigDecimal.ZERO.compareTo(o1) != 0;
    }
}

