/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailUse;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTUseDateGenUtils;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTAvailableTimeEvaluator
implements QuotaEvaluatorStd {
    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u6570\u636e\u8282\u70b9\u3002", (String)"QTAvailableTimeEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        List<QuotaAttItemValueStd> quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(quotaAttStds = quotaAttStds.stream().filter(qt -> QuotaAttItemType.STANDARD == qt.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList()))) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u6807\u51c6\u6570\u636e\u8282\u70b9\u3002", (String)"QTAvailableTimeEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        LocalDate localDate = contextStd.getChainDate();
        AttFileCabinet attFileCabinet = contextStd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        ArrayList<QuotaAttItemValue> avAttItemValues = new ArrayList<QuotaAttItemValue>(quotaAttStds.size());
        AtomicBoolean useDateCheck = new AtomicBoolean(false);
        quotaAttStds.forEach(dt -> {
            QTCalRule qtCalRule = (QTCalRule)dt.getMatchedRule();
            if (qtCalRule == null || qtCalRule.getUseConfig() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u4f7f\u7528\u89c4\u5219\u3002", (String)"QTAvailableTimeEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            QTUseConfig qtUseConfig = (QTUseConfig)qtCalRule.getUseConfig().getVersionByDate(dt.getAttItemInstance().getOrgEndDay());
            QuotaAttItemInstance attItemInstance = dt.getAttItemInstance();
            Date useStartDate = null;
            Date useEndDate = null;
            Date genStartDate = attItemInstance.getGenStartDate();
            Date genEndDate = attItemInstance.getGenEndDate();
            String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)attItemInstance.getQttypeId(), (long)attItemInstance.getPeriodcircleId(), (long)attItemInstance.getPeriodNum().intValue());
            List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
            if (QuotaDetailType.BO_SETTLEMENT == attItemInstance.getSource()) {
                if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                    for (QTLineDetail qtLineDetail2 : qtDetails) {
                        if (qtLineDetail2.getBid() != attItemInstance.getQtDetailId().longValue()) continue;
                        useStartDate = qtLineDetail2.getUseStartDate();
                        useEndDate = qtLineDetail2.getUseEndDate();
                    }
                }
            } else {
                Map<String, Date> map = QTUseDateGenUtils.getUseDate(genStartDate, genEndDate, contextStd, qtCalRule);
                useStartDate = map.get("startDate");
                useEndDate = map.get("endDate");
            }
            if (null == useStartDate || null == useEndDate || useStartDate.after(useEndDate)) {
                useDateCheck.set(true);
                return;
            }
            QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), attItemInstance.getItemValue(), attItemInstance.getUntil(), attItemInstance.getQuotaAttItemType(), attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion());
            quotaAttItemInstance.setGenEndDate(genEndDate);
            quotaAttItemInstance.setGenStartDate(genStartDate);
            quotaAttItemInstance.setUseEndDate(useEndDate);
            quotaAttItemInstance.setUseStartDate(useStartDate);
            quotaAttItemInstance.setChangeEnd(attItemInstance.getChangeEnd());
            quotaAttItemInstance.setChangeSatrt(attItemInstance.getChangeSatrt());
            quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
            quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
            quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
            QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)((QuotaAttItemValue.Builder)QuotaAttItemValue.builder().appendParentDataNode((QuotaDataNodeStd)dt)).attItemInstance(quotaAttItemInstance)).build();
            attItemValue.setEvaluationRule(EvaluationRuleModel.of(qtUseConfig.getId(), "wtp_qtuseconfig"));
            attItemValue.setMatchedRule(dt.getMatchedRule());
            avAttItemValues.add(attItemValue);
            if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                Date finalUseEndDate = useEndDate;
                Date finalUseStartDate = useStartDate;
                qtDetails.forEach(qtLineDetail -> {
                    if (qtLineDetail.getBid() == attItemInstance.getQtDetailId().longValue()) {
                        qtLineDetail.setUseStartDate(finalUseStartDate);
                        qtLineDetail.setUseEndDate(finalUseEndDate);
                    }
                });
            }
        });
        if (useDateCheck.get()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u201d\u3002", (String)"QTAvailableTimeEvaluator_3", (String)"wtc-wtes-business", (Object[])new Object[0]), attFileModel.getNumber()));
        }
        QteGenExtPluginUtils.afterDoEvalua(contextStd, avAttItemValues, "usegen", QTAvailableTimeEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(avAttItemValues);
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailUse detailStandardGen = new QuotaDetailUse(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        return detailStandardGen;
    }
}

