/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailInOut;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.quotacal.detailadjust.QTDetailAdjustTable;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTInConvert;
import kd.wtc.wtes.business.model.rlqt.QTInConvertEntry;
import kd.wtc.wtes.business.model.rlqt.QTTurnOverConvert;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertMethodEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTGenTypeEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTDepartUtils;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTOnAndOffDutyEvaluator
implements QuotaEvaluatorStd {
    private static final int SACLE = 6;
    private static final String IN_PRE_KEY = "in_";
    private static final String OUT_PRE_KEY = "out_";

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getDataNodesOfPrevStepExecutor());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, ResManager.loadKDString((String)"\u6ca1\u6709\u4eab\u6709\u65f6\u957f\u751f\u6210\u3002", (String)"QTOnAndOffDutyEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        LocalDate localDate = context.getChainDate();
        List quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        List<QuotaAttItemValueStd> durationItems = quotaAttStds.stream().filter(qt -> qt.isLeaf() && QuotaAttItemType.STANDARD == qt.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(durationItems)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u6807\u51c6\u65f6\u957f\u751f\u6210\u3002", (String)"QTOnAndOffDutyEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        QTDetailAdjustTable qtDetailAdjustTable = (QTDetailAdjustTable)context.getInitParam("QT_DETAIL_ADJUST");
        HashMap convertMap = new HashMap();
        HashMap isConvertMap = new HashMap();
        ArrayList<QuotaAttItemValue> avAttItemValues = new ArrayList<QuotaAttItemValue>(durationItems.size());
        durationItems.forEach(dt -> {
            String outKey;
            QTCalRule qtCalRule = (QTCalRule)dt.getMatchedRule();
            if (qtCalRule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTOnAndOffDutyEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            QTInConvert qtInConvert = qtCalRule.getInconVersion();
            QTTurnOverConvert qtTurnOverConvet = qtCalRule.getTurnOverConversion();
            QuotaAttItemInstance attItemInstance = dt.getAttItemInstance();
            QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(dt.getAttItemInstance().getOrgEndDay());
            QTGenConfigEntry qtGenConfigEntry = genConfig.getQtGenCfEntryByDetail(attItemInstance.getQtDetailId());
            boolean roundTag = QTGenTypeEnum.GEN_FIX == genConfig.getQtType().getqTGenTypeEnum();
            BigDecimal itemValue = attItemInstance.getItemValue();
            QuotaAttItemValue tmpAttItemValue = this.buildQuotaAttItemValue((QuotaAttItemValueStd)dt, itemValue, qtGenConfigEntry, attItemSpecData, context.getChainDate());
            String inKey = IN_PRE_KEY + qtCalRule.getId();
            if (!isConvertMap.containsKey(inKey)) {
                this.getQtInConvert(qtInConvert, qtCalRule, context, convertMap, isConvertMap, attFileModel);
            }
            BigDecimal finalFactor = (BigDecimal)convertMap.get(inKey);
            if (((Boolean)isConvertMap.get(inKey)).booleanValue() && finalFactor != null) {
                itemValue = itemValue.multiply(finalFactor);
                if (BigDecimal.ZERO.compareTo(qtInConvert.getConvertFactor()) > 0 && QTConvertTypeEnum.ALL_PERIOD == qtInConvert.getConvertType()) {
                    itemValue = itemValue.multiply(qtInConvert.getConvertFactor());
                }
                tmpAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtInConvert.getId(), "wtp_qtinconversion"));
            }
            if (!isConvertMap.containsKey(outKey = OUT_PRE_KEY + qtCalRule.getId())) {
                QTDepartUtils.getQTThurnOverConvert(qtCalRule, context, qtTurnOverConvet, convertMap, isConvertMap);
            }
            BigDecimal finalThurnFactor = (BigDecimal)convertMap.get(outKey);
            boolean dpConvert = false;
            if (qtDetailAdjustTable.getDetailConvertById() != null && qtDetailAdjustTable.getDetailConvertById().get(attItemInstance.getQtDetailId()) != null) {
                dpConvert = qtDetailAdjustTable.getDetailConvertById().get(attItemInstance.getQtDetailId());
            } else {
                String ruleKey = this.getRuleKey(attItemInstance);
                if (qtDetailAdjustTable.getDetailConvertByRule() != null) {
                    Boolean convertTag = qtDetailAdjustTable.getDetailConvertByRule().get(ruleKey);
                    boolean bl = dpConvert = convertTag != null ? convertTag : false;
                }
            }
            if (((Boolean)isConvertMap.get(outKey)).booleanValue() && finalThurnFactor != null && !dpConvert) {
                itemValue = itemValue.multiply(finalThurnFactor);
                if (BigDecimal.ZERO.compareTo(qtTurnOverConvet.getSafActor()) > 0 && QTConvertMethodEnum.CONVERT_LEAVE_DAY != qtTurnOverConvet.getConvertMethod()) {
                    itemValue = itemValue.multiply(qtTurnOverConvet.getSafActor());
                }
                tmpAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtTurnOverConvet.getId(), "wtp_qtturnoverconver"));
            }
            if (roundTag && (((Boolean)isConvertMap.get(inKey)).booleanValue() || ((Boolean)isConvertMap.get(outKey)).booleanValue()) && qtGenConfigEntry.getRoundRule() != 0L) {
                itemValue = QuotaContextUtil.roundValue(context, qtGenConfigEntry.getRoundRule(), itemValue);
                tmpAttItemValue.setEvaluationRule(EvaluationRuleModel.of(qtGenConfigEntry.getRoundRule(), "wtbd_roundrule"));
            }
            tmpAttItemValue.getAttItemInstance().setItemValue(itemValue);
            QuotaAttItemValue starQuotaItemValue = dt.unwrapAndCopy();
            starQuotaItemValue.setMatchedRule(dt.getMatchedRule());
            starQuotaItemValue.setParentDataNodes(Collections.singletonList(dt));
            avAttItemValues.add(tmpAttItemValue);
            avAttItemValues.add(starQuotaItemValue);
            String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)attItemInstance.getQttypeId(), (long)attItemInstance.getPeriodcircleId(), (long)attItemInstance.getPeriodNum().intValue());
            List qtDetails = (List)context.getVariable(key, VScope.LINE);
            if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                BigDecimal finalItemValue = itemValue;
                for (QTLineDetail qtLineDetail : qtDetails) {
                    if (qtLineDetail.getBid() != attItemInstance.getQtDetailId().longValue()) continue;
                    qtLineDetail.setOwnValue(finalItemValue);
                    qtLineDetail.setDpConvert(dpConvert);
                }
            }
        });
        QteGenExtPluginUtils.afterDoEvalua(context, avAttItemValues, "in_out", QTOnAndOffDutyEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(avAttItemValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getQtInConvert(QTInConvert qtInConvert, QTCalRule qtCalRule, QuotaContextStd context, Map<String, BigDecimal> convertMap, Map<String, Boolean> isConvertMap, AttFileModel attFileModel) {
        Date endDate = context.getCircleRestVo().getEndDate();
        Date startDate = context.getCircleRestVo().getStartDate();
        Date startDay = QuotaContextUtil.getBoStartDay(context);
        startDay = startDay.compareTo(startDate) >= 0 ? startDay : startDate;
        Date endDay = WTCDateUtils.toDate((LocalDate)context.getChainDate());
        Boolean inConvertTag = Boolean.FALSE;
        String key = IN_PRE_KEY + qtCalRule.getId();
        if (qtInConvert != null) {
            BigDecimal factor = BigDecimal.ONE;
            Date inConvertDate = QuotaContextUtil.getJoinDate(context);
            if (inConvertDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5165\u804c\u65e5\u671f\u3002", (String)"QTOnAndOffDutyEvaluator_4", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            Calendar inCalendar = Calendar.getInstance();
            inCalendar.setTime(inConvertDate);
            if (inConvertDate.compareTo(endDay) <= 0 && inConvertDate.compareTo(startDay) >= 0) {
                if (QTConvertMethodEnum.CONVERT_OTHER_DAY == qtInConvert.getConvertMethod()) {
                    AttPeriodTable attPeriodTable = (AttPeriodTable)context.getInitParam("ATT_PERIOD");
                    List<AttPeriodModel> attPeriods = attPeriodTable.getAttPeriodList(attFileModel.getBid());
                    if (CollectionUtils.isEmpty(attPeriods)) throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5165\u804c\u6298\u7b97\u201d\u7c7b\u578b\u4e3a\u6309\u8003\u52e4\u671f\u95f4\u6298\u7b97\uff0c\u8003\u52e4\u6863\u6848\u4e0b\u672a\u914d\u7f6e\u201c\u8003\u52e4\u671f\u95f4\u201d\uff0c\u8bf7\u524d\u5f80\u201c\u8003\u52e4\u6863\u6848\u201d\u6267\u884c\u201c\u8003\u52e4\u671f\u95f4\u201d\u7684\u914d\u7f6e\u3002", (String)"QTOnAndOffDutyEvaluator_5", (String)"wtc-wtes-business", (Object[])new Object[0]));
                    List needAttPeriods = attPeriods.stream().filter(attPeriod -> attPeriod.getEndDate().compareTo(startDate) >= 0 && attPeriod.getStartDate().compareTo(endDate) <= 0).sorted(Comparator.comparing(AttPeriodModel::getStartDate)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(needAttPeriods)) {
                        QTConvertTypeEnum qtConvertTypeEnum = qtInConvert.getConvertType();
                        int periodMonth = needAttPeriods.size();
                        Date finalInConvertDate = inConvertDate;
                        List bfInAttPeriods = needAttPeriods.stream().filter(attPeriod -> attPeriod.getEndDate().before(finalInConvertDate)).collect(Collectors.toList());
                        int inCverMonth = bfInAttPeriods.size();
                        factor = this.getMonthAndPeriodFactor(qtConvertTypeEnum, inCalendar, periodMonth, inCverMonth, qtInConvert);
                    }
                } else {
                    factor = this.getInConvertFactor(qtInConvert, inConvertDate, startDate, endDate);
                }
                inConvertTag = Boolean.TRUE;
            }
            convertMap.put(key, factor);
        }
        isConvertMap.put(key, inConvertTag);
    }

    private QuotaAttItemValue buildQuotaAttItemValue(QuotaAttItemValueStd dt, BigDecimal itemValue, QTGenConfigEntry qtGenConfigEntry, AttItemSpecData attItemSpecData, LocalDate localDate) {
        QuotaAttItemInstance attItemInstance = dt.getAttItemInstance();
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getEnjoyAttItem(), localDate);
        Date genStartDate = attItemInstance.getGenStartDate();
        Date genEndDate = attItemInstance.getGenEndDate();
        Date useEndDate = attItemInstance.getUseEndDate();
        Date useStartDate = attItemInstance.getUseStartDate();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemSpec, itemValue, AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.DURATION_ENJOYMENT, attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion());
        quotaAttItemInstance.setGenEndDate(genEndDate);
        quotaAttItemInstance.setGenStartDate(genStartDate);
        quotaAttItemInstance.setUseEndDate(useEndDate);
        quotaAttItemInstance.setUseStartDate(useStartDate);
        quotaAttItemInstance.setChangeEnd(attItemInstance.getChangeEnd());
        quotaAttItemInstance.setChangeSatrt(attItemInstance.getChangeSatrt());
        quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)((QuotaAttItemValue.Builder)QuotaAttItemValue.builder().appendParentDataNode(dt)).attItemInstance(quotaAttItemInstance)).build();
        attItemValue.setMatchedRule(dt.getMatchedRule());
        return attItemValue;
    }

    private BigDecimal getInConvertFactor(QTInConvert qtInConvert, Date inConvertDate, Date startDate, Date endDate) {
        BigDecimal factor = null;
        switch (qtInConvert.getConvertMethod()) {
            case CONVERT_ALL: {
                factor = BigDecimal.ONE;
                break;
            }
            case CONVERT_LAST_WORK_DAY: {
                BigDecimal betweenDay = BigDecimal.valueOf(WTCDateUtils.daysBetween((Date)inConvertDate, (Date)endDate) + 1);
                BigDecimal periodDay = BigDecimal.valueOf(WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1);
                factor = betweenDay.divide(periodDay, 6, RoundingMode.HALF_UP);
                break;
            }
            case CONVERT_LEAVE_DAY: {
                QTConvertTypeEnum qtConvertTypeEnum = qtInConvert.getConvertType();
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(endDate);
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(startDate);
                Calendar inCoverCalendar = Calendar.getInstance();
                inCoverCalendar.setTime(inConvertDate);
                int periodYear = endCalendar.get(1) - startCalendar.get(1);
                int periodMonth = periodYear * 12 + endCalendar.get(2) - startCalendar.get(2) + 1;
                int inCverYear = inCoverCalendar.get(1) - startCalendar.get(1);
                int inCverMonth = inCverYear * 12 + inCoverCalendar.get(2) - startCalendar.get(2);
                factor = this.getMonthAndPeriodFactor(qtConvertTypeEnum, inCoverCalendar, periodMonth, inCverMonth, qtInConvert);
            }
        }
        return factor;
    }

    private BigDecimal getMonthAndPeriodFactor(QTConvertTypeEnum qtConvertTypeEnum, Calendar inCoverCalendar, int periodMonth, int inCverMonth, QTInConvert qtInConvert) {
        BigDecimal factor = null;
        if (QTConvertTypeEnum.ALL_PERIOD == qtConvertTypeEnum) {
            factor = BigDecimal.valueOf(periodMonth - inCverMonth).divide(BigDecimal.valueOf(periodMonth), 6, RoundingMode.HALF_UP);
        } else {
            List<QTInConvertEntry> qtInConvertEntries = qtInConvert.getInConvertEntries();
            BigDecimal losePerop = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(qtInConvertEntries)) {
                qtInConvertEntries = qtInConvertEntries.stream().sorted(Comparator.comparing(qt -> Integer.valueOf(qt.getEndDate()))).collect(Collectors.toList());
                int incverDay = inCoverCalendar.get(5);
                for (QTInConvertEntry qtInConvertEntry : qtInConvertEntries) {
                    if (Integer.valueOf(qtInConvertEntry.getStartDate()).compareTo(incverDay) > 0 || Integer.valueOf(qtInConvertEntry.getEndDate()).compareTo(incverDay) < 0) continue;
                    losePerop = qtInConvertEntry.getProportion().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtInConvertEntry.getProportion().divide(BigDecimal.valueOf(100L), 6, RoundingMode.HALF_UP);
                    break;
                }
                factor = BigDecimal.valueOf(periodMonth - (inCverMonth + 1)).add(losePerop).divide(BigDecimal.valueOf(periodMonth), 6, RoundingMode.HALF_UP);
            }
        }
        return factor;
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailInOut detailStandardGen = new QuotaDetailInOut(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        return detailStandardGen;
    }

    private String getRuleKey(QuotaAttItemInstance attItemInstance) {
        String crossDayStr = "";
        if (attItemInstance.getChangeEnd() != null) {
            crossDayStr = WTCDateUtils.date2Str((Date)attItemInstance.getChangeEnd(), (String)"yyyy.mm.dd");
        }
        String key = attItemInstance.getAttFileBoId() + "_" + attItemInstance.getQttypeId() + "_" + attItemInstance.getPeriodcircleId() + "_" + attItemInstance.getPeriodNum();
        key = StringUtils.isEmpty((CharSequence)crossDayStr) ? key : key + "_" + crossDayStr;
        return key;
    }
}

