/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTPoolHolder;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCrossMangOrgEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOffsetSeqEnum;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemStatus;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.QuotaDetailClearUtils;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTPrePeriodDetailsEvaluator
implements QuotaEvaluatorStd {
    private static final Log logger = LogFactory.getLog(QTPrePeriodDetailsEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        List<Object> quotaAttStds = new ArrayList(16);
        if (!CollectionUtils.isEmpty(dataNodes)) {
            quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
            quotaAttStds = quotaAttStds.stream().filter(dataNode -> dataNode.isLeaf() && QuotaAttItemType.DURATION_ENJOYMENT == dataNode.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList());
        }
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        CircleRestVo circleRestVo = context.getCircleRestVo();
        if (circleRestVo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u671f\u95f4\u5faa\u73af\u914d\u3002", (String)"QTPrePeriodDetailsEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        int periodNum = circleRestVo.getIndex();
        long cycSet = circleRestVo.getCycSetId();
        Long qtTypeId = context.getQuotaTypeId();
        LocalDate localDate = context.getChainDate();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)qtTypeId, (long)cycSet, (long)periodNum);
        QTGenConfigEntry qtGenConfigEntry = null;
        QTGenConfig firstQtGenConfig = null;
        QTCalRule firstQtCalRule = null;
        if (!CollectionUtils.isEmpty(quotaAttStds)) {
            firstQtCalRule = (QTCalRule)((QuotaAttItemValueStd)quotaAttStds.get(0)).getMatchedRule();
            firstQtGenConfig = (QTGenConfig)firstQtCalRule.getGenConfig().getVersionByDate(((QuotaAttItemValueStd)quotaAttStds.get(0)).getAttItemInstance().getOrgEndDay());
            qtGenConfigEntry = firstQtGenConfig.getQtGenCfEntryByDetail(((QuotaAttItemValueStd)quotaAttStds.get(0)).getAttItemInstance().getQtDetailId());
        } else {
            String rule = "rule" + key;
            String configEntry = "configEntry" + key;
            firstQtCalRule = (QTCalRule)context.getVariable(rule, VScope.LINE);
            if (firstQtCalRule != null) {
                firstQtGenConfig = (QTGenConfig)firstQtCalRule.getGenConfig().getVersionByDate(localDate);
            }
            qtGenConfigEntry = (QTGenConfigEntry)context.getVariable(configEntry, VScope.LINE);
        }
        if (firstQtCalRule == null || firstQtGenConfig == null || qtGenConfigEntry == null) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTPrePeriodDetailsEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getEnjoyAttItem(), localDate);
        ArrayList<QuotaAttItemValue> avAttItemValues = new ArrayList<QuotaAttItemValue>(16);
        ArrayList<QuotaAttItemValue> emjoyAttItemValues = new ArrayList<QuotaAttItemValue>(16);
        ArrayList<QTLineDetail> currLineDetails = new ArrayList<QTLineDetail>(16);
        ArrayList<QTLineDetail> preLineDetails = new ArrayList<QTLineDetail>(16);
        ArrayList<QTLineDetail> qtLineDetails = (ArrayList<QTLineDetail>)context.getVariable(key, VScope.LINE);
        if (CollectionUtils.isEmpty((Collection)qtLineDetails)) {
            qtLineDetails = new ArrayList<QTLineDetail>(16);
            context.setVariable(key, qtLineDetails, VScope.LINE);
        }
        List preQtLineDetails = new ArrayList(16);
        boolean isNoFirstPeriodNum = false;
        Date boStartDate = WTCDateUtils.toDate((LocalDate)attFileModel.getStartDate());
        if (periodNum > 1) {
            String preKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)firstQtGenConfig.getQtType().getId(), (long)firstQtGenConfig.getCycSet(), (long)(periodNum - 1));
            preQtLineDetails = (List)context.getVariable(preKey, VScope.LINE);
            String preRule = "rule" + preKey;
            isNoFirstPeriodNum = !CollectionUtils.isEmpty(preQtLineDetails) || context.containsVariable(preRule, VScope.LINE);
        }
        Long attFileBoId = attFileModel.getBid();
        QTPoolHolder qtPoolHolder = context.getInitParamMust("QT_POOL", QTPoolHolder.class);
        if (qtPoolHolder != null && !isNoFirstPeriodNum) {
            List boDetails;
            List<QTLineDetail> preDetails = qtPoolHolder.getQtPoolByFileBoId(attFileBoId, periodNum - 1, qtTypeId);
            List details = preDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getCarryDownedValue()) != 0).filter(detail -> QuotaAttItemStatus.EFFECT.getCode().equals(detail.getBusstatus())).filter(detail -> !VestTypeEnum.BUSINESS_AREA.getCode().equals(detail.getVestType()) && !VestTypeEnum.DEPART.getCode().equals(detail.getVestType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(details)) {
                currLineDetails.addAll(details);
            }
            if (!CollectionUtils.isEmpty(boDetails = preDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getCarryDownedValue()) != 0).filter(detail -> QuotaAttItemStatus.LOSE_EFFECT.getCode().equals(detail.getBusstatus())).filter(detail -> QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(detail.getSource())).collect(Collectors.toList()))) {
                currLineDetails.addAll(boDetails);
            } else if (boStartDate.compareTo(circleRestVo.getStartDate()) == 0) {
                this.getPreDetailsByBo(currLineDetails, attFileCabinet, firstQtGenConfig, qtPoolHolder, context, boStartDate);
            }
            List useOdDetails = preDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getUseOdValue().subtract(detail.getBalanceUseOdValue())) < 0).filter(detail -> QuotaAttItemStatus.EFFECT.getCode().equals(detail.getBusstatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(useOdDetails)) {
                preLineDetails.addAll(useOdDetails);
            }
        }
        if (isNoFirstPeriodNum && !CollectionUtils.isEmpty(preQtLineDetails)) {
            currLineDetails.addAll(preQtLineDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getCarryDownedValue()) != 0).filter(detail -> QuotaAttItemStatus.EFFECT.getCode().equals(detail.getBusstatus())).filter(detail -> !VestTypeEnum.BUSINESS_AREA.getCode().equals(detail.getVestType()) && !VestTypeEnum.DEPART.getCode().equals(detail.getVestType())).collect(Collectors.toList()));
            currLineDetails.addAll(preQtLineDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getCarryDownedValue()) != 0).filter(detail -> QuotaAttItemStatus.LOSE_EFFECT.getCode().equals(detail.getBusstatus())).filter(detail -> QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(detail.getSource())).collect(Collectors.toList()));
            preLineDetails.addAll(preQtLineDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getUseOdValue().subtract(detail.getBalanceUseOdValue())) < 0).filter(detail -> QuotaAttItemStatus.EFFECT.getCode().equals(detail.getBusstatus())).collect(Collectors.toList()));
        }
        ArrayList<QuotaAttItemValue> burdenList = new ArrayList<QuotaAttItemValue>(16);
        AttItemSpec avAttItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getUsableAttItem(), localDate);
        if (!CollectionUtils.isEmpty(currLineDetails)) {
            Map<Long, QTLineDetail> oldQtLineDetailMap = this.getOldQtlineDetails(qtPoolHolder, QuotaDetailType.PRE_PERIOD_CARRY_DOWN.getCode(), attFileBoId, periodNum, qtTypeId);
            long[] ids = IDService.get().genLongIds(currLineDetails.size());
            for (int index = 0; index < currLineDetails.size(); ++index) {
                QTLineDetail qtLineDetail = (QTLineDetail)currLineDetails.get(index);
                QTLineDetail qtDetail = oldQtLineDetailMap.get(qtLineDetail.getBid());
                qtDetail = qtDetail == null ? new QTLineDetail() : qtDetail;
                Date createTime = qtDetail.getCreateTime();
                if (createTime == null) {
                    qtDetail.setCreateTime(new Date());
                }
                qtDetail.rememberOriginalId();
                QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtDetail);
                qtDetail.setDetailSourceId(qtLineDetail.getBid());
                qtDetail.setId(ids[index]);
                qtDetail.setAttFileBoId(attFileModel.getBid());
                qtDetail.setOrgId(attFileModel.getOrgId().longValue());
                qtDetail.setAttFileVid(attFileModel.getId());
                qtDetail.setQtTypeId(qtLineDetail.getQtTypeId());
                qtDetail.setpCycleId(firstQtGenConfig.getCycSet());
                qtDetail.setPeriodNum(periodNum);
                qtDetail.setSource(QuotaDetailType.PRE_PERIOD_CARRY_DOWN.getCode());
                qtDetail.setGenStartDate(qtLineDetail.getGenStartDate());
                qtDetail.setGenEndDate(qtLineDetail.getGenEndDate());
                Date useStartDate = QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(qtLineDetail.getSource()) ? qtLineDetail.getUseStartDate() : qtLineDetail.getCarryDownedStart();
                qtDetail.setUseStartDate(useStartDate);
                Date useEndDate = QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(qtLineDetail.getSource()) ? qtLineDetail.getUseEndDate() : qtLineDetail.getCarryDownedend();
                qtDetail.setUseEndDate(useEndDate);
                qtDetail.setGenValue(qtLineDetail.getCarryDownedValue());
                qtDetail.setOwnValue(qtLineDetail.getCarryDownedValue());
                qtDetail.setUsableValue(qtLineDetail.getCarryDownedValue());
                QTGenConfigEntry preEntry = firstQtGenConfig.getQtGenCfEntryByDetail(qtLineDetail.getBid());
                preEntry = preEntry == null ? qtGenConfigEntry : preEntry;
                firstQtGenConfig.putQtGenCfEntryByDetail(qtDetail.getBid(), preEntry);
                AttItemSpec carryDownAttItem = attItemSpecData.getByBidAndDate(preEntry.getEnjoyAttItem(), localDate);
                QuotaAttItemValue attItemValue = this.buidAttItem(carryDownAttItem, qtDetail, context, firstQtCalRule, firstQtGenConfig.getCycSet());
                attItemValue.setMatchedRule(firstQtCalRule);
                QuotaAttItemValue avAttItemValue = this.buildAvailableAttItem(attItemValue, firstQtCalRule, avAttItemSpec);
                qtLineDetails.add(qtDetail);
                avAttItemValues.add(avAttItemValue);
                emjoyAttItemValues.add(attItemValue);
            }
        }
        quotaAttStds.forEach(dt -> {
            QTCalRule curQtCalRule = (QTCalRule)dt.getMatchedRule();
            QTGenConfig curQtGenConfig = (QTGenConfig)curQtCalRule.getGenConfig().getVersionByDate(dt.getAttItemInstance().getOrgEndDay());
            QTGenConfigEntry genConfigEntry = curQtGenConfig.getQtGenCfEntryByDetail(dt.getAttItemInstance().getQtDetailId());
            AttItemSpec attAvItemSpec = attItemSpecData.getByBidAndDate(genConfigEntry.getUsableAttItem(), localDate);
            QuotaAttItemValue avAttItemValue = this.buildAvailableAttItem(dt.unwrapAndCopy(), dt.getMatchedRule(), attAvItemSpec);
            avAttItemValues.add(avAttItemValue);
        });
        List<QuotaAttItemValue> noAvZeroList = avAttItemValues.stream().filter(quotaAttItemValue -> BigDecimal.ZERO.compareTo(quotaAttItemValue.getAttItemInstance().getItemValue()) < 0).filter(quotaAttItemValue -> QuotaAttItemStatus.EFFECT == quotaAttItemValue.getAttItemInstance().getStatus()).collect(Collectors.toList());
        List<QuotaAttItemValue> debuctionList = this.deduction(noAvZeroList, burdenList, firstQtCalRule);
        Map<Long, QTLineDetail> oldOverDetailMap = this.getOldQtlineDetails(qtPoolHolder, QuotaDetailType.PRE_OVERDRAFT.getCode(), attFileBoId, periodNum, qtTypeId);
        List<QuotaAttItemValue> overdrawList = this.overdraw(oldOverDetailMap, avAttItemValues, preLineDetails, firstQtCalRule, context, avAttItemValues, emjoyAttItemValues, qtGenConfigEntry, qtLineDetails);
        debuctionList.addAll(overdrawList);
        ArrayList<QuotaAttItemValue> list = new ArrayList<QuotaAttItemValue>(debuctionList.size());
        debuctionList.stream().collect(Collectors.groupingBy(dt -> dt.getAttItemInstance().getQtDetailId(), Collectors.toList())).forEach((k, v) -> v.stream().reduce((v1, v2) -> {
            BigDecimal value = v2.getAttItemInstance().getItemValue().add(v1.getAttItemInstance().getItemValue());
            v2.getAttItemInstance().setItemValue(value);
            return v2;
        }).ifPresent(list::add));
        this.updateLineDate(qtLineDetails, avAttItemValues, list);
        avAttItemValues.addAll(emjoyAttItemValues);
        avAttItemValues.addAll(list);
        return QuotaDataResultStd.success(avAttItemValues);
    }

    private void updateLineDate(List<QTLineDetail> qtLineDetails, List<QuotaAttItemValue> avAttItemValues, List<QuotaAttItemValue> debuctionList) {
        HashMap<Long, QuotaAttItemValue> avUseMap = new HashMap<Long, QuotaAttItemValue>(avAttItemValues.size());
        HashMap<Long, QuotaAttItemValue> debuctionMap = new HashMap<Long, QuotaAttItemValue>(debuctionList.size());
        if (CollectionUtils.isEmpty(qtLineDetails)) {
            return;
        }
        for (QuotaAttItemValue avAttItemValue : avAttItemValues) {
            avUseMap.put(avAttItemValue.getAttItemInstance().getQtDetailId(), avAttItemValue);
        }
        for (QuotaAttItemValue avAttItemValue : debuctionList) {
            debuctionMap.put(avAttItemValue.getAttItemInstance().getQtDetailId(), avAttItemValue);
        }
        qtLineDetails.forEach(detail -> {
            QuotaAttItemValue avAttItem = (QuotaAttItemValue)avUseMap.get(detail.getBid());
            QuotaAttItemValue debuctAttItem = (QuotaAttItemValue)debuctionMap.get(detail.getBid());
            if (avAttItem != null) {
                BigDecimal value = avAttItem.getAttItemInstance().getItemValue();
                BigDecimal debuctValue = debuctAttItem == null ? BigDecimal.ZERO : debuctAttItem.getAttItemInstance().getItemValue();
                detail.setUsableValue(value);
                detail.setBalance(debuctValue);
            }
        });
    }

    private List<QuotaAttItemValue> deduction(List<QuotaAttItemValue> noZeroList, List<QuotaAttItemValue> burdenList, QTCalRule qtCalRule) {
        ArrayList<QuotaAttItemValue> debuctionList = new ArrayList<QuotaAttItemValue>(16);
        if (!CollectionUtils.isEmpty(burdenList)) {
            burdenList.forEach(burdenAttValue -> {
                Date useEndDate = burdenAttValue.getAttItemInstance().getUseEndDate();
                BigDecimal burdOdValue = burdenAttValue.getAttItemInstance().getItemValue();
                Date useStartDate = burdenAttValue.getAttItemInstance().getUseStartDate();
                List itemValues = noZeroList.stream().filter(itemValue -> itemValue.getAttItemInstance().getUseStartDate().compareTo(useEndDate) <= 0 && itemValue.getAttItemInstance().getUseEndDate().compareTo(useStartDate) >= 0).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(itemValues)) {
                    itemValues.sort(Comparator.comparing(dt -> dt.getAttItemInstance().getUseEndDate()));
                    for (QuotaAttItemValue dt2 : itemValues) {
                        QuotaAttItemInstance attItemInstance = dt2.getAttItemInstance();
                        BigDecimal burdValue = burdenAttValue.getAttItemInstance().getItemValue();
                        if (BigDecimal.ZERO.compareTo(burdValue) <= 0) {
                            return;
                        }
                        if (dt2.getAttItemInstance().getItemValue().compareTo(BigDecimal.ZERO) == 0) continue;
                        if (burdValue.abs().compareTo(attItemInstance.getItemValue()) >= 0) {
                            burdValue = burdValue.add(attItemInstance.getItemValue());
                            burdenAttValue.getAttItemInstance().setItemValue(burdValue);
                            debuctionList.add(this.buidDeductionAttItem(dt2, attItemInstance.getItemValue(), qtCalRule));
                            dt2.getAttItemInstance().setItemValue(BigDecimal.ZERO);
                            continue;
                        }
                        dt2.getAttItemInstance().setItemValue(attItemInstance.getItemValue().add(burdValue));
                        debuctionList.add(this.buidDeductionAttItem(dt2, burdValue.abs(), qtCalRule));
                        burdenAttValue.getAttItemInstance().setItemValue(BigDecimal.ZERO);
                        return;
                    }
                    BigDecimal burdValue = burdenAttValue.getAttItemInstance().getItemValue();
                    if (BigDecimal.ZERO.compareTo(burdValue) > 0) {
                        QuotaAttItemInstance attItemInstance = ((QuotaAttItemValue)itemValues.get(0)).getAttItemInstance();
                        BigDecimal value = attItemInstance.getItemValue();
                        value = value.add(burdValue);
                        attItemInstance.setItemValue(value);
                        burdenAttValue.getAttItemInstance().setItemValue(BigDecimal.ZERO);
                        debuctionList.add(this.buidDeductionAttItem((QuotaAttItemValue)itemValues.get(0), burdValue.abs(), qtCalRule));
                    }
                    debuctionList.add(this.buidDeductionAttItem((QuotaAttItemValue)burdenAttValue, burdOdValue, qtCalRule));
                }
            });
        }
        return debuctionList;
    }

    private Date updateOverUseStartTime(Date startDay, QuotaAttItemInstance attItemInstance) {
        if (startDay == null || startDay.after(attItemInstance.getUseStartDate())) {
            return attItemInstance.getUseStartDate();
        }
        return startDay;
    }

    private Date updateOverUseEndTime(Date endDay, QuotaAttItemInstance attItemInstance) {
        if (endDay == null || endDay.before(attItemInstance.getUseEndDate())) {
            return attItemInstance.getUseEndDate();
        }
        return endDay;
    }

    private List<QuotaAttItemValue> overdraw(Map<Long, QTLineDetail> oldOverDetailMap, List<QuotaAttItemValue> noZeroList, List<QTLineDetail> preLineDetails, QTCalRule qtCalRule, QuotaContextStd context, List<QuotaAttItemValue> avAttItemValues, List<QuotaAttItemValue> emjoyAttItemValues, QTGenConfigEntry qtGenConfigEntry, List<QTLineDetail> qtLineDetails) {
        List afterList = noZeroList.stream().filter(item -> BigDecimal.ZERO.compareTo(item.getAttItemInstance().getItemValue()) < 0).filter(item -> QuotaAttItemStatus.EFFECT == item.getAttItemInstance().getStatus()).collect(Collectors.toList());
        List effectList = noZeroList.stream().filter(item -> QuotaAttItemStatus.EFFECT == item.getAttItemInstance().getStatus()).collect(Collectors.toList());
        ArrayList<QuotaAttItemValue> debuctionList = new ArrayList<QuotaAttItemValue>(16);
        if (!CollectionUtils.isEmpty(preLineDetails)) {
            preLineDetails.forEach(detail -> {
                BigDecimal usValue;
                QTLineDetail overQtLine = this.buidOverQTline((QTLineDetail)detail, context, qtCalRule, oldOverDetailMap);
                AtomicReference<BigDecimal> useOdValue = new AtomicReference<BigDecimal>(detail.getUseOdValue().subtract(detail.getBalanceUseOdValue()));
                Date overStartDate = null;
                Date overEndDate = null;
                if (!CollectionUtils.isEmpty((Collection)afterList)) {
                    QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(context.getChainDate());
                    List<Object> lineDetails = new ArrayList();
                    if (QTOffsetSeqEnum.OFFSET_USEENDDATE.getCode().equals(carryDown.getOffsetSeq())) {
                        lineDetails = qtLineDetails.stream().sorted(Comparator.comparing(QTLineDetail::getUseEndDate).thenComparing(QTLineDetail::getCreateTime)).collect(Collectors.toList());
                    } else if (QTOffsetSeqEnum.OFFSET_USESTARTDATE.getCode().equals(carryDown.getOffsetSeq())) {
                        lineDetails = qtLineDetails.stream().sorted(Comparator.comparing(QTLineDetail::getUseStartDate).thenComparing(QTLineDetail::getCreateTime)).collect(Collectors.toList());
                    }
                    Map<Long, QuotaAttItemValue> needDetailMap = afterList.stream().collect(Collectors.groupingBy(qt -> qt.getAttItemInstance().getQtDetailId(), Collectors.collectingAndThen(Collectors.toList(), value -> (QuotaAttItemValue)value.get(0))));
                    for (QTLineDetail qTLineDetail : lineDetails) {
                        QuotaAttItemValue dt = needDetailMap.get(qTLineDetail.getBid());
                        if (dt == null) continue;
                        if (BigDecimal.ZERO.compareTo(useOdValue.get()) >= 0) break;
                        if (dt.getAttItemInstance().getItemValue().compareTo(BigDecimal.ZERO) == 0) continue;
                        QuotaAttItemInstance attItemInstance = dt.getAttItemInstance();
                        if (useOdValue.get().compareTo(attItemInstance.getItemValue()) > 0) {
                            useOdValue.set(useOdValue.get().subtract(attItemInstance.getItemValue()));
                            debuctionList.add(this.buidDeductionAttItem(dt, attItemInstance.getItemValue(), qtCalRule));
                            overStartDate = this.updateOverUseStartTime(overStartDate, attItemInstance);
                            overEndDate = this.updateOverUseEndTime(overEndDate, attItemInstance);
                            dt.getAttItemInstance().setItemValue(BigDecimal.ZERO);
                            continue;
                        }
                        BigDecimal value2 = useOdValue.get();
                        useOdValue.set(BigDecimal.ZERO);
                        dt.getAttItemInstance().setItemValue(attItemInstance.getItemValue().subtract(value2));
                        overStartDate = this.updateOverUseStartTime(overStartDate, attItemInstance);
                        overEndDate = this.updateOverUseEndTime(overEndDate, attItemInstance);
                        debuctionList.add(this.buidDeductionAttItem(dt, value2, qtCalRule));
                    }
                }
                if (BigDecimal.ZERO.compareTo(usValue = useOdValue.get()) < 0 && !CollectionUtils.isEmpty((Collection)effectList)) {
                    QuotaAttItemInstance attItemInstance = ((QuotaAttItemValue)effectList.get(0)).getAttItemInstance();
                    BigDecimal value3 = attItemInstance.getItemValue();
                    value3 = value3.subtract(usValue);
                    attItemInstance.setItemValue(value3);
                    overStartDate = this.updateOverUseStartTime(overStartDate, attItemInstance);
                    overEndDate = this.updateOverUseEndTime(overEndDate, attItemInstance);
                    debuctionList.add(this.buidDeductionAttItem((QuotaAttItemValue)effectList.get(0), usValue, qtCalRule));
                    useOdValue.set(BigDecimal.ZERO);
                }
                if (overStartDate != null) {
                    overQtLine.setUseStartDate(overStartDate);
                }
                if (overEndDate != null) {
                    overQtLine.setUseEndDate(overEndDate);
                }
                overQtLine.setUsableValue(useOdValue.get().negate());
                this.buidOverAttItem(overQtLine, qtGenConfigEntry, context, qtCalRule, avAttItemValues, emjoyAttItemValues, debuctionList);
                qtLineDetails.add(overQtLine);
            });
        }
        return debuctionList;
    }

    private QuotaAttItemValue buidAttItem(AttItemSpec attItemSpec, QTLineDetail qtLineDetail, QuotaContextStd context, QTCalRule qtCalRule, long cycSet) {
        Long qtTypeId = context.getQuotaTypeId();
        CircleRestVo circleRestVo = context.getCircleRestVo();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtLineDetail.getBid(), attItemSpec, qtLineDetail.getOwnValue(), AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.DURATION_ENJOYMENT, QuotaDetailType.PRE_PERIOD_CARRY_DOWN, qtTypeId, cycSet, circleRestVo.getIndex(), circleRestVo.getAssignDate(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getCrossStartdate(), qtLineDetail.getCrossEnddate());
        quotaAttItemInstance.setOrgEndDay(context.getChainDate());
        quotaAttItemInstance.setAttFileVId(qtLineDetail.getAttFileVid());
        quotaAttItemInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).build();
        attItemValue.setMatchedRule(qtCalRule);
        return attItemValue;
    }

    private QuotaAttItemValue buidOverEnjoyAttItem(AttItemSpec attItemSpec, QTLineDetail qtLineDetail, QuotaContextStd context, QTCalRule qtCalRule, long cycSet) {
        Long qtTypeId = context.getQuotaTypeId();
        CircleRestVo circleRestVo = context.getCircleRestVo();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtLineDetail.getBid(), attItemSpec, qtLineDetail.getOwnValue(), AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.DURATION_ENJOYMENT, QuotaDetailType.PRE_OVERDRAFT, qtTypeId, cycSet, circleRestVo.getIndex(), circleRestVo.getAssignDate(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getCrossStartdate(), qtLineDetail.getCrossEnddate());
        quotaAttItemInstance.setOrgEndDay(context.getChainDate());
        quotaAttItemInstance.setAttFileVId(qtLineDetail.getAttFileVid());
        quotaAttItemInstance.setAttFileBoId(qtLineDetail.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).build();
        attItemValue.setMatchedRule(qtCalRule);
        return attItemValue;
    }

    private QuotaAttItemValue buidDeductionAttItem(QuotaAttItemValue quotaAttItemValue, BigDecimal value, QTCalRule qtCalRule) {
        QuotaAttItemInstance attItemInstance = quotaAttItemValue.getAttItemInstance();
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), value, attItemInstance.getUntil(), QuotaAttItemType.QUIT_CODE, attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion(), attItemInstance.getGenStartDate(), attItemInstance.getGenEndDate(), attItemInstance.getUseStartDate(), attItemInstance.getUseEndDate(), attItemInstance.getChangeSatrt(), attItemInstance.getChangeEnd());
        quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).build();
        attItemValue.setMatchedRule(qtCalRule);
        return attItemValue;
    }

    private QuotaAttItemValue buildAvailableAttItem(QuotaAttItemValue quotaAttItemValue, IEntity qtCalRule, AttItemSpec attItemSpec) {
        QuotaAttItemInstance attItemInstance = quotaAttItemValue.getAttItemInstance();
        QuotaAttItemInstance avQuotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemSpec, attItemInstance.getItemValue(), AttitemUnitEnum.of((String)attItemSpec.getUnit()), QuotaAttItemType.AVAILABLE, attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion(), attItemInstance.getGenStartDate(), attItemInstance.getGenEndDate(), attItemInstance.getUseStartDate(), attItemInstance.getUseEndDate(), attItemInstance.getChangeSatrt(), attItemInstance.getChangeEnd());
        avQuotaAttItemInstance.setStatus(attItemInstance.getStatus());
        avQuotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
        avQuotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
        avQuotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
        QuotaAttItemValue avAttItemValue = (QuotaAttItemValue)((CleanableBuilder)QuotaAttItemValue.builder().attItemInstance(avQuotaAttItemInstance)).build();
        avAttItemValue.setMatchedRule(qtCalRule);
        return avAttItemValue;
    }

    private QTLineDetail buidOverQTline(QTLineDetail qtLineDetail, QuotaContextStd context, QTCalRule qtCalRule, Map<Long, QTLineDetail> oldOverDetailMap) {
        LocalDate localDate = context.getChainDate();
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        int periodNum = context.getCircleRestVo().getIndex();
        QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(localDate);
        QTLineDetail oldQtDetail = oldOverDetailMap.get(qtLineDetail.getBid());
        BigDecimal useOdValue = qtLineDetail.getUseOdValue().subtract(qtLineDetail.getBalanceUseOdValue());
        QTLineDetail qtDetail = oldQtDetail == null ? new QTLineDetail() : oldQtDetail;
        Date createTime = qtDetail.getCreateTime();
        if (createTime == null) {
            qtDetail.setCreateTime(new Date());
        }
        qtDetail.setDetailSourceId(qtLineDetail.getBid());
        qtDetail.rememberOriginalId();
        QuotaDetailClearUtils.rememberOldReferAndClearNoGenValue(qtDetail);
        qtDetail.setId(IDService.get().genLongId());
        qtDetail.setAttFileBoId(attFileModel.getBid());
        qtDetail.setOrgId(attFileModel.getOrgId().longValue());
        qtDetail.setAttFileVid(attFileModel.getId());
        qtDetail.setQtTypeId(qtLineDetail.getQtTypeId());
        qtDetail.setpCycleId(qtGenConfig.getCycSet());
        qtDetail.setPeriodNum(periodNum);
        qtDetail.setSource(QuotaDetailType.PRE_OVERDRAFT.getCode());
        qtDetail.setGenStartDate(qtLineDetail.getGenStartDate());
        qtDetail.setGenEndDate(qtLineDetail.getGenEndDate());
        qtDetail.setUseStartDate(qtLineDetail.getUseStartDate());
        qtDetail.setUseEndDate(qtLineDetail.getUseEndDate());
        qtDetail.setGenValue(useOdValue.negate());
        qtDetail.setOwnValue(useOdValue.negate());
        qtDetail.setUsableValue(useOdValue.negate());
        return qtDetail;
    }

    private void buidOverAttItem(QTLineDetail qtLineDetail, QTGenConfigEntry qtGenConfigEntry, QuotaContextStd context, QTCalRule qtCalRule, List<QuotaAttItemValue> avAttItemValues, List<QuotaAttItemValue> emjoyAttItemValues, List<QuotaAttItemValue> debuctionList) {
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        LocalDate localDate = context.getChainDate();
        AttItemSpec avAttItemSpec = attItemSpecData.getByBidAndDate(qtGenConfigEntry.getUsableAttItem(), localDate);
        QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(localDate);
        QTGenConfigEntry preEntry = qtGenConfig.getQtGenCfEntryByDetail(qtLineDetail.getBid());
        preEntry = preEntry == null ? qtGenConfigEntry : preEntry;
        qtGenConfig.putQtGenCfEntryByDetail(qtLineDetail.getBid(), preEntry);
        AttItemSpec overAttItem = attItemSpecData.getByBidAndDate(preEntry.getEnjoyAttItem(), localDate);
        QuotaAttItemValue attItemValue = this.buidOverEnjoyAttItem(overAttItem, qtLineDetail, context, qtCalRule, qtGenConfig.getCycSet());
        attItemValue.setMatchedRule(qtCalRule);
        QuotaAttItemValue avAttItemValue = this.buildAvailableAttItem(attItemValue, qtCalRule, avAttItemSpec);
        BigDecimal ownValue = qtLineDetail.getOwnValue();
        BigDecimal useValue = qtLineDetail.getUsableValue();
        BigDecimal banceValue = ownValue.subtract(useValue);
        if (banceValue.compareTo(BigDecimal.ZERO) != 0) {
            QuotaAttItemValue deubctionItem = this.buidDeductionAttItem(attItemValue, banceValue, qtCalRule);
            debuctionList.add(deubctionItem);
        }
        avAttItemValue.getAttItemInstance().setItemValue(useValue);
        avAttItemValues.add(avAttItemValue);
        emjoyAttItemValues.add(attItemValue);
    }

    private Map<Long, QTLineDetail> getOldQtlineDetails(QTPoolHolder qtPoolHolder, String source, long attFileBoId, int periodNum, long qtTypeId) {
        if (qtPoolHolder == null) {
            return new HashMap<Long, QTLineDetail>();
        }
        List<QTLineDetail> preDetails = qtPoolHolder.getQtPoolByFileBoId(attFileBoId, periodNum, qtTypeId);
        if (preDetails == null) {
            return new HashMap<Long, QTLineDetail>();
        }
        return preDetails.stream().filter(detail -> detail.getSource().equals(source)).collect(Collectors.groupingBy(detail -> detail.getDetailSourceId(), Collectors.collectingAndThen(Collectors.toList(), value -> (QTLineDetail)value.get(0))));
    }

    private void getPreDetailsByBo(List<QTLineDetail> currLineDetails, AttFileCabinet attFileCabinet, QTGenConfig firstQtGenConfig, QTPoolHolder qtPoolHolder, QuotaContextStd context, Date boStartDate) {
        List preBodetails;
        if (!QTCrossMangOrgEnum.CROSS_CARYY_DOWN.type.equals(firstQtGenConfig.getCrossMangOrg())) {
            return;
        }
        logger.info("context circlerestVo {}", (Object)JSON.toJSONString((Object)context.getCircleRestVo()));
        Long qtTypeId = context.getQuotaTypeId();
        Long preCycSet = context.getCircleRestVo().getPreCycSetId();
        if (preCycSet == null || preCycSet == 0L) {
            return;
        }
        if (firstQtGenConfig.getQtType() == null) {
            logger.info("qttyple is empty");
        }
        Integer prePeriodNum = context.getCircleRestVo().getPreIndex();
        String preKey = DetailLogicKey.getIndexKey((long)context.getCircleRestVo().getPreAttFileBoId(), (long)firstQtGenConfig.getQtType().getId(), (long)preCycSet, (long)prePeriodNum.intValue());
        List<QTLineDetail> preBoQtLineDetails = (List<QTLineDetail>)context.getVariable(preKey, VScope.LINE);
        if (CollectionUtils.isEmpty((Collection)preBoQtLineDetails)) {
            preBoQtLineDetails = qtPoolHolder.getQtPoolByFileBoId(context.getCircleRestVo().getPreAttFileBoId(), prePeriodNum, qtTypeId);
        }
        if (CollectionUtils.isNotEmpty((Collection)preBoQtLineDetails) && !CollectionUtils.isEmpty(preBodetails = preBoQtLineDetails.stream().filter(detail -> BigDecimal.ZERO.compareTo(detail.getCarryDownedValue()) != 0).filter(detail -> QuotaAttItemStatus.EFFECT.getCode().equals(detail.getBusstatus()) || QuotaDetailType.BO_PERIOD_CARRY_DOWN.getCode().equals(detail.getSource())).filter(detail -> !VestTypeEnum.BUSINESS_AREA.getCode().equals(detail.getVestType()) && !VestTypeEnum.DEPART.getCode().equals(detail.getVestType())).collect(Collectors.toList()))) {
            currLineDetails.addAll(preBodetails);
        }
    }
}

