/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.generate;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailUseQualification;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.executor.generate.QTQualificationsEvaluator;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTUseQualificationsEvaluator
extends QTQualificationsEvaluator
implements QuotaEvaluatorStd {
    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context) {
        return this.doEvaluate(context, context.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd context, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4eab\u6709\u65f6\u957f\u751f\u6210\u3002", (String)"QTUseQualificationsEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        List<QuotaAttItemValueStd> quotaAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(quotaAttStds = quotaAttStds.stream().filter(dataNode -> dataNode.isLeaf() && QuotaAttItemType.DURATION_ENJOYMENT == dataNode.getAttItemInstance().getQuotaAttItemType()).collect(Collectors.toList()))) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.INFO, ResManager.loadKDString((String)"\u6ca1\u6709\u4eab\u6709\u65f6\u957f\u751f\u6210\u3002", (String)"QTUseQualificationsEvaluator_0", (String)"wtc-wtes-business", (Object[])new Object[0])));
        }
        LocalDate localDate = context.getChainDate();
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        ArrayList<QuotaAttItemValue> avAttItemValues = new ArrayList<QuotaAttItemValue>(quotaAttStds.size());
        quotaAttStds.forEach(quotaAttItemValueStd -> {
            QTCalRule qtCalRule = (QTCalRule)quotaAttItemValueStd.getMatchedRule();
            if (qtCalRule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u3002", (String)"QTUseQualificationsEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(quotaAttItemValueStd.getAttItemInstance().getOrgEndDay());
            if (qtCalRule.getUseQualification() == null) {
                return;
            }
            QTQualification qtQualification = (QTQualification)qtCalRule.getUseQualification().getVersionByDate(quotaAttItemValueStd.getAttItemInstance().getOrgEndDay());
            if (qtQualification == null) {
                return;
            }
            if (this.checkCondition(qtQualification, context)) {
                QuotaAttItemInstance attItemInstance = quotaAttItemValueStd.getAttItemInstance();
                BigDecimal value = this.convertedValue(context, attItemInstance.getQtDetailId(), qtGenConfig, qtQualification, quotaAttItemValueStd.getAttItemInstance().getItemValue());
                Date genStartDate = attItemInstance.getGenStartDate();
                Date genEndDate = attItemInstance.getGenEndDate();
                Date useEndDate = attItemInstance.getUseEndDate();
                Date useStartDate = attItemInstance.getUseStartDate();
                QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(attItemInstance.getQtDetailId(), attItemInstance.getAttItemSpec(), value, attItemInstance.getUntil(), attItemInstance.getQuotaAttItemType(), attItemInstance.getSource(), attItemInstance.getQttypeId(), attItemInstance.getPeriodcircleId(), attItemInstance.getPeriodNum(), attItemInstance.getPeriodAttribtion());
                quotaAttItemInstance.setGenEndDate(genEndDate);
                quotaAttItemInstance.setGenStartDate(genStartDate);
                quotaAttItemInstance.setUseEndDate(useEndDate);
                quotaAttItemInstance.setUseStartDate(useStartDate);
                quotaAttItemInstance.setChangeEnd(attItemInstance.getChangeEnd());
                quotaAttItemInstance.setChangeSatrt(attItemInstance.getChangeSatrt());
                quotaAttItemInstance.setOrgEndDay(attItemInstance.getOrgEndDay());
                quotaAttItemInstance.setAttFileVId(attItemInstance.getAttFileVId());
                quotaAttItemInstance.setAttFileBoId(attItemInstance.getAttFileBoId());
                QuotaAttItemValue attItemValue = (QuotaAttItemValue)((CleanableBuilder)((QuotaAttItemValue.Builder)QuotaAttItemValue.builder().appendParentDataNode((QuotaDataNodeStd)quotaAttItemValueStd)).attItemInstance(quotaAttItemInstance)).build();
                attItemValue.setEvaluationRule(EvaluationRuleModel.of(qtQualification.getId(), "wtp_qtqualification"));
                attItemValue.setMatchedRule(quotaAttItemValueStd.getMatchedRule());
                avAttItemValues.add(attItemValue);
                String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)attItemInstance.getQttypeId(), (long)attItemInstance.getPeriodcircleId(), (long)attItemInstance.getPeriodNum().intValue());
                List qtDetails = (List)context.getVariable(key, VScope.LINE);
                if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                    BigDecimal finalItemValue = value;
                    qtDetails.forEach(qtLineDetail -> {
                        if (qtLineDetail.getBid() == attItemInstance.getQtDetailId().longValue()) {
                            qtLineDetail.setOwnValue(finalItemValue);
                        }
                    });
                }
            }
        });
        QteGenExtPluginUtils.afterDoEvalua(context, avAttItemValues, "useql", QTUseQualificationsEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(avAttItemValues);
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailUseQualification detailStandardGen = new QuotaDetailUseQualification(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        return detailStandardGen;
    }
}

