/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.executor.overdraft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetailOverdrawQl;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValueStd;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.executor.generate.QTQualificationsEvaluator;
import kd.wtc.wtes.business.quota.executor.overdraft.QTOverdraftDurationEvaluator;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaDataNodeStd;
import kd.wtc.wtes.business.quota.std.QuotaDataResultStd;
import kd.wtc.wtes.business.quota.std.QuotaEvaluatorStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QteGenExtPluginUtils;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;

public class QTOverdraftLimitEvaluator
extends QTQualificationsEvaluator
implements QuotaEvaluatorStd {
    private static final Log LOG = LogFactory.getLog(QTOverdraftDurationEvaluator.class);

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd) {
        return this.doEvaluate(contextStd, contextStd.getAllDataNodes());
    }

    @Override
    public QuotaDataResultStd doEvaluate(QuotaContextStd contextStd, List<QuotaDataNodeStd> dataNodes) {
        if (CollectionUtils.isEmpty(dataNodes)) {
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTOverdraftLimitEvaluator not found dataNodes"));
        }
        LinkedList<QuotaAttItemValue> quotaDataNodeList = new LinkedList<QuotaAttItemValue>();
        List<QuotaAttItemValueStd> allAttStds = dataNodes.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
        ArrayList<QuotaAttItemValueStd> overdrawStds = new ArrayList<QuotaAttItemValueStd>(4);
        for (QuotaAttItemValueStd node : allAttStds) {
            QuotaAttItemInstance instance = node.getAttItemInstance();
            if (null == instance || !instance.getQuotaAttItemType().code.equals(QuotaAttItemType.OVERDRAW_AVAILABLE.code) || !node.isLeaf()) continue;
            overdrawStds.add(node);
        }
        if (CollectionUtils.isEmpty(overdrawStds)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTOverdraftLimitEvaluator not found overdraw AttItemInstance");
            }
            return QuotaDataResultStd.exclusion(new QuotaMessageStd(QuotaMsgLevel.WARNING, "QTOverdraftLimitEvaluator not found overdraw AttItemInstance"));
        }
        for (QuotaAttItemValueStd overdraw : overdrawStds) {
            this.processOverdraftLimit(overdraw, quotaDataNodeList, contextStd, allAttStds);
        }
        QteGenExtPluginUtils.afterDoEvalua(contextStd, quotaDataNodeList, "overql", QTOverdraftLimitEvaluator::buildQuotaDetail);
        return QuotaDataResultStd.success(quotaDataNodeList);
    }

    private void processOverdraftLimit(QuotaAttItemValueStd overdraw, List<QuotaAttItemValue> quotaDataNodeList, QuotaContextStd contextStd, List<QuotaAttItemValueStd> allAttStds) {
        QuotaAttItemInstance overInstance = overdraw.getAttItemInstance();
        QTCalRule qtCalRule = (QTCalRule)overdraw.getMatchedRule();
        if (qtCalRule == null || qtCalRule.getOverDraw() == null) {
            LOG.info("QTOverdraftDurationEvaluator not found qtCalRule");
            return;
        }
        if (null == qtCalRule.getOverQualification()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("QTOverdraftDurationEvaluator not found OverDraw Qualification");
            }
            return;
        }
        QTQualification qtQualification = (QTQualification)qtCalRule.getOverQualification().getVersionByDate(overInstance.getOrgEndDay());
        if (qtQualification == null) {
            LOG.warn("QTOverdraftDurationEvaluator not found OverDraw Qualification version");
            return;
        }
        boolean parseCondition = this.checkCondition(qtQualification, contextStd);
        long qtDetailId = overdraw.getAttItemInstance().getQtDetailId();
        AttFileCabinet attFileCabinet = contextStd.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)overInstance.getQttypeId(), (long)overInstance.getPeriodcircleId(), (long)overInstance.getPeriodNum().intValue());
        List qtDetails = (List)contextStd.getVariable(key, VScope.LINE);
        BigDecimal stdAmount = null;
        if (parseCondition) {
            QuotaAttItemInstance instance;
            if (HRStringUtils.equals((String)qtQualification.getLimitMethod(), (String)"A")) {
                instance = new QuotaAttItemInstance(qtDetailId, overInstance.getAttItemSpec(), qtQualification.getLimitQuatity(), AttitemUnitEnum.of((String)overInstance.getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, overInstance.getSource(), overInstance.getQttypeId(), overInstance.getPeriodcircleId(), overInstance.getPeriodNum(), overInstance.getPeriodAttribtion());
                instance.setChangeSatrt(overInstance.getChangeSatrt());
                instance.setChangeEnd(overInstance.getChangeEnd());
                instance.setOrgEndDay(overInstance.getOrgEndDay());
                instance.setAttFileBoId(overInstance.getAttFileBoId());
                instance.setAttFileVId(overInstance.getAttFileVId());
                stdAmount = qtQualification.getLimitQuatity();
            } else {
                if (overdraw.getAttItemInstance().getItemValue().compareTo(BigDecimal.ZERO) <= 0) {
                    LOG.info("QTOverdraftDurationEvaluator illegal overdraw value");
                    return;
                }
                BigDecimal amount = overdraw.getAttItemInstance().getItemValue().multiply(qtQualification.getLimitPercent()).multiply(BigDecimal.valueOf(0.01));
                QTOverDraw qtOverConfig = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(contextStd.getChainDate());
                long roundRuleId = qtOverConfig.getRoundRule();
                BigDecimal roundResult = QuotaContextUtil.roundValue(contextStd, roundRuleId, amount);
                instance = new QuotaAttItemInstance(qtDetailId, overInstance.getAttItemSpec(), roundResult, AttitemUnitEnum.of((String)overInstance.getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_AVAILABLE, overInstance.getSource(), overInstance.getQttypeId(), overInstance.getPeriodcircleId(), overInstance.getPeriodNum(), overInstance.getPeriodAttribtion());
                instance.setChangeSatrt(overInstance.getChangeSatrt());
                instance.setChangeEnd(overInstance.getChangeEnd());
                instance.setOrgEndDay(overInstance.getOrgEndDay());
                instance.setAttFileBoId(overInstance.getAttFileBoId());
                instance.setAttFileVId(overInstance.getAttFileVId());
                stdAmount = roundResult;
            }
            BigDecimal finalItemValue = stdAmount;
            if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                qtDetails.forEach(qtLineDetail -> {
                    if (qtLineDetail.getBid() == overInstance.getQtDetailId().longValue()) {
                        qtLineDetail.setCanBeOdValue(finalItemValue);
                    }
                });
            }
            QuotaAttItemValue quotaAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(instance)).matchedRule(overdraw.getMatchedRule())).parentDataNodes(Collections.singletonList(overdraw))).evaluationRule(EvaluationRuleModel.of(qtQualification.getId(), "wtp_qtqualification"))).build();
            quotaAttItemValue.getAttItemInstance().setGenStartDate(overdraw.getAttItemInstance().getGenStartDate());
            quotaAttItemValue.getAttItemInstance().setGenEndDate(overdraw.getAttItemInstance().getGenEndDate());
            quotaAttItemValue.getAttItemInstance().setUseStartDate(overdraw.getAttItemInstance().getUseStartDate());
            quotaAttItemValue.getAttItemInstance().setUseEndDate(overdraw.getAttItemInstance().getUseEndDate());
            instance.setChangeSatrt(overdraw.getAttItemInstance().getChangeSatrt());
            instance.setChangeEnd(overdraw.getAttItemInstance().getChangeEnd());
            instance.setOrgEndDay(overdraw.getAttItemInstance().getOrgEndDay());
            quotaDataNodeList.add(quotaAttItemValue);
            List attItemValueStds = allAttStds.stream().map(QuotaAttItemValueStd.class::cast).collect(Collectors.toList());
            QuotaAttItemValueStd overStd = null;
            for (QuotaAttItemValueStd node : attItemValueStds) {
                if (QuotaAttItemType.OVERDRAW_STANDARD != node.getAttItemInstance().getQuotaAttItemType() || qtDetailId != node.getAttItemInstance().getQtDetailId()) continue;
                overStd = node;
                break;
            }
            if (null != overStd && null != stdAmount) {
                QuotaAttItemInstance stdInstance = new QuotaAttItemInstance(qtDetailId, overStd.getAttItemInstance().getAttItemSpec(), stdAmount, AttitemUnitEnum.of((String)overStd.getAttItemInstance().getAttItemSpec().getUnit()), QuotaAttItemType.OVERDRAW_STANDARD, overStd.getAttItemInstance().getSource(), overStd.getAttItemInstance().getQttypeId(), overStd.getAttItemInstance().getPeriodcircleId(), overStd.getAttItemInstance().getPeriodNum(), overStd.getAttItemInstance().getPeriodAttribtion());
                stdInstance.setGenStartDate(overStd.getAttItemInstance().getGenStartDate());
                stdInstance.setGenEndDate(overStd.getAttItemInstance().getGenEndDate());
                stdInstance.setUseStartDate(overStd.getAttItemInstance().getUseStartDate());
                stdInstance.setUseEndDate(overStd.getAttItemInstance().getUseEndDate());
                instance.setChangeSatrt(overStd.getAttItemInstance().getChangeSatrt());
                instance.setChangeEnd(overStd.getAttItemInstance().getChangeEnd());
                instance.setOrgEndDay(overStd.getAttItemInstance().getOrgEndDay());
                instance.setAttFileBoId(overStd.getAttItemInstance().getAttFileBoId());
                instance.setAttFileVId(overStd.getAttItemInstance().getAttFileVId());
                QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(stdInstance)).matchedRule(overStd.getMatchedRule())).parentDataNodes(Collections.singletonList(overStd))).evaluationRule(EvaluationRuleModel.of(qtQualification.getId(), "wtp_qtqualification"))).build();
                if (!CollectionUtils.isEmpty((Collection)qtDetails)) {
                    qtDetails.forEach(qtLineDetail -> {
                        if (qtLineDetail.getBid() == overInstance.getQtDetailId().longValue()) {
                            qtLineDetail.setOwnOdValue(finalItemValue);
                        }
                    });
                }
                quotaDataNodeList.add(quotaSdtAttItemValue);
            }
        }
    }

    public static QuotaDetail buildQuotaDetail(QTLineDetail qtLineDetail, Date changeDate) {
        QuotaDetailOverdrawQl detailStandardGen = new QuotaDetailOverdrawQl(qtLineDetail.getBid(), qtLineDetail.getAttFileVid(), qtLineDetail.getOrgId(), qtLineDetail.getQtTypeId(), qtLineDetail.getpCycleId(), qtLineDetail.getPeriodNum(), qtLineDetail.getSource(), qtLineDetail.getGenValue(), qtLineDetail.getGenStartDate(), qtLineDetail.getGenEndDate(), qtLineDetail.getUseStartDate(), qtLineDetail.getUseEndDate(), qtLineDetail.getOwnValue(), qtLineDetail.getOwnOdValue(), qtLineDetail.getUsableValue(), qtLineDetail.getCanBeOdValue(), changeDate);
        return detailStandardGen;
    }
}

