/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.sdk.wtc.wtbs.common.model.AbstractExtendableObj;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.common.lang.NotNull;

public class QuotaInitParamRequest
extends AbstractExtendableObj
implements InitParam {
    private final List<Long> attPersonIds;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final QuotaRequest request;
    private final Map<String, Object> initParams = new HashMap<String, Object>(16);
    private List<AttPersonRange> attSubjects;

    @Deprecated
    public QuotaInitParamRequest(List<Long> attPersonIds, LocalDate startDate, LocalDate endDate, QuotaRequest request) {
        if (attPersonIds == null || startDate == null || endDate == null || request == null) {
            throw new NullPointerException();
        }
        this.attPersonIds = attPersonIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.request = request;
    }

    @Override
    @NotNull
    public List<Long> getAttPersonIds() {
        return this.attPersonIds;
    }

    @Override
    @NotNull
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Override
    @NotNull
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public QuotaRequest getRequest() {
        return this.request;
    }

    @Override
    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public void putInitParams(Map<String, Object> map) {
        this.initParams.putAll(map);
    }

    public String toString() {
        return "InitParamRequest{attPersonIds=" + this.attPersonIds + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", request=" + this.request + '}';
    }

    public List<AttPersonRange> getAttSubjects() {
        return this.attSubjects;
    }

    @Override
    public List<Long> getAttFileBoIdList() {
        return this.attSubjects.stream().map(AttPersonRange::getAttFileBaseBoId).collect(Collectors.toList());
    }

    @Override
    public long getNationalityId() {
        return 0L;
    }

    public QuotaInitParamRequest(List<Long> attPersonIds, LocalDate startDate, LocalDate endDate, QuotaRequest request, List<AttPersonRange> attSubjects) {
        if (attPersonIds == null || startDate == null || endDate == null || request == null) {
            throw new NullPointerException();
        }
        this.attPersonIds = attPersonIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.request = request;
        this.attSubjects = attSubjects;
    }
}

