/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.model.QuotaDetailAddData;
import kd.wtc.wtes.common.util.CollectionUtils;

public class TieInitDetailAddForQuota
implements QuotaParamInitializer {
    private static final Log log = LogFactory.getLog(TieInitDetailAddForQuota.class);
    private static final String QUERY_PROP = "entryentity.quotatype.id,id,entryentity.attfilebase.id,entryentity.attfilebase.boid,entryentity.value,entryentity.genestartdate,entryentity.useenddate,entryentity.usestartdate,isdpconvert";
    private final HRBaseServiceHelper quotaDetailAddServiceHelper = new HRBaseServiceHelper("wtte_quotadetailadd");

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        List<Long> regQtTypeIds;
        if (QTAccountModeHelper.isDeductChain((String)initRequest.getRequest().getAccountMode())) {
            return QuotaInitParamResult.success(QuotaDetailAddData.of(null));
        }
        log.debug("TieInitDetailAddForQuota{}", (Object)initRequest.getRequest().getVersion());
        ArrayList qtTypeIds = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        if (!CollectionUtils.isEmpty(dyQtTypeIds)) {
            qtTypeIds.addAll(dyQtTypeIds);
        }
        if (!CollectionUtils.isEmpty(regQtTypeIds = initRequest.getRequest().getRegQtTypeIds())) {
            qtTypeIds.addAll(regQtTypeIds);
        }
        List<AttPersonRange> attPersonRanges = initRequest.getAttSubjects();
        ArrayList<Long> attfileBoidList = new ArrayList<Long>();
        for (AttPersonRange attPersonRange : attPersonRanges) {
            attfileBoidList.addAll(attPersonRange.getAllFileBoIdList());
        }
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        QFilter[] qFilters = TieInitDetailAddForQuota.getQueryCondition(startDate, endDate, attfileBoidList, qtTypeIds);
        DynamicObject[] dynamicObjects = this.quotaDetailAddServiceHelper.queryOriginalArray(QUERY_PROP, qFilters);
        return QuotaInitParamResult.success(QuotaDetailAddData.of(dynamicObjects));
    }

    private static QFilter[] getQueryCondition(LocalDate fromDate, LocalDate toDate, List<Long> attFileBoidList, List<Long> regQtTypeIds) {
        QFilter regQtTypeIdsFilter = new QFilter("entryentity.quotatype", "in", regQtTypeIds);
        QFilter attFileBoidListFilter = new QFilter("entryentity.attfilebase.boid", "in", attFileBoidList);
        QFilter fromDateFilter = new QFilter("entryentity.genestartdate", "<=", (Object)toDate);
        QFilter toDateDateFilter = new QFilter("entryentity.genestartdate", ">=", (Object)fromDate);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return new QFilter[]{statusFilter, fromDateFilter, toDateDateFilter, attFileBoidListFilter, regQtTypeIdsFilter};
    }

    @Override
    public String category() {
        return "QT_ADD";
    }
}

