/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.init;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtes.business.quota.QuotaMsgLevel;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QTTieRetrievalUtil;

public class TieInitQTRetrievalForQuota
implements QuotaParamInitializer {
    private static final Log LOG = LogFactory.getLog(TieInitQTRetrievalForQuota.class);

    @Override
    public QuotaInitParamResult init(QuotaInitParamRequest initRequest) throws QuotaParamInitException {
        try {
            QTTieRetrievalUtil qtTieRetrievalUtil = new QTTieRetrievalUtil(initRequest);
            return QuotaInitParamResult.success(qtTieRetrievalUtil.getQTRetrievalResult());
        }
        catch (KDException exception) {
            QuotaMessageStd msg = new QuotaMessageStd(QuotaMsgLevel.ERROR, exception.getMessage());
            return QuotaInitParamResult.success(msg);
        }
        catch (Exception ex) {
            String errorMsg = ResManager.loadKDString((String)"\u5b9a\u989d\u8ba1\u7b97\u89c4\u5219\u53d6\u6570\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"TieInitQTRetrievalForQuota_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
            LOG.warn(errorMsg, (Throwable)ex);
            QuotaMessageStd msg = new QuotaMessageStd(QuotaMsgLevel.ERROR, errorMsg);
            return QuotaInitParamResult.success(msg);
        }
    }

    @Override
    public String category() {
        return "QTRETRIEVEL";
    }
}

